/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import gorsat.BatchedReadSourceConfig;
import gorsat.process.GorPipeFirstOrderCommands;
import gorsat.process.PipeOptions;
import java.util.Map;
import org.gorpipe.base.config.ConfigManager;
import org.gorpipe.exceptions.ExceptionUtilities;
import org.gorpipe.exceptions.GorException;
import org.gorpipe.gor.model.DbSource;
import org.gorpipe.gor.model.DefaultFileReader;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.servers.GorConfig;
import org.gorpipe.gor.util.ConfigUtil;
import org.gorpipe.spark.GorSparkUtilities;
import org.gorpipe.spark.SparkGorExecutionEngine;
import org.gorpipe.spark.SparkGorMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.Tuple2;

public final class SparkPipe$
implements GorPipeFirstOrderCommands {
    public static SparkPipe$ MODULE$;
    private final Logger logger;
    private final Logger consoleLogger;
    private String version;
    private final BatchedReadSourceConfig brsConfig;
    private final GorConfig gorConfig;

    static {
        new SparkPipe$();
    }

    public void helpCommand(String[] args, FileReader fileReader) {
        GorPipeFirstOrderCommands.helpCommand$((GorPipeFirstOrderCommands)this, (String[])args, (FileReader)fileReader);
    }

    public Tuple2<String, String[]> helpFileOpt(String[] args, FileReader fileReader) {
        return GorPipeFirstOrderCommands.helpFileOpt$((GorPipeFirstOrderCommands)this, (String[])args, (FileReader)fileReader);
    }

    public String[] getHelpListFromFiles() {
        return GorPipeFirstOrderCommands.getHelpListFromFiles$((GorPipeFirstOrderCommands)this);
    }

    private Logger logger() {
        return this.logger;
    }

    private Logger consoleLogger() {
        return this.consoleLogger;
    }

    public String version() {
        return this.version;
    }

    public void version_$eq(String x$1) {
        this.version = x$1;
    }

    public BatchedReadSourceConfig brsConfig() {
        return this.brsConfig;
    }

    public GorConfig gorConfig() {
        return this.gorConfig;
    }

    public void main(String[] args) {
        if (args.length < 1 || args[0].isEmpty() || args[0].toUpperCase().startsWith("HELP")) {
            this.helpCommand(args, (FileReader)new DefaultFileReader(""));
            System.exit(0);
        }
        PipeOptions commandlineOptions = new PipeOptions();
        commandlineOptions.parseOptions(args);
        ExceptionUtilities.setShowStackTrace((Boolean)Predef$.MODULE$.boolean2Boolean(commandlineOptions.showStackTrace()));
        if (commandlineOptions.version()) {
            this.printOutGORPipeVersion();
            System.exit(0);
        }
        ConfigUtil.loadConfig((String)"gor");
        DbSource.initInConsoleApp();
        int exitCode = 0;
        String sparkGorRedisUri = GorSparkUtilities.getSparkGorRedisUri();
        SparkGorMonitor sparkMonitor = new SparkGorMonitor(sparkGorRedisUri, "-1");
        SparkGorExecutionEngine executionEngine = new SparkGorExecutionEngine(commandlineOptions.query(), commandlineOptions.gorRoot(), commandlineOptions.cacheDir(), null, null, null, sparkMonitor);
        try {
            executionEngine.execute();
        }
        catch (GorException ge) {
            this.consoleLogger().error(ExceptionUtilities.gorExceptionToString((Throwable)ge));
            exitCode = -1;
        }
        catch (Throwable ex) {
            this.consoleLogger().error(new StringBuilder(49).append("Unexpected error, please report if you see this.\n").append(ex.getMessage()).toString(), ex);
            exitCode = -1;
        }
    }

    private void printOutGORPipeVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        System.out.println(version != null ? version : "No implementation version found.");
    }

    private SparkPipe$() {
        MODULE$ = this;
        GorPipeFirstOrderCommands.$init$((GorPipeFirstOrderCommands)this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.consoleLogger = LoggerFactory.getLogger((String)new StringBuilder(8).append("console.").append(this.getClass()).toString());
        this.version = this.getClass().getPackage().getImplementationVersion();
        if (this.version() == null) {
            this.version_$eq("Unknown");
        }
        this.brsConfig = (BatchedReadSourceConfig)ConfigManager.createPrefixConfig((String)"gor", BatchedReadSourceConfig.class, (Map[])new Map[0]);
        this.gorConfig = (GorConfig)ConfigManager.createPrefixConfig((String)"gor", GorConfig.class, (Map[])new Map[0]);
    }
}

