/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import gorsat.process.FreemarkerReportBuilder;
import gorsat.process.GenericRunnerFactory;
import gorsat.process.GorSessionCacheManager;
import gorsat.process.GorSessionFactory;
import gorsat.process.SessionBasedQueryEvaluator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import org.apache.spark.sql.SparkSession;
import org.gorpipe.client.FileCache;
import org.gorpipe.gor.clients.LocalFileCacheClient;
import org.gorpipe.gor.model.DriverBackedFileReader;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.GorParallelQueryHandler;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.gor.session.GorReportBuilder;
import org.gorpipe.gor.session.GorRunnerFactory;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.session.GorSessionCache;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.gor.session.SystemContext;
import org.gorpipe.spark.GeneralSparkQueryHandler;
import org.gorpipe.spark.GorSparkSession;
import org.gorpipe.spark.GorSparkUtilities;
import org.gorpipe.spark.SparkGorMonitor;

public class SparkSessionFactory
extends GorSessionFactory {
    private String root;
    private String cacheDir;
    private Optional<String> configFile;
    private Optional<String> aliasFile;
    private SparkSession sparkSession;
    private GorMonitor sparkGorMonitor;
    private GorParallelQueryHandler queryHandler;

    public SparkSessionFactory(String root, String cacheDir, String configFile, String aliasFile, SparkGorMonitor sparkMonitor) {
        this(GorSparkUtilities.getSparkSession(), root, cacheDir, configFile, aliasFile, sparkMonitor);
    }

    public SparkSessionFactory(SparkSession sparkSession, String root, String cacheDir, String configFile, String aliasFile, GorMonitor sparkMonitor) {
        this.root = root;
        this.cacheDir = cacheDir;
        Path rootPath = Paths.get(root, new String[0]);
        if (configFile != null && configFile.length() > 0) {
            Path configPath = Paths.get(configFile, new String[0]);
            if (!configPath.isAbsolute()) {
                configPath = rootPath.resolve(configPath);
            }
            this.configFile = Files.exists(configPath, new LinkOption[0]) ? Optional.of(configPath.toAbsolutePath().toString()) : Optional.empty();
        } else {
            this.configFile = Optional.empty();
        }
        if (aliasFile != null && aliasFile.length() > 0) {
            Path aliasPath = Paths.get(aliasFile, new String[0]);
            if (!aliasPath.isAbsolute()) {
                aliasPath = rootPath.resolve(aliasPath);
            }
            this.aliasFile = Files.exists(aliasPath, new LinkOption[0]) ? Optional.of(aliasPath.toAbsolutePath().toString()) : Optional.empty();
        } else {
            this.aliasFile = Optional.empty();
        }
        this.sparkSession = sparkSession;
        this.sparkGorMonitor = sparkMonitor;
    }

    public SparkSessionFactory(SparkSession sparkSession, String root, String cacheDir, String configFile, String aliasFile, GorMonitor sparkMonitor, GorParallelQueryHandler queryHandler) {
        this(sparkSession, root, cacheDir, configFile, aliasFile, sparkMonitor);
        this.queryHandler = queryHandler;
    }

    public GorSession create() {
        String requestId = UUID.randomUUID().toString();
        GorSparkSession session = new GorSparkSession(requestId);
        session.setSparkSession(this.sparkSession);
        String sparkRedisUri = null;
        if (this.sparkGorMonitor instanceof SparkGorMonitor) {
            sparkRedisUri = ((SparkGorMonitor)this.sparkGorMonitor).getRedisUri();
            session.redisUri_$eq(sparkRedisUri);
        }
        Path cachePath = Paths.get(this.cacheDir, new String[0]);
        GorParallelQueryHandler sparkQueryHandler = this.queryHandler != null ? this.queryHandler : new GeneralSparkQueryHandler(null, sparkRedisUri);
        ProjectContext.Builder projectContextBuilder = new ProjectContext.Builder();
        if (this.configFile.isPresent()) {
            projectContextBuilder = projectContextBuilder.setConfigFile(this.configFile.get());
        }
        if (this.aliasFile.isPresent()) {
            projectContextBuilder = projectContextBuilder.setAliasFile(this.aliasFile.get());
        }
        projectContextBuilder = projectContextBuilder.setRoot(this.root).setCacheDir(this.cacheDir).setFileReader((FileReader)new DriverBackedFileReader("", this.root, null)).setFileCache((FileCache)new LocalFileCacheClient(cachePath.isAbsolute() ? cachePath : Paths.get(this.root, new String[0]).resolve(this.cacheDir))).setQueryHandler(sparkQueryHandler).setQueryEvaluator((QueryEvaluator)new SessionBasedQueryEvaluator((GorSession)session));
        SystemContext.Builder systemContextBuilder = new SystemContext.Builder();
        systemContextBuilder.setReportBuilder((GorReportBuilder)new FreemarkerReportBuilder((GorSession)session)).setRunnerFactory((GorRunnerFactory)new GenericRunnerFactory()).setServer(false).setMonitor(this.sparkGorMonitor).setStartTime(System.currentTimeMillis());
        GorSessionCache cache = GorSessionCacheManager.getCache((String)requestId);
        session.init(projectContextBuilder.build(), systemContextBuilder.build(), cache);
        if (sparkQueryHandler instanceof GeneralSparkQueryHandler) {
            ((GeneralSparkQueryHandler)sparkQueryHandler).init(session);
        }
        return session;
    }
}

