/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.spark.platform.GorKeyLock;
import org.gorpipe.spark.platform.GorTaskBase;

public abstract class GorLocks {
    private Map<GorTaskBase, GorKeyLock> locksHeld = new ConcurrentHashMap<GorTaskBase, GorKeyLock>();
    private long lockReservationMs;

    protected GorLocks(long lockReservation) {
        this.lockReservationMs = lockReservation;
    }

    synchronized boolean lock(GorTaskBase task, String key, long timeoutMs) throws InterruptedException {
        if (this.locksHeld.containsKey(task)) {
            throw new GorSystemException("Only one lock per task", null);
        }
        GorKeyLock lock = this.onCreateKeyLock(key, this.lockReservationMs);
        if (lock.lock(timeoutMs)) {
            this.locksHeld.put(task, lock);
            return true;
        }
        return false;
    }

    protected abstract GorKeyLock onCreateKeyLock(String var1, long var2);

    public void unlock(GorTaskBase task) {
        GorKeyLock lock = this.locksHeld.remove(task);
        if (lock != null) {
            lock.unlock();
        }
    }

    public void refreshAll() {
        for (GorKeyLock lock : this.locksHeld.values()) {
            lock.refreshLock();
        }
    }

    public void close() {
        for (GorKeyLock lock : this.locksHeld.values()) {
            lock.unlock();
        }
        this.locksHeld.clear();
    }

    public boolean hasLock(GorTaskBase task) {
        GorKeyLock lock = this.locksHeld.get(task);
        return lock != null && lock.isLocked();
    }
}

