/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gorpipe.spark.platform.GorClusterBase;
import org.gorpipe.spark.platform.GorLogReceiver;
import org.gorpipe.spark.platform.GorLogSubscription;
import org.slf4j.MDC;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisLogSubscription
extends JedisPubSub
implements GorLogSubscription {
    private GorClusterBase cluster;
    private GorLogReceiver receiver;
    private String[] channels;
    private HashMap<String, String> chanToId = new HashMap();
    private Thread subscriptionThread;
    private Thread unsubscriptionThread;

    public RedisLogSubscription(GorClusterBase cluster, GorLogReceiver receiver, String[] jobIds) {
        this.cluster = cluster;
        this.receiver = receiver;
        this.channels = new String[jobIds.length];
        for (int i = 0; i < jobIds.length; ++i) {
            this.channels[i] = RedisLogSubscription.getPrivateLogKey(jobIds[i]);
            this.chanToId.put(this.channels[i], jobIds[i]);
        }
    }

    public static String getKey(String ... parts) {
        return "resque:DC:" + String.join((CharSequence)":", parts);
    }

    public static String getPrivateLogKey(String jobId) {
        return RedisLogSubscription.getKey("JOB", jobId, "LOG");
    }

    @Override
    public void start() {
        final Map mdcContext = MDC.getCopyOfContextMap();
        this.unsubscriptionThread = new Thread("LogSubscription - Unsubscripion thread"){

            @Override
            public void run() {
                if (mdcContext != null) {
                    MDC.setContextMap((Map)mdcContext);
                }
                try {
                    Thread.sleep(RedisLogSubscription.this.cluster.getJobRetention().toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                RedisLogSubscription.this.cluster.logWarn("Subscription timeout", null);
                RedisLogSubscription.this.unsubscribe();
            }
        };
        this.unsubscriptionThread.start();
        this.subscriptionThread = new Thread("LogSubscription - subscription thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (mdcContext != null) {
                    MDC.setContextMap((Map)mdcContext);
                }
                RedisLogSubscription.this.cluster.logInfo("Starting log subscription on channels " + Arrays.toString(RedisLogSubscription.this.channels), null);
                try (Jedis j = RedisLogSubscription.this.cluster.pool().getResource();){
                    j.subscribe((JedisPubSub)RedisLogSubscription.this, RedisLogSubscription.this.channels);
                }
                catch (JedisConnectionException jedisConnectionException) {
                }
                finally {
                    RedisLogSubscription.this.cluster.logInfo("Ending log subscription on channels " + Arrays.toString(RedisLogSubscription.this.channels), null);
                    RedisLogSubscription.this.unsubscriptionThread.interrupt();
                }
            }
        };
        this.subscriptionThread.start();
    }

    @Override
    public void close() {
        this.cluster.logInfo("Calling unsubscribe", null);
        this.unsubscribe();
    }

    public void onMessage(String channel, String message) {
        this.receiver.receiveLog(channel, this.chanToId.get(channel), message);
    }

    public void onPMessage(String pattern, String channel, String message) {
        this.receiver.receiveLog(channel, this.chanToId.get(channel), message);
    }

    public void onPSubscribe(String arg0, int arg1) {
    }

    public void onPUnsubscribe(String arg0, int arg1) {
    }

    public void onSubscribe(String arg0, int arg1) {
    }

    public void onUnsubscribe(String arg0, int arg1) {
    }
}

