/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import gorsat.process.SparkRowUtilities;
import gorsat.spark.GorOutputWriter;
import gorsat.spark.GordFunction;
import gorsat.spark.GorzFunction;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.zip.DataFormatException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.spark.SparkGOR;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public class GorFileFormat
extends CSVFileFormat
implements Serializable {
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        String pathstr = (String)options.get((Object)"path").get();
        java.nio.file.Path path = Paths.get(pathstr, new String[0]);
        StructType ret = null;
        try {
            ret = SparkRowUtilities.inferSchema(path, path.getFileName().toString(), false, pathstr.endsWith(".gorz"));
        }
        catch (IOException | DataFormatException e) {
            e.printStackTrace();
        }
        return Option.apply(ret);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, final Map<String, String> options, StructType dataSchema) {
        return new OutputWriterFactory(){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                try {
                    return new GorOutputWriter(path, dataSchema, (String)options.get((Object)"path").get());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String getFileExtension(TaskAttemptContext context) {
                return CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension() + ".gorz";
            }
        };
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return super.supportBatch(sparkSession, dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return super.vectorTypes(requiredSchema, partitionSchema, sqlConf);
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return super.isSplitable(sparkSession, options, path);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        GordFunction func;
        String pathstr = (String)options.get((Object)"path").get();
        boolean isGorz = pathstr.endsWith(".gorz");
        boolean isGord = pathstr.endsWith(".gord");
        if (isGord) {
            func = new GordFunction(requiredSchema);
        } else {
            Map<String, String> soptions = SparkGOR.me(options);
            func = super.buildReader(sparkSession, dataSchema, partitionSchema, requiredSchema, filters, soptions, hadoopConf);
            if (isGorz) {
                return new GorzFunction(func, requiredSchema, JavaConverters.asJavaCollection(filters));
            }
        }
        return func;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return super.buildReaderWithPartitionValues(sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    public boolean supportDataType(DataType dataType) {
        return true;
    }

    public String shortName() {
        return "gor";
    }
}

