/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import gorsat.BatchedReadSource;
import gorsat.Commands.Analysis;
import gorsat.Commands.Output;
import gorsat.Outputs.NorStdOut;
import gorsat.Outputs.OutFile;
import gorsat.Outputs.StdOut;
import gorsat.process.GorExecutionEngine;
import gorsat.process.GorPipe;
import gorsat.process.PipeInstance;
import org.gorpipe.gor.binsearch.GorIndexType;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.gor.session.GorRunner;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.model.gor.iterators.RowSource;
import org.gorpipe.spark.SparkSessionFactory;
import scala.Option;

public class SparkGorExecutionEngine
extends GorExecutionEngine {
    private String query;
    private String projectDirectory;
    private String cacheDirectory;
    private String outfile;
    private String configFile;
    private String aliasFile;
    private GorMonitor sparkMonitor;

    public SparkGorExecutionEngine(String query, String projectDirectory, String cacheDirectory, String configFile, String aliasFile, String outfile, GorMonitor sparkMonitor) {
        this.query = query;
        this.projectDirectory = projectDirectory;
        this.cacheDirectory = cacheDirectory;
        this.configFile = configFile;
        this.aliasFile = aliasFile;
        this.outfile = outfile;
        this.sparkMonitor = sparkMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        RowSource brs = null;
        Analysis processor = null;
        try (GorSession session = this.createSession();){
            PipeInstance pinst = this.createIterator(session);
            RowSource iterator = pinst.theInputSource();
            processor = pinst.thePipeStep();
            brs = iterator.isBuffered() ? iterator : new BatchedReadSource(iterator, GorPipe.brsConfig());
            processor.rs_$eq(iterator);
            processor.securedSetup(null);
            while (brs.hasNext() && !processor.wantsNoMore()) {
                processor.process(brs.next());
            }
        }
        catch (Exception ex) {
            try {
                if (brs == null) throw ex;
                brs.setEx((Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                try {
                    if (processor == null) throw throwable;
                    processor.securedFinish(brs != null ? brs.getEx() : null);
                    throw throwable;
                }
                finally {
                    if (brs != null) {
                        brs.close();
                    }
                }
            }
        }
        try {
            if (processor == null) return;
            processor.securedFinish(brs != null ? brs.getEx() : null);
            return;
        }
        finally {
            if (brs != null) {
                brs.close();
            }
        }
    }

    public GorSession createSession() {
        SparkSessionFactory sessionFactory = new SparkSessionFactory(null, this.projectDirectory, this.cacheDirectory, this.configFile, this.aliasFile, this.sparkMonitor);
        return sessionFactory.create();
    }

    public PipeInstance createIterator(GorSession session) {
        PipeInstance pi = new PipeInstance(session.getGorContext());
        pi.subProcessArguments(this.query, false, null, false, false, null);
        String theHeader = pi.getIterator().getHeader();
        if (this.outfile != null) {
            Output ofile = OutFile.apply((String)this.outfile, (String)theHeader, (boolean)false, (boolean)false, (boolean)pi.isNorContext(), (boolean)true, (GorIndexType)GorIndexType.NONE, (Option)Option.empty(), (int)1);
            pi.thePipeStep_$eq(pi.thePipeStep().$bar(ofile));
        } else {
            String header = pi.getHeader();
            if (session.getNorContext() || pi.isNorContext()) {
                pi.thePipeStep_$eq(pi.thePipeStep().$bar((Output)NorStdOut.apply((String)header)));
            } else {
                pi.thePipeStep_$eq(pi.thePipeStep().$bar((Output)StdOut.apply((String)header)));
            }
        }
        return pi;
    }

    public GorRunner createRunner(GorSession session) {
        return (GorRunner)session.getSystemContext().getRunnerFactory().create();
    }
}

