/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import org.gorpipe.exceptions.ExceptionUtilities;
import org.gorpipe.exceptions.GorException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.exceptions.GorUserException;
import org.gorpipe.spark.platform.GorClusterBase;
import org.gorpipe.spark.platform.JobField;
import org.gorpipe.spark.platform.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GorTaskBase
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(GorTaskBase.class);
    private String jobId;
    private GorClusterBase cluster;

    protected GorTaskBase(String jobId) {
        this.jobId = jobId;
    }

    protected abstract String perform() throws Exception;

    public String getJobId() {
        return this.jobId;
    }

    protected abstract String getRequestId();

    protected void setProgress(String progress) {
        this.getCluster().setValue(this.getJobId(), JobField.Progress, progress);
    }

    protected void setResult(String result) {
        log.debug("Job {} set result: {}", (Object)this.getJobId(), (Object)result);
        this.getCluster().setValue(this.getJobId(), JobField.Result, result);
    }

    protected void setStatus(JobStatus status) {
        log.info("Job {} set status: {}", (Object)this.getJobId(), (Object)status);
        this.getCluster().setValue(this.getJobId(), JobField.Status, status.toString());
    }

    protected void setError(String error) {
        log.info("Job {} set error: {}", (Object)this.getJobId(), (Object)error);
        this.getCluster().setValue(this.getJobId(), JobField.Error, error);
    }

    public void setCluster(GorClusterBase cluster) {
        this.cluster = cluster;
    }

    public GorClusterBase getCluster() {
        return this.cluster;
    }

    public JobStatus getStatus() {
        return JobStatus.get(this.getCluster().getValue(this.getJobId(), JobField.Status));
    }

    protected boolean lock(String key, long timeoutMs) throws InterruptedException {
        this.logDebug("Requesting lock " + key);
        boolean gotLock = this.getCluster().locks().lock(this, key, timeoutMs);
        if (gotLock) {
            this.logDebug("Got lock " + key);
        } else {
            this.logDebug("Timout waiting for lock " + key);
        }
        return gotLock;
    }

    protected void unlock() {
        this.getCluster().locks().unlock(this);
    }

    protected boolean hasLock() {
        return this.getCluster().locks().hasLock(this);
    }

    protected void logInfo(String message, Throwable ex) {
        this.getCluster().logInfo(this.getMessage(message), ex);
    }

    protected void logDebug(String message) {
        if (log.isDebugEnabled()) {
            this.getCluster().logDebug(this.getMessage(message));
        }
    }

    protected void logWarn(String message, Throwable ex) {
        this.getCluster().logWarn(this.getMessage(message), ex);
    }

    protected void logError(String message, Throwable ex) {
        this.getCluster().logError(this.getMessage(message), ex);
    }

    protected void logProgress(String progress) {
        this.getCluster().logProgress(this.getJobId(), progress);
    }

    protected String getMessage(String message) {
        return message;
    }

    public boolean isCancelled() {
        return this.getCluster().getValue(this.getJobId(), JobField.CancelFlag) != null;
    }

    @Override
    public final void run() {
        try {
            if (this.isCancelled()) {
                this.logInfo("Job cancelled before starting", null);
                this.setStatus(JobStatus.CANCELLED);
                this.setError("Cancelled before starting");
                return;
            }
            this.logDebug("STARTUP");
            this.setStatus(JobStatus.RUNNING);
            this.setProgress("0");
            String result = this.perform();
            if (result != null) {
                this.setResult(result);
            }
            if (this.isCancelled()) {
                this.logInfo("CANCEL detected after successful return", null);
                this.setStatus(JobStatus.CANCELLED);
                this.logProgress(this.getProgressMessage("CANCELLED"));
            } else {
                this.setProgress("100");
                this.setStatus(JobStatus.DONE);
                this.logProgress(this.getProgressMessage("DONE"));
            }
        }
        catch (Exception e) {
            log.error("Job of ID " + this.getJobId() + " with status " + (Object)((Object)this.getStatus()) + " encountered exception", (Throwable)e);
            if (this.isCancelled()) {
                this.logInfo("CANCEL detected after exception", null);
                this.logProgress(this.getProgressMessage("CANCELLED"));
                this.setStatus(JobStatus.CANCELLED);
                return;
            }
            this.logDebug("FAILURE general failure");
            this.logProgress(this.getProgressMessage("FAILURE"));
            this.setStatus(JobStatus.FAILED);
            if (e instanceof GorException) {
                ((GorException)((Object)e)).setRequestID(this.getRequestId());
            }
            this.setError(ExceptionUtilities.gorExceptionToJson((Throwable)e));
            if (e instanceof GorUserException) {
                this.logInfo(ExceptionUtilities.gorExceptionToString((Throwable)e), e);
                throw (GorUserException)e;
            }
            this.logError("Job " + this.getJobId() + " failed with exception:\n" + ExceptionUtilities.gorExceptionToString((Throwable)e), e);
            if (e instanceof GorException) {
                throw (GorException)((Object)e);
            }
            throw new GorSystemException((Throwable)e);
        }
        finally {
            this.getCluster().forget(this);
            Thread.interrupted();
        }
    }

    protected String getProgressMessage(String state) {
        return "JOB:" + this.getJobId() + ":" + state;
    }

    public static String getTaskName(Class<? extends GorTaskBase> taskClass) {
        return taskClass.getName().replaceAll(".*\\.", "");
    }
}

