/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.process.GenericSessionFactory;
import gorsat.process.ProcessIteratorAdaptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.model.RowBase;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.model.gor.RowObj;

public class GorSparkExternalFunction
implements MapPartitionsFunction<Row, Row> {
    String header;
    String cmd;
    String goroot;
    boolean fetchHeader = false;

    public GorSparkExternalFunction(String header, String cmd, String goroot) {
        this.header = header;
        this.cmd = cmd;
        this.goroot = goroot;
    }

    public void setFetchHeader(boolean fetchHeader) {
        this.fetchHeader = fetchHeader;
    }

    public Iterator<Row> call(Iterator<Row> input) throws Exception {
        GenericSessionFactory gsf = this.goroot != null && Files.exists(Paths.get(this.goroot, new String[0]), new LinkOption[0]) ? new GenericSessionFactory(this.goroot, "result_cache") : new GenericSessionFactory();
        GorSession gps = gsf.create();
        ProcessIteratorAdaptor it = new ProcessIteratorAdaptor(gps.getGorContext(), this.cmd, "", input, null, this.header, false, Optional.empty(), false, false);
        if (this.fetchHeader) {
            String rowstr = it.getHeader();
            int[] sa = RowObj.splitArray((CharSequence)rowstr);
            RowBase gorrow = new RowBase("chrN", 0, (CharSequence)rowstr, sa, null);
            return Collections.singletonList(gorrow).iterator();
        }
        return it;
    }
}

