/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.Commands.Analysis;
import gorsat.Commands.CommandParseUtilities;
import gorsat.DynIterator;
import gorsat.RowBuffer;
import gorsat.commands.PysparkAnalysis;
import gorsat.parser.ParseArith;
import gorsat.process.GorSpark;
import gorsat.process.GorSparkExternalFunction;
import gorsat.process.GorSparkMaterialize;
import gorsat.process.PipeInstance;
import gorsat.process.PipeOptions;
import gorsat.process.ProcessRowSource;
import gorsat.process.ProcessSource;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import io.projectglow.Glow;
import io.projectglow.transformers.blockvariantsandsamples.VariantSampleBlockMaker;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.api.java.function.ReduceFunction;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.gor.binsearch.CompressionType;
import org.gorpipe.gor.binsearch.Unzipper;
import org.gorpipe.gor.driver.GorDriverFactory;
import org.gorpipe.gor.driver.meta.SourceReference;
import org.gorpipe.gor.driver.providers.stream.datatypes.bam.BamIterator;
import org.gorpipe.gor.driver.providers.stream.sources.StreamSource;
import org.gorpipe.gor.model.ChrDataScheme;
import org.gorpipe.gor.model.ChromoCache;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.ParquetLine;
import org.gorpipe.gor.model.VcfGzGenomicIterator;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.spark.GorFilterFunction;
import org.gorpipe.spark.GorSparkRow;
import org.gorpipe.spark.GorSparkRowInferFunction;
import org.gorpipe.spark.GorSparkSession;
import org.gorpipe.spark.GorpipeRDD;
import org.gorpipe.spark.LongGorSparkRow;
import org.gorpipe.spark.NorFilterFunction;
import org.gorpipe.spark.RowDataType;
import org.gorpipe.spark.RowGorRDD;
import org.gorpipe.spark.SparkGOR;
import org.gorpipe.spark.SparkRow;
import org.gorpipe.spark.udfs.CharToDoubleArray;
import org.gorpipe.util.collection.ByteArray;
import scala.Function1;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkRowSource
extends ProcessSource {
    static final String csvDataSource = "csv";
    static final String gordatasourceClassname = "gorsat.spark.GorDataSource";
    String errorStr;
    List<String> commands;
    String type;
    boolean isGorRow;
    Dataset<? extends Row> dataset;
    Iterator<org.gorpipe.gor.model.Row> it;
    boolean nor;
    ProcessBuilder pb;
    Process p;
    Path fileroot;
    String parquetPath;
    String pushdownGorPipe;
    GorSparkSession gorSparkSession;
    static Map<String, DataType> tmap = new HashMap<String, DataType>();
    Map<DataType, String> dmap;
    Map<String, DataType> dsmap;
    String chr;
    int start;
    int end;
    String jobId;
    Integer buckets;
    String parts;
    boolean tag;
    static byte[] unzipBuffer = new byte[131072];
    java.util.function.Function<String, String> inner;
    java.util.function.Function<String, String> gorfunc;
    Predicate<String> gorpred;
    java.util.function.Function<String, String> parqfunc;
    java.util.function.Function<String, Stream<String>> gorfileflat;
    private RowBuffer rowBuffer;
    int linesRead;

    public static GorDataType inferDataTypes(Path filePath, String fileName, boolean isGorz, boolean nor) throws IOException, DataFormatException {
        boolean isCompressed;
        boolean isUrl = fileName.contains("://");
        InputStream is = null;
        if (isUrl) {
            SourceReference sr = new SourceReference(fileName);
            is = ((StreamSource)GorDriverFactory.fromConfig().getDataSource(sr)).open();
        } else if (Files.exists(filePath, new LinkOption[0])) {
            is = Files.newInputStream(filePath, new OpenOption[0]);
        }
        String fileLow = filePath.getFileName().toString().toLowerCase();
        boolean bl = isCompressed = fileLow.endsWith(".gz") || fileLow.endsWith(".bgz");
        if (isCompressed) {
            is = new GZIPInputStream(is);
        }
        Stream<String> linestream = Stream.empty();
        boolean withStart = false;
        String[] headerArray = new String[]{};
        boolean base128 = false;
        if (is != null) {
            StringBuilder headerstr = new StringBuilder();
            int r = is.read();
            while (r != 10) {
                headerstr.append((char)r);
                r = is.read();
            }
            String header = headerstr.toString();
            if (header.startsWith("#")) {
                header = header.substring(1);
            }
            headerArray = header.split("\t");
            if (isGorz) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                r = is.read();
                if (r != -1) {
                    byte[] bb;
                    while (r != 9) {
                        r = is.read();
                    }
                    r = is.read();
                    while (r != 9) {
                        r = is.read();
                    }
                    r = is.read();
                    if (r >= 48 && r <= 57) {
                        withStart = true;
                        while (r != 9) {
                            r = is.read();
                        }
                        is.read();
                    }
                    CompressionType compressionLibrary = (r & 2) == 0 ? CompressionType.ZLIB : CompressionType.ZSTD;
                    r = is.read();
                    while (r != 10) {
                        baos.write(r);
                        r = is.read();
                    }
                    is.close();
                    byte[] baosArray = baos.toByteArray();
                    try {
                        bb = Base64.getDecoder().decode(baosArray);
                    }
                    catch (Throwable e) {
                        base128 = true;
                        bb = ByteArray.to8Bit((byte[])baosArray);
                    }
                    Unzipper unzip = new Unzipper();
                    unzip.setType(compressionLibrary);
                    unzip.setRawInput(bb, 0, bb.length);
                    int unzipLen = unzip.decompress(unzipBuffer, 0, unzipBuffer.length);
                    String str = new String(unzipBuffer, 0, unzipLen);
                    StringReader strreader = new StringReader(str);
                    linestream = new BufferedReader(strreader).lines();
                } else {
                    linestream = Stream.empty();
                }
            } else {
                is.close();
                if (isUrl) {
                    SourceReference sr = new SourceReference(fileName);
                    is = ((StreamSource)GorDriverFactory.fromConfig().getDataSource(sr)).open();
                    if (isCompressed) {
                        is = new GZIPInputStream(is);
                    }
                    linestream = new BufferedReader(new InputStreamReader(is)).lines().skip(1L);
                } else if (Files.exists(filePath, new LinkOption[0])) {
                    linestream = isCompressed ? new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(filePath, new OpenOption[0])))).lines().skip(1L) : Files.newBufferedReader(filePath).lines().skip(1L);
                }
            }
        }
        return SparkRowSource.typeFromStream(linestream, withStart, headerArray, nor, base128);
    }

    public static GorDataType typeFromParquetLine(ParquetLine pl, boolean withStart, String[] header) {
        HashMap<Integer, DataType> dataTypeMap = new HashMap<Integer, DataType>();
        String[] gortypes = new String[pl.numCols()];
        for (int i = 0; i < pl.numCols(); ++i) {
            PrimitiveType.PrimitiveTypeName ptm = pl.getType(i);
            if (ptm == PrimitiveType.PrimitiveTypeName.INT64) {
                dataTypeMap.put(i, DataTypes.LongType);
                gortypes[i] = "L";
                continue;
            }
            if (ptm == PrimitiveType.PrimitiveTypeName.INT32) {
                dataTypeMap.put(i, DataTypes.IntegerType);
                gortypes[i] = "I";
                continue;
            }
            if (ptm == PrimitiveType.PrimitiveTypeName.FLOAT) {
                dataTypeMap.put(i, DataTypes.FloatType);
                gortypes[i] = "D";
                continue;
            }
            dataTypeMap.put(i, DataTypes.StringType);
            gortypes[i] = "S";
        }
        return new GorDataType(dataTypeMap, withStart, header, gortypes);
    }

    public static GorDataType typeFromStream(Stream<String> linestream, boolean withStart, String[] headerArray, boolean nor) {
        return SparkRowSource.typeFromStream(linestream, withStart, headerArray, nor, false);
    }

    public static GorDataType typeFromStream(Stream<String> linestream, boolean withStart, String[] headerArray, boolean nor, boolean base128) {
        int start;
        HashMap<Integer, DataType> dataTypeMap = new HashMap<Integer, DataType>();
        if (nor) {
            headerArray = Arrays.copyOfRange(headerArray, 2, headerArray.length);
        }
        String[] gortypes = new String[headerArray.length];
        for (int i = start = 0; i < headerArray.length; ++i) {
            dataTypeMap.put(i, DataTypes.IntegerType);
            gortypes[i] = "I";
        }
        HashSet remSet = new HashSet();
        HashSet dSet = new HashSet();
        Stream<Object> strstr = linestream.limit(1000L).map(line -> line.split("\t", -1));
        if (nor) {
            strstr = strstr.map(a -> Arrays.copyOfRange(a, 2, ((String[])a).length));
        }
        List ok = strstr.collect(Collectors.toList());
        strstr = ok.stream();
        strstr.allMatch(line -> {
            int i;
            Iterator iterator;
            dataTypeMap.forEach((idx, colType) -> {
                String value = line[idx];
                if (colType == DataTypes.IntegerType) {
                    try {
                        Integer.parseInt(value);
                    }
                    catch (Exception e1) {
                        colType = DataTypes.DoubleType;
                    }
                }
                if (colType == DataTypes.DoubleType) {
                    try {
                        int di = value.indexOf(46);
                        if (di >= 0 || value.length() <= 16) {
                            Double.parseDouble(value);
                            dSet.add(idx);
                        } else {
                            remSet.add(idx);
                        }
                    }
                    catch (Exception e1) {
                        remSet.add(idx);
                    }
                }
            });
            if (remSet.size() > 0) {
                dataTypeMap.keySet().removeAll(remSet);
                iterator = remSet.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    gortypes[i] = "S";
                }
                remSet.clear();
            }
            iterator = dSet.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                dataTypeMap.put(i, DataTypes.DoubleType);
                gortypes[i] = "D";
            }
            return dataTypeMap.size() > 0;
        });
        return new GorDataType(dataTypeMap, withStart, headerArray, gortypes, base128);
    }

    public Dataset<? extends Row> getDataset() {
        return this.dataset;
    }

    public static String generateTempViewName(String fileName, boolean usegorpipe, String filter, String chr, int pos, int end) {
        String fixName = fileName;
        String prekey = usegorpipe + fixName;
        String key = filter == null ? prekey : filter + prekey;
        String ret = chr == null ? key : chr + pos + end + key;
        return "g" + Math.abs(ret.hashCode());
    }

    public static StructType gor2Schema(String header, org.gorpipe.gor.model.Row types) {
        String[] hsplit = header.split("\t");
        StructField[] fields = new StructField[types.numCols()];
        for (int i = 0; i < fields.length; ++i) {
            String type = types.stringValue(i);
            DataType dt = type.equals("S") ? DataTypes.StringType : (type.equals("D") ? DataTypes.DoubleType : DataTypes.IntegerType);
            fields[i] = new StructField(hsplit[i], dt, true, Metadata.empty());
        }
        return new StructType(fields);
    }

    public static StructType inferSchema(Path filePath, String fileName, boolean nor, boolean isGorz) throws IOException, DataFormatException {
        GorDataType gorDataType = SparkRowSource.inferDataTypes(filePath, fileName, isGorz, nor);
        String[] headerArray = gorDataType.header;
        Map<Integer, DataType> dataTypeMap = gorDataType.dataTypeMap;
        DataType[] dataTypes = new DataType[headerArray.length];
        int start = 0;
        if (!nor) {
            dataTypes[0] = DataTypes.StringType;
            dataTypes[1] = DataTypes.IntegerType;
            start = 2;
        }
        for (int i2 = start; i2 < dataTypes.length; ++i2) {
            dataTypes[i2] = dataTypeMap.getOrDefault(i2, DataTypes.StringType);
        }
        StructField[] fields = (StructField[])IntStream.range(0, headerArray.length).mapToObj(i -> new StructField(headerArray[i], dataTypes[i], true, Metadata.empty())).toArray(StructField[]::new);
        return new StructType(fields);
    }

    public static String translatePath(String fn, Path fileroot, String standalone) {
        String fileName;
        if (fn.contains("://")) {
            fileName = fn;
        } else {
            Path filePath = Paths.get(fn, new String[0]);
            if (!filePath.isAbsolute()) {
                if (standalone != null && standalone.length() > 0) {
                    int k = standalone.indexOf(32);
                    if (k == -1) {
                        k = standalone.length();
                    }
                    filePath = Paths.get(standalone.substring(0, k), new String[0]).resolve(fn);
                } else {
                    filePath = Paths.get(fn, new String[0]);
                    if (!filePath.isAbsolute() && !Files.exists(filePath, new LinkOption[0])) {
                        filePath = fileroot.resolve(filePath).normalize().toAbsolutePath();
                    }
                }
            }
            fileName = filePath.toString();
        }
        return fileName;
    }

    public static GorDataType gorCmdSchema(String gorcmd, GorSparkSession gorSparkSession, boolean nor) {
        DynIterator.DynamicRowSource drs = new DynIterator.DynamicRowSource(gorcmd, gorSparkSession.getGorContext(), false);
        String header = drs.getHeader();
        String[] ha = header.split("\t");
        Stream linestream = (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(drs, 16), false).map(Object::toString).onClose(() -> ((DynIterator.DynamicRowSource)drs).close());
        GorDataType gdt = SparkRowSource.typeFromStream(linestream, false, ha, nor);
        gdt.setUsedFiles(JavaConverters.seqAsJavaList((Seq)drs.usedFiles()));
        return gdt;
    }

    static SparkSession getSparkSession(GorSparkSession gorSparkSession, Path fileroot, String profile) {
        return gorSparkSession.getSparkSession(fileroot != null ? fileroot.toString() : null, null, profile);
    }

    public static Dataset<? extends Row> registerFile(String[] fns, String name, String profile, GorSparkSession gorSparkSession, String standalone, Path fileroot, boolean usestreaming, String filter, String filterFile, String filterColumn, String splitFile, boolean nor, String chr, int pos, int end, String jobid, String cacheFile, boolean cpp, boolean tag) throws IOException, DataFormatException {
        Dataset gor;
        String fileName;
        String fn = fns[0];
        boolean nestedQuery = fn.startsWith("<(");
        Path filePath = null;
        if (nestedQuery) {
            fileName = fn.substring(2, fn.length() - 1);
        } else {
            fileName = SparkRowSource.translatePath(fn, fileroot, standalone);
            filePath = Paths.get(fileName, new String[0]);
        }
        String tempViewName = SparkRowSource.generateTempViewName(fileName, usestreaming, filter, chr, pos, end);
        String[] tableNames = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).sqlContext().tableNames();
        if (gorSparkSession.datasetMap().containsKey(tempViewName) && Arrays.asList(tableNames).contains(tempViewName)) {
            RowDataType rdt = gorSparkSession.datasetMap().get(tempViewName);
            gor = rdt.dataset;
            DataType[] dataTypes = rdt.datatypes;
            HashMap dataTypeMap = new HashMap();
            IntStream.range(0, dataTypes.length).forEach(i -> {
                DataType dt = dataTypes[i];
                if (dt != DataTypes.StringType) {
                    dataTypeMap.put(i, dt);
                }
            });
            if (name != null) {
                gor.createOrReplaceTempView(name);
            }
        } else {
            DataType[] dataTypes;
            nestedQuery = false;
            if (nestedQuery) {
                Map<Path, String> fNames;
                String[] headerArray;
                boolean hasFilter = filter != null && filter.length() > 0;
                String gorcmd = fileName;
                if (hasFilter) {
                    gorcmd = gorcmd.substring(0, 4) + "-f" + filter + gorcmd.substring(3);
                }
                if (chr != null) {
                    String rest = gorcmd.substring(3);
                    gorcmd = gorcmd.substring(0, 4) + "-p" + chr + ":" + pos + "-";
                    if (end != -1) {
                        gorcmd = gorcmd + end;
                    }
                    gorcmd = gorcmd + rest;
                }
                GorDataType gdt = SparkRowSource.gorCmdSchema(gorcmd, gorSparkSession, nor);
                boolean isGord = false;
                List<String> usedFiles = gdt.usedFiles;
                if (usedFiles.size() > 0) {
                    fileName = usedFiles.get(0);
                    if (!fileName.contains("://")) {
                        Path path = filePath = standalone != null && standalone.length() > 0 ? Paths.get(standalone, new String[0]).resolve(fileName) : Paths.get(fileName, new String[0]);
                    }
                    if ((isGord = fileName.toLowerCase().endsWith(".gord")) && !hasFilter) {
                        headerArray = Arrays.copyOf(gdt.header, gdt.header.length + 1);
                        headerArray[headerArray.length - 1] = "PN";
                    } else {
                        headerArray = gdt.header;
                    }
                } else {
                    headerArray = gdt.header;
                }
                dataTypes = new DataType[headerArray.length];
                int start = 0;
                if (!nor) {
                    dataTypes[0] = DataTypes.StringType;
                    dataTypes[1] = DataTypes.IntegerType;
                    start = 2;
                }
                for (int i2 = start; i2 < dataTypes.length; ++i2) {
                    dataTypes[i2] = gdt.dataTypeMap.getOrDefault(i2, DataTypes.StringType);
                }
                StructField[] fields = (StructField[])IntStream.range(0, headerArray.length).mapToObj(i -> new StructField(headerArray[i], dataTypes[i], true, Metadata.empty())).toArray(StructField[]::new);
                StructType schema = new StructType(fields);
                ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
                if (isGord) {
                    assert (filePath != null);
                    Path fileParent = filePath.getParent();
                    fNames = Files.lines(filePath).map(l -> l.split("\t")).peek(l -> {
                        l[0] = l[0].split("\\|")[0];
                    }).collect(Collectors.toMap(s -> fileParent.resolve(s[0]), s -> s[1]));
                    HashMap<String, String> uNames = new HashMap<String, String>();
                    for (Path p : fNames.keySet()) {
                        uNames.put(p.toUri().toString(), fNames.get(p));
                    }
                } else {
                    fNames = null;
                }
                JavaRDD rdd = new RowGorRDD(SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile), gorcmd, "", !hasFilter && fNames != null ? String.join((CharSequence)",", fNames.values()) : null, chr, pos, end, true).toJavaRDD();
                Function & Serializable rfunc = (Function & Serializable)a -> {
                    Object[] o = new Object[a.numCols()];
                    o[0] = a.chr;
                    o[1] = a.pos;
                    for (int i = 2; i < o.length; ++i) {
                        o[i] = fields[i].dataType().sameType(DataTypes.IntegerType) ? Integer.valueOf(a.colAsInt(i)) : (fields[i].dataType().sameType(DataTypes.DoubleType) ? Double.valueOf(a.colAsDouble(i)) : a.colAsString(i).toString());
                    }
                    return RowFactory.create((Object[])o);
                };
                JavaRDD nrdd = rdd.map((Function)rfunc);
                gor = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).createDataset(nrdd.rdd(), (Encoder)encoder);
            } else {
                HashMap<String, String> uNames;
                Map<Path, String> fNames;
                boolean isGord = fileName.toLowerCase().endsWith(".gord");
                Path dictFile = null;
                int dictSplit = 0;
                if (isGord) {
                    Path fileParent = filePath.toAbsolutePath().normalize().getParent();
                    dictSplit = Files.lines(filePath).mapToInt(l -> l.split("\t").length).findFirst().getAsInt();
                    dictFile = filePath;
                    fNames = Files.lines(filePath).map(l -> l.split("\t")).peek(l -> {
                        l[0] = l[0].split("\\|")[0];
                    }).collect(Collectors.toMap(s -> fileParent.resolve(s[0]), s -> s[1], (a1, a2) -> a1));
                    fileName = fNames.keySet().iterator().next().toString();
                    filePath = standalone != null && standalone.length() > 0 ? Paths.get(standalone, new String[0]).resolve(fileName) : Paths.get(fileName, new String[0]);
                    uNames = new HashMap();
                    for (Path p : fNames.keySet()) {
                        uNames.put(p.toUri().toString(), fNames.get(p));
                    }
                } else if (fns.length > 1) {
                    fNames = Arrays.stream(fns).collect(Collectors.toMap(x$0 -> Paths.get(x$0, new String[0]), s -> s));
                    fileName = fNames.keySet().iterator().next().toString();
                    filePath = standalone != null && standalone.length() > 0 ? Paths.get(standalone, new String[0]).resolve(fileName) : Paths.get(fileName, new String[0]);
                    uNames = new HashMap<String, String>();
                    for (Path p : fNames.keySet()) {
                        uNames.put(p.toUri().toString(), fNames.get(p));
                    }
                } else {
                    fNames = null;
                    uNames = null;
                }
                if (fileName.startsWith("spark ")) {
                    PipeInstance pi = new PipeInstance(gorSparkSession.getGorContext());
                    PipeOptions po = new PipeOptions();
                    po.query_$eq(fileName);
                    pi.subProcessArguments(po);
                    SparkRowSource sparkRowSource = (SparkRowSource)pi.theInputSource();
                    gor = sparkRowSource.getDataset();
                    dataTypes = (DataType[])Arrays.stream(gor.schema().fields()).map(StructField::dataType).toArray(DataType[]::new);
                } else if (fileName.startsWith("pgor ") || fileName.startsWith("partgor ") || fileName.startsWith("parallel ") || fileName.startsWith("gor ") || fileName.startsWith("nor ")) {
                    DataFrameReader dfr = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format(gordatasourceClassname);
                    dfr.option("query", fileName);
                    if (tag) {
                        dfr.option("tag", true);
                    }
                    dfr.option("projectroot", fileroot.toString());
                    gor = dfr.load();
                    dataTypes = (DataType[])Arrays.stream(gor.schema().fields()).map(StructField::dataType).toArray(DataType[]::new);
                } else if (fileName.toLowerCase().endsWith(".parquet")) {
                    gor = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format("org.apache.spark.sql.execution.datasources.v2.parquet.ParquetDataSourceV2").load(fileName);
                    dataTypes = (DataType[])Arrays.stream(gor.schema().fields()).map(StructField::dataType).toArray(DataType[]::new);
                } else if (fileName.toLowerCase().endsWith(".vcf") || fileName.toLowerCase().endsWith(".vcf.gz") || fileName.toLowerCase().endsWith(".vcf.bgz")) {
                    String vcfDataSource = "io.projectglow.vcf.VCFFileFormat";
                    gor = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format(vcfDataSource).load(fileName);
                    dataTypes = (DataType[])Arrays.stream(gor.schema().fields()).map(StructField::dataType).toArray(DataType[]::new);
                } else if (fileName.toLowerCase().endsWith(".bgen")) {
                    String bgenDataSource = "io.projectglow.bgen.BgenFileFormat";
                    gor = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format(bgenDataSource).load(fileName);
                    dataTypes = (DataType[])Arrays.stream(gor.schema().fields()).map(StructField::dataType).toArray(DataType[]::new);
                } else {
                    DataFrameReader dfr;
                    StructType schema;
                    Collection<Object> pns;
                    boolean isGorz = fileName.toLowerCase().endsWith(".gorz");
                    boolean isGorgz = fileName.toLowerCase().endsWith(".gor.gz") || fileName.toLowerCase().endsWith(".gor.bgz");
                    GorDataType gorDataType = SparkRowSource.inferDataTypes(filePath, fileName, isGorz, nor);
                    String[] headerArray = gorDataType.header;
                    Map<Integer, DataType> dataTypeMap = gorDataType.dataTypeMap;
                    dataTypes = new DataType[headerArray.length];
                    int start = 0;
                    if (!nor && dataTypes.length > 1 && headerArray[0].equalsIgnoreCase("chrom")) {
                        dataTypes[0] = DataTypes.StringType;
                        dataTypes[1] = DataTypes.IntegerType;
                        start = 2;
                    }
                    for (int i3 = start; i3 < dataTypes.length; ++i3) {
                        dataTypes[i3] = dataTypeMap.getOrDefault(i3, DataTypes.StringType);
                    }
                    Collection<String> collection = filter != null && filter.length() > 0 ? new HashSet<String>(Arrays.asList(filter.split(","))) : (pns = fNames != null ? fNames.values() : Collections.emptySet());
                    if (isGorz && !gorDataType.base128 || dictFile != null) {
                        StructField[] tmpfields;
                        StructField[] fields;
                        if (dictFile != null) {
                            Stream<StructField> baseStream = IntStream.range(0, headerArray.length).mapToObj(i -> new StructField(headerArray[i], dataTypes[i], true, Metadata.empty()));
                            Stream.Builder<StructField> sb = Stream.builder();
                            if (dictSplit == 2 && filterColumn != null && filterColumn.length() > 0) {
                                sb.add(new StructField(filterColumn, DataTypes.StringType, true, Metadata.empty()));
                            }
                            if (splitFile != null && splitFile.length() > 0) {
                                sb.add(new StructField("tag", DataTypes.StringType, true, Metadata.empty()));
                            }
                            Stream extra = sb.build();
                            fields = (StructField[])Stream.concat(baseStream, extra).toArray(StructField[]::new);
                        } else if (gorDataType.withStart) {
                            tmpfields = new StructField[]{new StructField("Chrom", DataTypes.StringType, true, Metadata.empty()), new StructField("Start", DataTypes.IntegerType, true, Metadata.empty()), new StructField("Stop", DataTypes.IntegerType, true, Metadata.empty()), new StructField("data", DataTypes.StringType, true, Metadata.empty())};
                            fields = tmpfields;
                        } else {
                            tmpfields = new StructField[]{new StructField("Chrom", DataTypes.StringType, true, Metadata.empty()), new StructField("Pos", DataTypes.IntegerType, true, Metadata.empty()), new StructField("data", DataTypes.StringType, true, Metadata.empty())};
                            fields = tmpfields;
                        }
                        schema = new StructType(fields);
                        if (uNames != null) {
                            if (dictFile != null) {
                                dfr = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format(gordatasourceClassname);
                                if (fileroot != null) {
                                    dfr.option("projectroot", fileroot.toString());
                                }
                                if (filter != null) {
                                    dfr = dfr.option("f", filter);
                                }
                                if (filterFile != null) {
                                    dfr = dfr.option("ff", filterFile);
                                }
                                if (splitFile != null) {
                                    dfr = dfr.option("split", splitFile);
                                }
                                if (filterColumn != null) {
                                    dfr = dfr.option("s", filterColumn);
                                }
                                if (chr != null) {
                                    String seek = chr;
                                    if (pos > 0 || end != -1) {
                                        seek = seek + ":" + pos;
                                        if (end != -1) {
                                            seek = seek + "-" + end;
                                        }
                                    }
                                    dfr = dfr.option("p", seek);
                                }
                                gor = dfr.schema(schema).load(dictFile.toAbsolutePath().normalize().toString());
                                isGorz = false;
                            } else {
                                gor = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format(csvDataSource).option("header", "true").option("delimiter", "\t").schema(schema).load((String[])fNames.entrySet().stream().filter(e -> pns.contains(e.getValue())).map(Map.Entry::getKey).map(Path::toString).toArray(String[]::new));
                            }
                        } else {
                            gor = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format(csvDataSource).option("header", "true").option("delimiter", "\t").schema(schema).load(fileName);
                        }
                    } else {
                        StructField[] fields = (StructField[])IntStream.range(0, headerArray.length).mapToObj(i -> new StructField(headerArray[i], dataTypes[i], true, Metadata.empty())).toArray(StructField[]::new);
                        schema = new StructType(fields);
                        if (uNames != null && !gorDataType.base128) {
                            gor = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format(csvDataSource).option("header", "true").option("delimiter", "\t").schema(schema).load((String[])fNames.entrySet().stream().filter(e -> pns.contains(e.getValue())).map(Map.Entry::getKey).map(Path::toString).toArray(String[]::new));
                            if (filter != null && filter.length() > 0) {
                                gor = gor.selectExpr(new String[]{"*", "get_pn(input_file_name()) as PN"});
                            }
                        } else if (isGorgz || gorDataType.base128) {
                            dfr = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format(gordatasourceClassname).schema(schema);
                            if (gorSparkSession.getRedisUri() != null && gorSparkSession.getRedisUri().length() > 0) {
                                dfr = dfr.option("redis", gorSparkSession.getRedisUri()).option("jobid", jobid).option("cachefile", cacheFile).option("native", Boolean.toString(cpp));
                            }
                            if (chr != null) {
                                String seek = chr;
                                if (pos > 0 || end != -1) {
                                    seek = seek + ":" + pos;
                                    if (end != -1) {
                                        seek = seek + "-" + end;
                                    }
                                }
                                dfr = dfr.option("p", seek);
                            }
                            gor = dfr.load(fileName);
                        } else {
                            Dataset sgor = SparkRowSource.getSparkSession(gorSparkSession, fileroot, profile).read().format(csvDataSource).option("header", "true").option("delimiter", "\t").schema(schema).load(fileName);
                            if (filter != null && filter.length() > 0) {
                                OptionalInt oi;
                                int filterColumnIndex = headerArray.length - 1;
                                if (filterColumn != null && (oi = IntStream.range(0, headerArray.length).filter(i -> headerArray[i].equals(filterColumn)).findFirst()).isPresent()) {
                                    filterColumnIndex = oi.getAsInt();
                                }
                                PNFilterFunction ff = new PNFilterFunction(filter, filterColumnIndex);
                                sgor = sgor.filter((FilterFunction)ff);
                            }
                            gor = sgor;
                        }
                    }
                    if (!isGorgz && !gorDataType.base128) {
                        if (isGorz) {
                            if (chr != null) {
                                gor = gorDataType.withStart && end != -1 ? gor.filter((FilterFunction & Serializable)row -> chr.equals(row.getString(0)) && row.getInt(1) <= end && row.getInt(2) >= pos) : gor.filter((FilterFunction & Serializable)row -> chr.equals(row.getString(0)) && row.getInt(1) >= pos);
                            }
                            StructField[] flds = (StructField[])IntStream.range(0, headerArray.length).mapToObj(i -> new StructField(headerArray[i], dataTypes[i], true, Metadata.empty())).toArray(StructField[]::new);
                            schema = new StructType(flds);
                            ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
                            boolean withStart = gorDataType.withStart;
                            gor = gor.flatMap((FlatMapFunction & Serializable)row -> {
                                byte[] bb;
                                String zip = withStart ? row.getString(3) : row.getString(2);
                                char tp = zip.charAt(0);
                                CompressionType compressionLibrary = (tp & 2) == 0 ? CompressionType.ZLIB : CompressionType.ZSTD;
                                String zipo = zip.substring(1);
                                try {
                                    bb = Base64.getDecoder().decode(zipo);
                                }
                                catch (Exception e) {
                                    bb = ByteArray.to8Bit((byte[])zipo.getBytes());
                                }
                                Unzipper unzip = new Unzipper();
                                unzip.setType(compressionLibrary);
                                unzip.setRawInput(bb, 0, bb.length);
                                int unzipLen = unzip.decompress(unzipBuffer, 0, unzipBuffer.length);
                                ByteArrayInputStream bais = new ByteArrayInputStream(unzipBuffer, 0, unzipLen);
                                InputStreamReader isr = new InputStreamReader(bais);
                                BufferedReader br = new BufferedReader(isr);
                                return (nor ? br.lines().map(line -> {
                                    String[] split = line.split("\t");
                                    Object[] objs = new Object[split.length];
                                    for (int i = 0; i < split.length; ++i) {
                                        if (dataTypeMap.containsKey(i)) {
                                            if (dataTypeMap.get(i) == DataTypes.IntegerType) {
                                                objs[i] = Integer.parseInt(split[i]);
                                                continue;
                                            }
                                            objs[i] = Double.parseDouble(split[i]);
                                            continue;
                                        }
                                        objs[i] = split[i];
                                    }
                                    return RowFactory.create((Object[])objs);
                                }) : br.lines().map(line -> {
                                    String[] split = line.split("\t");
                                    Object[] objs = new Object[split.length];
                                    objs[0] = split[0];
                                    objs[1] = Integer.parseInt(split[1]);
                                    for (int i = 2; i < split.length; ++i) {
                                        if (dataTypeMap.containsKey(i)) {
                                            if (dataTypeMap.get(i) == DataTypes.IntegerType) {
                                                objs[i] = Integer.parseInt(split[i]);
                                                continue;
                                            }
                                            objs[i] = Double.parseDouble(split[i]);
                                            continue;
                                        }
                                        objs[i] = split[i];
                                    }
                                    return RowFactory.create((Object[])objs);
                                })).iterator();
                            }, (Encoder)encoder);
                            if (chr != null) {
                                gor = gor.filter((FilterFunction & Serializable)row -> {
                                    int p = row.getInt(1);
                                    return chr.equals(row.getString(0)) && p >= pos && (end == -1 || p <= end);
                                });
                            }
                        } else if (chr != null) {
                            gor = end != -1 ? gor.filter((FilterFunction & Serializable)row -> chr.equals(row.getString(0)) && row.getInt(1) <= end && row.getInt(2) >= pos) : gor.filter((FilterFunction & Serializable)row -> chr.equals(row.getString(0)) && row.getInt(1) >= pos);
                        }
                    }
                }
            }
            if (name != null && !name.startsWith("#")) {
                gor.createOrReplaceTempView(name);
            }
            gor.createOrReplaceTempView(tempViewName);
            gorSparkSession.datasetMap().put(tempViewName, new RowDataType((Dataset<? extends Row>)gor, dataTypes));
        }
        return gor;
    }

    public void init() {
        this.dmap.put(DataTypes.StringType, "S");
        this.dmap.put(DataTypes.IntegerType, "I");
        this.dmap.put(DataTypes.DoubleType, "D");
        this.dsmap.put("String", DataTypes.StringType);
        this.dsmap.put("Integer", DataTypes.IntegerType);
        this.dsmap.put("Int", DataTypes.IntegerType);
        this.dsmap.put("Double", DataTypes.DoubleType);
    }

    public boolean isNor() {
        return this.nor;
    }

    public SparkRowSource(String sql, String profile, String parquet, String type, boolean nor, GorSparkSession gpSession, String filter, String filterFile, String filterColumn, String splitFile, String chr, int pos, int end, boolean usestreaming, String jobId, boolean useCpp, String parts, int buckets, boolean tag) throws IOException, DataFormatException {
        this.errorStr = "";
        this.isGorRow = false;
        this.fileroot = null;
        this.parquetPath = null;
        this.pushdownGorPipe = null;
        this.dmap = new HashMap<DataType, String>();
        this.dsmap = new HashMap<String, DataType>();
        this.jobId = "-1";
        this.rowBuffer = null;
        this.linesRead = 0;
        this.init();
        this.jobId = jobId;
        this.tag = tag;
        this.buckets = buckets != -1 ? Integer.valueOf(buckets) : null;
        this.parts = parts;
        this.gorSparkSession = gpSession;
        this.nor = nor;
        if (parquet != null && Files.exists(Paths.get(parquet, new String[0]), new LinkOption[0])) {
            this.dataset = SparkRowSource.getSparkSession(gpSession, this.fileroot, profile).read().parquet(parquet);
        } else {
            this.type = type;
            this.commands = new ArrayList<String>();
            this.chr = chr;
            this.start = pos;
            this.end = end;
            String root = gpSession.getProjectContext().getRoot();
            if (root != null && root.length() > 0) {
                int i = root.indexOf(32);
                if (i == -1) {
                    i = root.length();
                }
                this.fileroot = Paths.get(root.substring(0, i), new String[0]);
            }
            String[] cmdsplit = CommandParseUtilities.quoteCurlyBracketsSafeSplit((String)sql, (char)' ');
            this.commands.addAll(Arrays.asList(cmdsplit));
            boolean bamvcf = type != null && (type.equals("bam") || type.equals("sam") || type.equals("cram") || type.equals("vcf"));
            List<String> headercommands = bamvcf ? this.seekCmd(null, 0, -1) : this.seekCmd(chr, this.start, end);
            String standalone = System.getProperty("sm.standalone");
            this.inner = p -> {
                if (p.startsWith("(")) {
                    String[] cmdspl = CommandParseUtilities.quoteCurlyBracketsSafeSplit((String)p.substring(1, p.length() - 1), (char)' ');
                    return Arrays.stream(cmdspl).map(this.inner).map(this.gorfunc).map(this.parqfunc).collect(Collectors.joining(" ", "(", ")"));
                }
                return p;
            };
            this.gorpred = p -> p.toLowerCase().endsWith(".tsv") || p.toLowerCase().endsWith(".gor") || p.toLowerCase().endsWith(".gorz") || p.toLowerCase().endsWith(".gor.gz") || p.toLowerCase().endsWith(".gord") || p.toLowerCase().endsWith(".txt") || p.toLowerCase().endsWith(".vcf") || p.toLowerCase().endsWith(".bgen") || p.startsWith("<(");
            this.gorfunc = p -> {
                if (this.gorpred.test((String)p)) {
                    boolean nestedQuery = p.startsWith("<(");
                    String fileName = nestedQuery ? p.substring(2, p.length() - 1) : SparkRowSource.translatePath(p, this.fileroot, standalone);
                    return SparkRowSource.generateTempViewName(fileName, usestreaming, filter, chr, pos, end);
                }
                return p;
            };
            this.gorfileflat = p -> p.startsWith("(") ? Arrays.stream(CommandParseUtilities.quoteCurlyBracketsSafeSplit((String)p.substring(1, p.length() - 1), (char)' ')).flatMap(this.gorfileflat).filter(this.gorpred) : Stream.of(p);
            this.parqfunc = p -> {
                if (p.toLowerCase().endsWith(".parquet") && !p.toLowerCase().startsWith("parquet.")) {
                    String fileName = SparkRowSource.translatePath(p, this.fileroot, standalone);
                    return "parquet.`" + fileName + "`";
                }
                return p;
            };
            boolean isSql = headercommands.get(0).equalsIgnoreCase("select");
            String cacheFile = null;
            if (isSql) {
                String[] fileNames;
                sql = headercommands.stream().filter(p -> p.length() > 0).map(this.inner).map(this.gorfunc).map(this.parqfunc).collect(Collectors.joining(" "));
                for (String fn : fileNames = (String[])Arrays.stream(cmdsplit).flatMap(this.gorfileflat).filter(this.gorpred).toArray(String[]::new)) {
                    if (this.gorSparkSession.getSystemContext().getServer()) {
                        ProjectContext.validateServerFileName((String)fn, (boolean)true);
                    }
                    SparkRowSource.registerFile(new String[]{fn}, profile, null, gpSession, standalone, this.fileroot, usestreaming, filter, filterFile, filterColumn, splitFile, nor, chr, pos, end, jobId, cacheFile, useCpp, tag);
                }
                this.dataset = SparkRowSource.getSparkSession(gpSession, this.fileroot, profile).sql(sql);
            } else {
                String[] fileNames = headercommands.toArray(new String[0]);
                this.dataset = SparkRowSource.registerFile(fileNames, null, profile, gpSession, standalone, this.fileroot, usestreaming, filter, filterFile, filterColumn, splitFile, nor, chr, pos, end, jobId, cacheFile, useCpp, tag);
            }
            if (chr != null) {
                this.dataset = end != -1 ? this.dataset.filter((FilterFunction & Serializable)row -> chr.equals(row.getString(0)) && row.getInt(1) <= end && row.getInt(1) >= pos) : this.dataset.filter((FilterFunction & Serializable)row -> chr.equals(row.getString(0)) && row.getInt(1) >= pos);
            }
            SparkRowSource.getSparkSession(gpSession, this.fileroot, profile).sparkContext().setJobGroup("a|b|gorsql|c", sql, true);
        }
        this.setHeader((nor ? "chrNOR\tposNOR\t" : "") + this.correctHeader(this.dataset.columns()));
    }

    private String correctHeader(String[] header) {
        return String.join((CharSequence)"\t", header);
    }

    public void gorpipe(Analysis pipeStep, boolean gor) {
        RDD rdd = this.dataset.rdd();
        ExpressionEncoder encoder = this.dataset.exprEnc();
        GorpipeRDD gorpipeRDD = new GorpipeRDD(rdd, pipeStep, encoder, this.getHeader(), gor, rdd.elementClassTag());
        this.dataset = SparkRowSource.getSparkSession(this.gorSparkSession, this.fileroot, null).createDataset(gorpipeRDD, (Encoder)encoder);
        this.setHeader(this.correctHeader(this.dataset.columns()));
    }

    public static Dataset<org.gorpipe.gor.model.Row> gorpipe(Dataset<? extends Row> dataset, String gor) {
        String inputHeader = String.join((CharSequence)"\t", dataset.schema().fieldNames());
        boolean nor = SparkRowSource.checkNor(dataset.schema().fields());
        Dataset<? extends Row> dr = dataset;
        GorSpark gs = new GorSparkMaterialize(inputHeader, nor, SparkGOR.sparkrowEncoder().schema(), gor, null, null, "-1", 100);
        GorSparkRowInferFunction gi = new GorSparkRowInferFunction();
        org.gorpipe.gor.model.Row row = (org.gorpipe.gor.model.Row)dr.mapPartitions((MapPartitionsFunction)gs, SparkGOR.gorrowEncoder()).limit(100).reduce((ReduceFunction)gi);
        if (row.chr != null) {
            row = gi.infer(row, row);
        }
        StructType schema = SparkRowSource.schemaFromRow(gs.query().getHeader().split("\t"), row);
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
        gs = new GorSpark(inputHeader, nor, schema, gor, null, null, "-1");
        return dr.mapPartitions((MapPartitionsFunction)gs, (Encoder)encoder);
    }

    public void gor() {
        String inputHeader = super.getHeader();
        boolean nor = SparkRowSource.checkNor(this.dataset.schema().fields());
        Dataset<? extends org.gorpipe.gor.model.Row> dr = this.checkRowFormat(this.dataset);
        String uri = this.gorSparkSession.getRedisUri();
        GorSpark gs = new GorSparkMaterialize(inputHeader, nor, SparkGOR.sparkrowEncoder().schema(), this.pushdownGorPipe, this.gorSparkSession.getProjectContext().getRoot(), uri, this.jobId, 100);
        GorSparkRowInferFunction gi = new GorSparkRowInferFunction();
        org.gorpipe.gor.model.Row row = (org.gorpipe.gor.model.Row)dr.mapPartitions((MapPartitionsFunction)gs, SparkGOR.gorrowEncoder()).limit(100).reduce((ReduceFunction)gi);
        if (row.chr != null) {
            row = gi.infer(row, row);
        }
        StructType schema = SparkRowSource.schemaFromRow(gs.query().getHeader().split("\t"), row);
        this.setHeader(this.correctHeader(schema.fieldNames()));
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
        gs = new GorSpark(inputHeader, nor, schema, this.pushdownGorPipe, this.gorSparkSession.getProjectContext().getRoot(), uri, this.jobId);
        this.pushdownGorPipe = null;
        this.dataset = dr.mapPartitions((MapPartitionsFunction)gs, (Encoder)encoder);
        nor = SparkRowSource.checkNor(this.dataset.schema().fields());
        this.setHeader((nor ? "chrNOR\tposNOR\t" : "") + this.correctHeader(this.dataset.columns()));
    }

    public static StructType schemaFromRow(String[] header, org.gorpipe.gor.model.Row row) {
        return new StructType((StructField[])IntStream.range(0, row.numCols()).mapToObj(i -> new StructField(header[i], tmap.get(row.stringValue(i)), true, Metadata.empty())).toArray(StructField[]::new));
    }

    public static String checkNested(String cmd, GorSession gpSession, String[] errorStr) {
        String ncmd;
        if (cmd.startsWith("<(")) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir == null || tmpdir.length() == 0) {
                tmpdir = "/tmp";
            }
            Path tmpath = Paths.get(tmpdir, new String[0]);
            String scmd = cmd.substring(2, cmd.length() - 1);
            Path fifopath = tmpath.resolve(Integer.toString(Math.abs(scmd.hashCode())));
            String pipename = fifopath.toAbsolutePath().toString();
            DynIterator.DynamicRowSource drs = new DynIterator.DynamicRowSource(scmd, gpSession.getGorContext(), false);
            try {
                if (!Files.exists(fifopath, new LinkOption[0])) {
                    ProcessBuilder mkfifo = new ProcessBuilder("mkfifo", pipename);
                    Process p = mkfifo.start();
                    p.waitFor();
                }
                Thread t = new Thread(() -> {
                    try (OutputStream os = Files.newOutputStream(fifopath, new OpenOption[0]);){
                        os.write(String.join((CharSequence)"\t", drs.getHeader()).getBytes());
                        os.write(10);
                        while (drs.hasNext()) {
                            String rowstr = drs.next().toString();
                            os.write(rowstr.getBytes());
                            os.write(10);
                        }
                    }
                    catch (IOException e) {
                        errorStr[0] = errorStr[0] + e.getMessage();
                    }
                    finally {
                        try {
                            Files.delete(fifopath);
                        }
                        catch (IOException iOException) {}
                    }
                });
                t.start();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed starting fifo thread", e);
            }
            ncmd = pipename;
        } else {
            boolean quotas = cmd.startsWith("'") || cmd.startsWith("\"");
            String string = ncmd = quotas ? cmd.substring(1, cmd.length() - 1) : cmd;
            if (quotas) {
                ncmd = ncmd.replace("\\t", "\t").replace("\\n", "\n");
            }
        }
        return ncmd;
    }

    public SparkRowSource(String[] cmds, String type, boolean nor, GorSession gpSession, String chr, int pos, int end, int bs) {
        block15: {
            String root;
            this.errorStr = "";
            this.isGorRow = false;
            this.fileroot = null;
            this.parquetPath = null;
            this.pushdownGorPipe = null;
            this.dmap = new HashMap<DataType, String>();
            this.dsmap = new HashMap<String, DataType>();
            this.jobId = "-1";
            this.rowBuffer = null;
            this.linesRead = 0;
            this.type = type;
            this.nor = nor;
            this.setBufferSize(bs);
            this.commands = new ArrayList<String>();
            this.chr = chr;
            this.start = pos;
            this.end = end;
            if (gpSession != null && (root = gpSession.getProjectContext().getRoot()) != null && root.length() > 0) {
                int i = root.indexOf(32);
                if (i == -1) {
                    i = root.length();
                }
                this.fileroot = Paths.get(root.substring(0, i), new String[0]);
            }
            String[] estr = new String[]{this.errorStr};
            for (String cmd : cmds) {
                String ncmd = SparkRowSource.checkNested(cmd, gpSession, estr);
                this.commands.add(ncmd);
            }
            boolean bamvcf = type != null && (type.equals("bam") || type.equals("sam") || type.equals("cram") || type.equals("vcf"));
            List<String> headercommands = bamvcf ? this.seekCmd(null, 0, -1) : this.seekCmd(chr, this.start, end);
            try {
                List<String> rcmd = headercommands.stream().filter(p -> p.length() > 0).collect(Collectors.toList());
                this.pb = new ProcessBuilder(rcmd);
                if (this.fileroot != null) {
                    this.pb.directory(this.fileroot.toFile());
                }
                this.p = this.pb.start();
                Thread errorThread = new Thread(() -> {
                    try {
                        StringBuilder total = new StringBuilder();
                        InputStream es = this.p.getErrorStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(es));
                        String line = br.readLine();
                        while (line != null) {
                            total.append(line).append("\n");
                            line = br.readLine();
                        }
                        this.errorStr = this.errorStr + total.toString();
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                errorThread.start();
                InputStream is = this.p.getInputStream();
                if (type == null || type.equalsIgnoreCase("gor")) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    this.setHeader(br.readLine());
                    if (this.getHeader() == null) {
                        throw new RuntimeException("Running external process: " + String.join((CharSequence)" ", headercommands) + " with error: " + this.errorStr);
                    }
                    if (nor) {
                        this.setHeader("ChromNOR\tPosNOR\t" + this.getHeader().replace(" ", "_").replace(":", ""));
                    }
                    break block15;
                }
                if (type.equalsIgnoreCase("vcf")) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    final GenomicIterator.ChromoLookup lookup = ProcessRowSource.createChromoLookup();
                    try {
                        this.it = new VcfGzGenomicIterator(lookup, "filename", null, br){

                            public boolean seek(String seekChr, int seekPos) {
                                return this.seek(seekChr, seekPos, lookup.chrToLen(seekChr));
                            }

                            public boolean seek(String seekChr, int seekPos, int endPos) {
                                try {
                                    this.reader.close();
                                    if (seekChr != null && this.chrNameSystem != VcfGzGenomicIterator.ChrNameSystem.WITH_CHR_PREFIX) {
                                        seekChr = seekChr.substring(3);
                                    }
                                    InputStream is1 = SparkRowSource.this.setRange(seekChr, seekPos, endPos);
                                    this.reader = new BufferedReader(new InputStreamReader(is1));
                                    this.next = this.reader.readLine();
                                    while (this.next != null && this.next.startsWith("#")) {
                                        this.next = this.reader.readLine();
                                    }
                                }
                                catch (IOException e) {
                                    throw new RuntimeException("Error reading next line from external process providing vcf stream", e);
                                }
                                return true;
                            }

                            public void close() {
                                super.close();
                            }
                        };
                        break block15;
                    }
                    catch (Exception e) {
                        int exitValue = 0;
                        try {
                            exitValue = this.p.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        throw new RuntimeException("Error initializing vcf reader. Exit value from process: " + exitValue + ". Error from process: " + this.errorStr, e);
                    }
                }
                if (type.equalsIgnoreCase("bam") || type.equalsIgnoreCase("sam") || type.equalsIgnoreCase("cram")) {
                    final GenomicIterator.ChromoLookup lookup = ProcessRowSource.createChromoLookup();
                    final SamReaderFactory srf = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT);
                    SamInputResource sir = SamInputResource.of((InputStream)is);
                    SamReader samreader = srf.open(sir);
                    BamIterator bamit = new BamIterator(){

                        public boolean seek(String chr, int pos) {
                            return this.seek(chr, pos);
                        }

                        public boolean seek(String chr, int pos, int end) {
                            int chrId = lookup.chrToId(chr);
                            if (this.chrnamesystem == 1) {
                                chr = ChromoCache.getHgName((int)chrId);
                            } else if (this.chrnamesystem == 2) {
                                chr = ChromoCache.getStdChrName((int)chrId);
                            }
                            try {
                                this.reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            InputStream nis = SparkRowSource.this.setRange(chr, pos, end);
                            SamInputResource sir = SamInputResource.of((InputStream)nis);
                            this.reader = srf.open(sir);
                            this.it = this.reader.iterator();
                            this.pos = pos;
                            return true;
                        }

                        public boolean hasNext() {
                            SAMRecord samRecord;
                            this.initIterator();
                            boolean hasNext = this.it.hasNext();
                            while (hasNext && (samRecord = (SAMRecord)this.it.next()) != null && (samRecord.getReadUnmappedFlag() || "*".equals(samRecord.getCigarString()) || samRecord.getStart() < this.pos)) {
                                hasNext = this.it.hasNext();
                            }
                            if (!hasNext && this.hgSeekIndex >= 0) {
                                while (++this.hgSeekIndex < ChrDataScheme.ChrLexico.getOrder2id().length) {
                                    String name = this.getChromName();
                                    if (this.samFileHeader.getSequenceIndex(name) <= -1) continue;
                                    this.createIterator(name, 0);
                                    return this.hasNext();
                                }
                            }
                            return hasNext;
                        }

                        public void createIterator(String chr, int pos) {
                            if (this.it == null) {
                                this.it = this.reader.iterator();
                            }
                        }
                    };
                    bamit.init(lookup, samreader, null, false);
                    bamit.it = bamit.reader.iterator();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("unable to get header from process " + this.commands.get(0), e);
            }
        }
    }

    public static boolean checkNor(StructField[] fields) {
        return fields.length == 1 || !fields[0].name().equalsIgnoreCase("chrom") || fields[1].dataType() != DataTypes.IntegerType;
    }

    public boolean hasNext() {
        if (this.it == null) {
            if (this.parquetPath != null) {
                Path pPath = Paths.get(this.parquetPath, new String[0]);
                if (this.fileroot != null && !pPath.isAbsolute()) {
                    pPath = this.fileroot.resolve(pPath);
                }
                if (!Files.exists(pPath, new LinkOption[0])) {
                    Arrays.stream(this.dataset.columns()).filter(c -> c.contains("(")).forEach(c -> {
                        this.dataset = this.dataset.withColumnRenamed(c, c.replace('(', '_').replace(')', '_'));
                    });
                    DataFrameWriter dfw = this.dataset.write();
                    if (this.parts != null) {
                        dfw = this.buckets != null ? dfw.bucketBy(this.buckets.intValue(), this.parts, new String[0]) : dfw.partitionBy(this.parts.split(","));
                    }
                    dfw.format("parquet").mode(SaveMode.Overwrite).save(pPath.toAbsolutePath().normalize().toString());
                }
                return false;
            }
            Iterable iterable = () -> this.dataset.toLocalIterator();
            boolean lng = false;
            if (this.dataset != null) {
                StructField[] fields = this.dataset.schema().fields();
                lng = fields.length > 1 && fields[1].dataType() == DataTypes.LongType;
                this.nor |= SparkRowSource.checkNor(fields);
            }
            this.it = (this.nor ? StreamSupport.stream(iterable.spliterator(), false).map(r -> new SparkRow((Row)r)) : (lng ? StreamSupport.stream(iterable.spliterator(), false).map(r -> new LongGorSparkRow((Row)r)) : StreamSupport.stream(iterable.spliterator(), false).map(r -> new GorSparkRow((Row)r)))).iterator();
        }
        return this.it.hasNext();
    }

    public org.gorpipe.gor.model.Row next() {
        ++this.linesRead;
        return this.it.next();
    }

    public void setPosition(String seekChr, int seekPos) {
    }

    public void close() {
    }

    private List<String> seekCmd(String seekChr, int startPos, int endPos) {
        ArrayList<String> seekcmd = new ArrayList<String>();
        for (String cmd : this.commands) {
            int sEnd;
            int sPos;
            int hEnd;
            int hPos;
            if (seekChr == null) {
                hPos = cmd.indexOf("#(H:");
                if (hPos != -1) {
                    hEnd = cmd.indexOf(41, hPos + 1);
                    cmd = cmd.substring(0, hPos) + cmd.substring(hPos + 4, hEnd) + cmd.substring(hEnd + 1);
                }
                if ((sPos = cmd.indexOf("#(S:")) != -1) {
                    sEnd = cmd.indexOf(41, sPos + 1);
                    cmd = cmd.substring(0, sPos) + cmd.substring(sEnd + 1);
                }
            } else {
                hPos = cmd.indexOf("#(H:");
                if (hPos != -1) {
                    hEnd = cmd.indexOf(41, hPos + 1);
                    cmd = cmd.substring(0, hPos) + cmd.substring(hEnd + 1);
                }
                if ((sPos = cmd.indexOf("#(S:")) != -1) {
                    int pos;
                    sEnd = cmd.indexOf(41, sPos + 1);
                    String seek = "";
                    seek = cmd.substring(sPos + 4, sEnd).replace("chr", seekChr);
                    if (seekChr.startsWith("chr")) {
                        seek = seek.replace("chn", seekChr.substring(3));
                    }
                    if ((pos = seek.indexOf("pos-end")) != -1) {
                        if (endPos == -1) {
                            int len = Integer.MAX_VALUE;
                            seek = seek.replace("pos", startPos + 1 + "").replace("end", len + "");
                        } else {
                            seek = seek.replace("pos", startPos + 1 + "").replace("end", endPos + "");
                        }
                    } else if (seek.contains("pos")) {
                        seek = seek.replace("pos", startPos + "");
                        seek = seek.replace("end", endPos + "");
                    }
                    cmd = cmd.substring(0, sPos) + seek + cmd.substring(sEnd + 1);
                }
            }
            seekcmd.add(cmd);
        }
        return seekcmd;
    }

    public InputStream setRange(String seekChr, int startPos, int endPos) {
        try {
            List<String> seekcmd = this.seekCmd(seekChr, startPos, endPos);
            if (this.p != null && this.p.isAlive()) {
                this.linesRead = 0;
                this.p.destroy();
            }
            this.pb = new ProcessBuilder(seekcmd.stream().filter(p -> p.length() > 0).collect(Collectors.toList()));
            if (this.fileroot != null) {
                this.pb.directory(this.fileroot.toFile());
            }
            this.p = this.pb.start();
            Thread errorThread = new Thread(() -> {
                try {
                    InputStream es = this.p.getErrorStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(es));
                    String line = br.readLine();
                    while (line != null) {
                        this.errorStr = this.errorStr + line + "\n";
                        line = br.readLine();
                    }
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            errorThread.start();
            return this.p.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read line from external process in seek: " + this.commands, e);
        }
    }

    public String getHeader() {
        if (this.pushdownGorPipe != null && this.pushdownGorPipe.length() > 0) {
            this.gor();
        }
        return super.getHeader();
    }

    public boolean isBuffered() {
        return true;
    }

    public Dataset<? extends org.gorpipe.gor.model.Row> checkRowFormat(Dataset<? extends Row> dataset) {
        Dataset ret;
        if (!this.isGorRow) {
            this.isGorRow = true;
            StructField[] fields = dataset.schema().fields();
            boolean lng = fields.length > 1 && fields[1].dataType() == DataTypes.LongType;
            this.nor |= SparkRowSource.checkNor(fields);
            Dataset dr = dataset;
            ret = this.nor ? dr.map(SparkRow::new, SparkGOR.sparkrowEncoder()) : (lng ? dr.map(LongGorSparkRow::new, SparkGOR.sparkrowEncoder()) : dr.map(GorSparkRow::new, SparkGOR.sparkrowEncoder()));
        } else {
            ret = dataset;
        }
        return ret;
    }

    public boolean pushdownFilter(String gorwhere) {
        if (this.pushdownGorPipe != null) {
            this.pushdownGor("where " + gorwhere);
        } else {
            StructType st = this.dataset.schema();
            StructField[] fields = st.fields();
            this.nor |= SparkRowSource.checkNor(fields);
            String[] headersplit = (String[])Arrays.stream(fields).map(StructField::name).toArray(String[]::new);
            String[] ctypes = (String[])Arrays.stream(st.fields()).map(f -> this.dmap.get(f.dataType())).toArray(String[]::new);
            this.dataset = this.dataset.filter((FilterFunction)(this.nor ? new NorFilterFunction(gorwhere, headersplit, ctypes) : new GorFilterFunction(gorwhere, headersplit, ctypes)));
        }
        return true;
    }

    public boolean pushdownCalc(String formula, String colName) {
        if (formula.startsWith("udf")) {
            String string = formula.substring(4, formula.length() - 1).trim();
        } else if (formula.toLowerCase().startsWith("chartodoublearray")) {
            if (this.pushdownGorPipe != null) {
                this.gor();
            }
            CharToDoubleArray cda = new CharToDoubleArray();
            UserDefinedFunction udf1 = functions.udf((UDF1)cda, (DataType)DataTypes.createArrayType((DataType)DataTypes.DoubleType));
            String colRef = formula.substring("chartodoublearray".length() + 1, formula.length() - 1);
            this.dataset = this.dataset.withColumn(colName, udf1.apply(new Column[]{this.dataset.col(colRef)}));
        } else if (this.pushdownGorPipe != null) {
            this.pushdownGor("calc " + colName + " " + formula);
        } else {
            StructType st = this.dataset.schema();
            StructField[] st_fields = st.fields();
            this.nor |= SparkRowSource.checkNor(st_fields);
            String[] headersplit = (String[])Arrays.stream(st_fields).map(StructField::name).toArray(String[]::new);
            String[] ctypes = (String[])Arrays.stream(st.fields()).map(f -> this.dmap.get(f.dataType())).toArray(String[]::new);
            DataType[] dataTypes = (DataType[])Arrays.stream(st.fields()).map(StructField::dataType).toArray(DataType[]::new);
            FilterParams fp = new FilterParams(formula, headersplit, ctypes);
            OptionalInt oi = IntStream.range(0, headersplit.length).filter(i -> headersplit[i].equalsIgnoreCase(colName)).findFirst();
            StructField[] fields = oi.isPresent() ? new StructField[headersplit.length] : new StructField[headersplit.length + 1];
            IntStream.range(0, headersplit.length).forEach(i -> {
                fields[i] = new StructField(headersplit[i], dataTypes[i], true, Metadata.empty());
            });
            GorMapFunction gmp = this.nor ? new NorMapFunction(fp, oi) : new GorMapFunction(fp, oi);
            String ctype = gmp.getCalcType();
            DataType type = this.dsmap.get(ctype);
            fields[oi.isPresent() ? oi.getAsInt() : fields.length - 1] = new StructField(colName, type, true, Metadata.empty());
            StructType schema = new StructType(fields);
            ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
            this.dataset = this.dataset.map((MapFunction)gmp, (Encoder)encoder);
            this.setHeader(this.correctHeader(this.dataset.columns()));
        }
        return true;
    }

    public boolean pushdownSelect(String[] cols) {
        return false;
    }

    public boolean pushdownWrite(String filename) {
        this.it = null;
        this.parquetPath = filename;
        return true;
    }

    public boolean pushdownCmd(String cmd) {
        int i = cmd.indexOf(123);
        String query = cmd.substring(i + 1, cmd.length() - 1);
        Dataset<? extends org.gorpipe.gor.model.Row> dr = this.checkRowFormat(this.dataset);
        String inputHeader = String.join((CharSequence)"\t", this.dataset.schema().fieldNames());
        GorSparkExternalFunction gsef = new GorSparkExternalFunction(inputHeader, query, null);
        gsef.setFetchHeader(true);
        org.gorpipe.gor.model.Row r = (org.gorpipe.gor.model.Row)dr.mapPartitions((MapPartitionsFunction)gsef, SparkGOR.gorrowEncoder()).head();
        gsef.setFetchHeader(false);
        GorSparkRowInferFunction gi = new GorSparkRowInferFunction();
        org.gorpipe.gor.model.Row row = (org.gorpipe.gor.model.Row)dr.mapPartitions((MapPartitionsFunction)gsef, SparkGOR.gorrowEncoder()).limit(100).reduce((ReduceFunction)gi);
        if (row.chr != null) {
            row = gi.infer(row, row);
        }
        StructType schema = SparkRowSource.schemaFromRow(r.toString().split("\t"), row);
        this.setHeader(this.correctHeader(schema.fieldNames()));
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
        this.dataset = dr.mapPartitions((MapPartitionsFunction)gsef, (Encoder)encoder);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Dataset<Row> analyse(Dataset<Row> dataset, String gor) {
        String[] pipe_options;
        block12: {
            String[] pipe_options2;
            block11: {
                Dataset ret;
                block10: {
                    ret = null;
                    if (gor.startsWith("gatk")) break block10;
                    if (gor.startsWith("pipe")) break block11;
                    if (gor.startsWith("split_multiallelics")) {
                        HashMap options = new HashMap();
                        return Glow.transform((String)"split_multiallelics", dataset, options);
                    }
                    if (!gor.startsWith("block_variants_and_samples")) {
                        if (!gor.startsWith("make_sample_blocks")) return ret;
                        int sampleCount = Integer.parseInt(gor.substring("make_sample_blocks".length()).trim());
                        return VariantSampleBlockMaker.makeSampleBlocks(dataset, (int)sampleCount);
                    }
                    break block12;
                }
                String command = gor.substring(5);
                if (!command.startsWith("haplotypecaller")) return ret;
                return ret;
            }
            HashMap<String, String> options = new HashMap<String, String>();
            String cmd = gor.substring(4).trim();
            String[] stringArray = pipe_options2 = cmd.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return Glow.transform((String)"pipe", dataset, options);
                }
                String popt = stringArray[n2];
                String[] psplit = popt.split("=");
                if (psplit[1].startsWith("'")) {
                    options.put(psplit[0], psplit[1].substring(1, psplit[1].length() - 1));
                } else {
                    options.put(psplit[0], psplit[1]);
                }
                ++n2;
            }
        }
        HashMap<String, String> options = new HashMap<String, String>();
        String cmd = gor.substring("block_variants_and_samples".length()).trim();
        String[] stringArray = pipe_options = cmd.split(" ");
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String popt = stringArray[n3];
            String[] psplit = popt.split("=");
            if (psplit[1].startsWith("'")) {
                options.put(psplit[0], psplit[1].substring(1, psplit[1].length() - 1));
            } else {
                options.put(psplit[0], psplit[1]);
            }
            ++n3;
        }
        return Glow.transform((String)"block_variants_and_samples", dataset, options);
    }

    public boolean pushdownGor(String gor) {
        if (gor.startsWith("rename")) {
            if (this.pushdownGorPipe != null) {
                this.gor();
            }
            String[] split = gor.substring("rename".length()).trim().split(" ");
            this.dataset = this.dataset.withColumnRenamed(split[0], split[1]);
        } else if (gor.startsWith("pyspark")) {
            if (this.pushdownGorPipe != null) {
                this.gor();
            }
            String cmd = gor.substring("pyspark".length());
            try {
                this.dataset = PysparkAnalysis.pyspark(this.dataset, cmd);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        } else if (this.pushdownGorPipe == null) {
            Dataset<Row> ret = SparkRowSource.analyse(this.dataset, gor);
            if (ret != null) {
                this.dataset = ret;
            } else {
                this.pushdownGorPipe = gor;
            }
        } else {
            this.pushdownGorPipe = this.pushdownGorPipe + "|" + gor;
        }
        return true;
    }

    public boolean pushdownTop(int limit) {
        if (this.pushdownGorPipe != null) {
            this.pushdownGor("top " + limit);
        } else {
            this.dataset = this.dataset.limit(limit);
        }
        return true;
    }

    static {
        tmap.put("S", DataTypes.StringType);
        tmap.put("I", DataTypes.IntegerType);
        tmap.put("D", DataTypes.DoubleType);
    }

    public static class GorDataType {
        public Map<Integer, DataType> dataTypeMap;
        public boolean withStart;
        public String[] header;
        public String[] gortypes;
        boolean base128;
        public List<String> usedFiles;

        public GorDataType(Map<Integer, DataType> dataTypeMap, boolean withStart, String[] header, String[] gortypes, boolean base128) {
            this.dataTypeMap = dataTypeMap;
            this.withStart = withStart;
            this.header = header;
            this.gortypes = gortypes;
            this.base128 = base128;
        }

        public GorDataType(Map<Integer, DataType> dataTypeMap, boolean withStart, String[] header, String[] gortypes) {
            this(dataTypeMap, withStart, header, gortypes, false);
        }

        public void setUsedFiles(List<String> usedFiles) {
            this.usedFiles = usedFiles;
        }
    }

    static class PNFilterFunction
    implements FilterFunction<Row>,
    Serializable {
        Set<String> pns;
        int colnum;

        public PNFilterFunction(String filter, int colNum) {
            this.pns = new HashSet<String>(Arrays.asList(filter.split(",")));
            this.colnum = colNum;
        }

        public boolean call(Row row) {
            String str = row.getString(this.colnum);
            return this.pns.contains(str);
        }
    }

    static class FilterParams
    implements Serializable {
        public String paramString;
        String[] headersplit;
        String[] colType;

        FilterParams(String paramString, String[] headersplit, String[] colType) {
            this.paramString = paramString;
            this.headersplit = headersplit;
            this.colType = colType;
        }
    }

    static class NorMapFunction
    extends GorMapFunction {
        NorMapFunction(FilterParams filterParams, OptionalInt replaceIndex) {
            super(filterParams, replaceIndex);
        }

        @Override
        public Row call(Row row) {
            Object[] lobj = this.replaceIndex == -1 ? new Object[row.size() + 1] : new Object[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                lobj[i] = row.get(i);
            }
            SparkRow cvp = new SparkRow(row);
            lobj[this.replaceIndex == -1 ? row.size() : this.replaceIndex] = this.func != null ? this.func.apply((Object)cvp) : "";
            return RowFactory.create((Object[])lobj);
        }
    }

    static class GorMapFunction
    implements MapFunction<Row, Row>,
    Serializable {
        transient ParseArith filter = new ParseArith(null);
        String calcType;
        Function1 func;
        int replaceIndex;

        GorMapFunction(FilterParams filterParams, OptionalInt rIdx) {
            this.filter.setColumnNamesAndTypes(filterParams.headersplit, filterParams.colType);
            this.calcType = this.filter.compileCalculation(filterParams.paramString);
            int n = this.replaceIndex = rIdx.isPresent() ? rIdx.getAsInt() : -1;
            if (this.calcType.equals("String")) {
                this.func = this.filter.stringFunction();
            } else if (this.calcType.equals("Double")) {
                this.func = this.filter.doubleFunction();
            } else if (this.calcType.equals("Long")) {
                this.func = this.filter.longFunction();
            } else if (this.calcType.equals("Int")) {
                this.func = this.filter.intFunction();
            } else if (this.calcType.equals("Boolean")) {
                this.func = this.filter.booleanFunction();
            }
        }

        public String getCalcType() {
            return this.calcType;
        }

        public Row call(Row row) {
            Object[] lobj = this.replaceIndex == -1 ? new Object[row.size() + 1] : new Object[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                lobj[i] = row.get(i);
            }
            GorSparkRow cvp = new GorSparkRow(row);
            lobj[this.replaceIndex == -1 ? row.size() : this.replaceIndex] = this.func != null ? this.func.apply((Object)cvp) : "";
            return RowFactory.create((Object[])lobj);
        }
    }
}

