/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import gorsat.BatchedPipeStepIteratorAdaptor;
import gorsat.BatchedReadSource;
import gorsat.process.GorPipe;
import gorsat.process.PipeInstance;
import gorsat.process.PipeOptions;
import gorsat.spark.GorRangeInputPartition;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.gor.model.RowBase;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.model.gor.RowObj;
import org.gorpipe.model.gor.iterators.RowSource;
import org.gorpipe.spark.GorSparkSession;
import org.gorpipe.spark.SparkGorMonitor;
import org.gorpipe.spark.SparkGorRow;
import org.gorpipe.spark.SparkSessionFactory;
import org.gorpipe.spark.platform.JobField;

public class GorPartitionReader
implements PartitionReader<InternalRow> {
    RowSource iterator;
    SparkGorRow sparkRow;
    SparkGorMonitor sparkGorMonitor;
    GorRangeInputPartition p;
    ExpressionEncoder.Serializer<Row> serializer;
    String redisUri;
    String jobId;
    String useCpp;
    String projectRoot;
    String cacheDir;
    boolean nor = false;

    public GorPartitionReader(StructType schema, GorRangeInputPartition gorRangeInputPartition, String redisUri, String jobId, String projectRoot, String cacheDir, String useCpp) {
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
        this.serializer = encoder.createSerializer();
        this.sparkRow = new SparkGorRow(schema);
        this.p = gorRangeInputPartition;
        this.redisUri = redisUri;
        this.jobId = jobId;
        this.useCpp = useCpp;
        this.projectRoot = projectRoot;
        this.cacheDir = cacheDir;
    }

    private String parseMultiplePaths(Path epath) {
        String epathstr = this.p.path;
        if (Files.isDirectory(epath, new LinkOption[0])) {
            try {
                epathstr = Files.walk(epath, new FileVisitOption[0]).skip(1L).map(Path::toString).filter(p -> p.endsWith(".gorz")).collect(Collectors.joining(" "));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return epathstr;
    }

    private RowSource iteratorFromFile(PipeInstance pi) {
        boolean useNative = this.useCpp != null && this.useCpp.equalsIgnoreCase("true");
        String seek = useNative ? "cmd " : "gor ";
        Path epath = Paths.get(this.p.path, new String[0]);
        String epathstr = this.parseMultiplePaths(epath);
        String spath = useNative ? "cgor #(S:-p chr:pos) " + this.p.path + "}" : epathstr;
        String s = this.p.filterColumn != null && this.p.filterColumn.length() > 0 ? "-s " + this.p.filterColumn + " " : "";
        String path = seek + (this.p.filterFile == null ? (this.p.filter == null ? s + spath : s + "-f " + this.p.filter + " " + spath) : s + "-ff " + this.p.filterFile + " " + spath);
        String[] args = new String[]{path};
        PipeOptions options = new PipeOptions();
        options.parseOptions(args);
        pi.subProcessArguments(options);
        RowSource rowSource = pi.theInputSource();
        if (this.p.chr != null && this.p.chr.length() > 0) {
            rowSource.setPosition(this.p.chr, this.p.start);
        }
        if (this.redisUri != null && this.redisUri.length() > 0) {
            return new BatchedReadSource((Iterator)rowSource, GorPipe.brsConfig(), rowSource.getHeader(), (GorMonitor)this.sparkGorMonitor);
        }
        return rowSource;
    }

    private RowSource iteratorWithPipeSteps(PipeInstance pi) {
        pi.init(this.p.query, false, null);
        RowSource rowSource = pi.theInputSource();
        if (this.p.chr != null && this.p.chr.length() > 0) {
            rowSource.setPosition(this.p.chr, this.p.start);
        }
        return new BatchedPipeStepIteratorAdaptor((Iterator)rowSource, pi.getPipeStep(), rowSource.getHeader(), GorPipe.brsConfig());
    }

    void initIterator() {
        this.sparkGorMonitor = new SparkGorMonitor(this.redisUri, this.jobId){

            public boolean isCancelled() {
                return GorPartitionReader.this.sparkGorMonitor.getValue(JobField.CancelFlag) != null;
            }
        };
        SparkSessionFactory sessionFactory = new SparkSessionFactory(null, this.projectRoot, this.cacheDir, this.sparkGorMonitor);
        GorSparkSession gorPipeSession = (GorSparkSession)sessionFactory.create();
        PipeInstance pi = new PipeInstance(gorPipeSession.getGorContext());
        if (this.p.query != null) {
            this.iterator = this.iteratorWithPipeSteps(pi);
            this.nor = this.p.query.toLowerCase().startsWith("nor ");
        } else {
            this.iterator = this.iteratorFromFile(pi);
        }
    }

    public boolean next() {
        boolean hasNext;
        if (this.iterator == null) {
            this.initIterator();
        }
        if (hasNext = this.iterator.hasNext()) {
            org.gorpipe.gor.model.Row gorrow = this.iterator.next();
            if (this.nor) {
                String rowstr = gorrow.otherCols();
                int[] sa = RowObj.splitArray((CharSequence)rowstr);
                gorrow = new RowBase("chrN", 0, (CharSequence)rowstr, sa, null);
            }
            if (this.p.tag != null) {
                gorrow = gorrow.rowWithAddedColumn((CharSequence)this.p.tag);
            }
            hasNext = this.p.chr == null || gorrow.chr.equals(this.p.chr) && (this.p.end == -1 || gorrow.pos <= this.p.end);
            this.sparkRow.row = gorrow;
        }
        return hasNext;
    }

    public InternalRow get() {
        return this.serializer.apply((Object)this.sparkRow);
    }

    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }
}

