/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import gorsat.Utilities.AnalysisUtilities$;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.spark.GorPartition;
import org.gorpipe.spark.SparkGorExecutionEngine;
import org.gorpipe.spark.SparkGorMonitor;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001q4AAD\b\u0001-!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011!I\u0004A!A!\u0002\u0013)\u0004\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u0011m\u0002!\u0011!Q\u0001\n\u0001B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\t{\u0001\u0011\t\u0011)A\u0005k!Aa\b\u0001B\u0001B\u0003%\u0001\u0005C\u0003@\u0001\u0011\u0005\u0001\tC\u0003L\u0001\u0011\u0005A\nC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0003z\u0001\u0011E#PA\u0006H_J\fV/\u001a:z%\u0012#%B\u0001\t\u0012\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00112#A\u0004h_J\u0004\u0018\u000e]3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\f\u0011\u0007aq\u0002%D\u0001\u001a\u0015\tQ2$A\u0002sI\u0012T!\u0001\u0005\u000f\u000b\u0005u\u0019\u0012AB1qC\u000eDW-\u0003\u0002 3\t\u0019!\u000b\u0012#\u0011\u0005\u0005RcB\u0001\u0012)!\t\u0019c%D\u0001%\u0015\t)S#\u0001\u0004=e>|GO\u0010\u0006\u0002O\u0005)1oY1mC&\u0011\u0011FJ\u0001\u0007!J,G-\u001a4\n\u0005-b#AB*ue&twM\u0003\u0002*M\u0005a1\u000f]1sWN+7o]5p]B\u0011qFM\u0007\u0002a)\u0011\u0011gG\u0001\u0004gFd\u0017BA\u001a1\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003E\u0019w.\\7b]\u0012\u001cHk\\#yK\u000e,H/\u001a\t\u0004m]\u0002S\"\u0001\u0014\n\u0005a2#!B!se\u0006L\u0018!E2p[6\fg\u000eZ*jO:\fG/\u001e:fg\u0006Q1-Y2iK\u001aKG.Z:\u0002!A\u0014xN[3di\u0012K'/Z2u_JL\u0018AD2bG\",G)\u001b:fGR|'/_\u0001\u0007U>\u0014\u0017\nZ:\u0002\u0011I,G-[:Ve&\fa\u0001P5oSRtD#C!D\t\u00163u\tS%K!\t\u0011\u0005!D\u0001\u0010\u0011\u0015i\u0013\u00021\u0001/\u0011\u0015!\u0014\u00021\u00016\u0011\u0015I\u0014\u00021\u00016\u0011\u0015Q\u0014\u00021\u00016\u0011\u0015Y\u0014\u00021\u0001!\u0011\u0015a\u0014\u00021\u0001!\u0011\u0015i\u0014\u00021\u00016\u0011\u0015q\u0014\u00021\u0001!\u0003=A\u0017M\u001c3mK\u0016C8-\u001a9uS>tGcA'Q7B\u0011aGT\u0005\u0003\u001f\u001a\u0012A!\u00168ji\")\u0011K\u0003a\u0001%\u0006\tQ\r\u0005\u0002T1:\u0011AK\u0016\b\u0003GUK\u0011aJ\u0005\u0003/\u001a\nq\u0001]1dW\u0006<W-\u0003\u0002Z5\nIQ\t_2faRLwN\u001c\u0006\u0003/\u001aBQ\u0001\u0018\u0006A\u0002u\u000ba\u0002^3na~\u001b\u0017m\u00195f\r&dW\r\u0005\u0002_K6\tqL\u0003\u0002aC\u0006!a-\u001b7f\u0015\t\u00117-A\u0002oS>T\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002g?\n!\u0001+\u0019;i\u0003\u001d\u0019w.\u001c9vi\u0016$2!\u001b7s!\r\u0019&\u000eI\u0005\u0003Wj\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u0006[.\u0001\rA\\\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"a\u001c9\u000e\u0003mI!!]\u000e\u0003\u0013A\u000b'\u000f^5uS>t\u0007\"B:\f\u0001\u0004!\u0018aB2p]R,\u0007\u0010\u001e\t\u0003_VL!A^\u000e\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010^\u0001\bG>dG.Z2u)\u0005)\u0014!D4fiB\u000b'\u000f^5uS>t7/F\u0001|!\r1tG\u001c")
public class GorQueryRDD
extends RDD<String> {
    private final String[] commandsToExecute;
    private final String[] commandSignatures;
    private final String[] cacheFiles;
    private final String projectDirectory;
    private final String cacheDirectory;
    private final String[] jobIds;
    private final String redisUri;

    public void handleException(Exception e, Path temp_cacheFile) {
        try {
            Files.delete(temp_cacheFile);
        }
        catch (Exception exception) {}
        throw e;
    }

    public Iterator<String> compute(Partition partition, TaskContext context) {
        Object object;
        int i = partition.index();
        Tuple4 tuple4 = new Tuple4((Object)this.jobIds[i], (Object)this.commandSignatures[i], (Object)this.commandsToExecute[i], (Object)this.cacheFiles[i]);
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        String jobId = (String)tuple4._1();
        String commandSignature = (String)tuple4._2();
        String commandToExecute = (String)tuple4._3();
        String cacheFile = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)jobId, (Object)commandSignature, (Object)commandToExecute, (Object)cacheFile);
        Tuple4 tuple43 = tuple42;
        String jobId2 = (String)tuple43._1();
        String commandSignature2 = (String)tuple43._2();
        String commandToExecute2 = (String)tuple43._3();
        String cacheFile2 = (String)tuple43._4();
        this.log().debug(new StringBuilder(10).append("CacheFile=").append(cacheFile2).toString());
        Path projectPath = Paths.get(this.projectDirectory, new String[0]);
        Path cacheFilePath = Paths.get(cacheFile2, new String[0]);
        if (!cacheFilePath.isAbsolute()) {
            cacheFilePath = projectPath.resolve(cacheFile2);
        }
        if (!Files.exists(cacheFilePath, new LinkOption[0])) {
            String temp_cacheFileName = AnalysisUtilities$.MODULE$.getTempFileName(cacheFile2);
            Path temp_cacheFile = Paths.get(temp_cacheFileName, new String[0]);
            if (!temp_cacheFile.isAbsolute()) {
                temp_cacheFile = projectPath.resolve(temp_cacheFileName);
            }
            String tempFile_absolutepath = ((Object)temp_cacheFile.toAbsolutePath().normalize()).toString();
            try {
                GorMonitor sparkGorMonitor = SparkGorMonitor.localProgressMonitor != null ? SparkGorMonitor.localProgressMonitor : new SparkGorMonitor(this.redisUri, jobId2);
                SparkGorExecutionEngine engine = new SparkGorExecutionEngine(commandToExecute2, this.projectDirectory, this.cacheDirectory, tempFile_absolutepath, sparkGorMonitor);
                engine.execute();
                object = Files.move(temp_cacheFile, cacheFilePath, new CopyOption[0]);
            }
            catch (Exception e) {
                this.handleException(e, temp_cacheFile);
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(jobId2).append('\t').append(commandSignature2).append('\t').append(cacheFile2).toString()}));
    }

    public String[] collect() {
        return (String[])super.collect();
    }

    public Partition[] getPartitions() {
        ListBuffer plist = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int i = 0; i < this.commandsToExecute.length; ++i) {
            plist.$plus$eq((Object)new GorPartition(i));
        }
        return (Partition[])plist.toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public GorQueryRDD(SparkSession sparkSession, String[] commandsToExecute, String[] commandSignatures, String[] cacheFiles, String projectDirectory, String cacheDirectory, String[] jobIds, String redisUri) {
        this.commandsToExecute = commandsToExecute;
        this.commandSignatures = commandSignatures;
        this.cacheFiles = cacheFiles;
        this.projectDirectory = projectDirectory;
        this.cacheDirectory = cacheDirectory;
        this.jobIds = jobIds;
        this.redisUri = redisUri;
        super(sparkSession.sparkContext(), (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        Predef$.MODULE$.require(cacheDirectory != null);
        Predef$.MODULE$.require(projectDirectory != null);
        Predef$.MODULE$.require(commandsToExecute != null);
        Predef$.MODULE$.require(commandSignatures != null);
        Predef$.MODULE$.require(cacheFiles != null);
        Predef$.MODULE$.require(commandsToExecute.length == cacheFiles.length);
    }
}

