/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import org.aeonbits.owner.Config;
import org.gorpipe.base.config.annotations.Documentation;

public interface GorSparkConfig
extends Config {
    public static final String SPARK_MASTER = "GOR_SPARK_MASTER";
    public static final String SPARK_JARS = "gor.spark.jars";
    public static final String SPARK_UI_ENABLED = "gor.spark.ui.enabled";
    public static final String SPARK_EVENTLOG_DIR = "gor.spark.eventLog.dir";
    public static final String SPARK_DRIVER_MEM = "gor.spark.driver.memory";
    public static final String SPARK_EXECUTOR_MEM = "gor.spark.executor.memory";
    public static final String SPARK_EXECUTOR_CORES = "gor.spark.executor.cores";
    public static final String SPARK_EXECUTOR_INSTANCES = "gor.spark.executor.instances";
    public static final String SPARK_DEPLOY_MODE = "gor.spark.deploy.mode";
    public static final String SPARK_KUBERNETESE_NAMESPACE = "GOR_SPARK_KUBERNETES_NAMESPACE";
    public static final String SPARK_REDIS_URL = "gor.spark.redis.url";
    public static final String SPARK_INITIAL_EXECUTORS = "GOR_SPARK_INITIAL_EXECUTORS";
    public static final String SPARK_MIN_EXECUTORS = "GOR_SPARK_MIN_EXECUTORS";
    public static final String SPARK_MAX_EXECUTORS = "GOR_SPARK_MAX_EXECUTORS";
    public static final String SPARK_EXECUTOR_TIMEOUT = "GOR_SPARK_EXECUTOR_TIMEOUT";
    public static final String SPARK_PERSISTENT_VOLUME_CLAIM = "GOR_SPARK_KUBERNETES_PERSISTENT_VOLUME_CLAIM";
    public static final String SPARK_MOUNT_PATH = "GOR_SPARK_KUBERNETES_MOUNT_PATH";

    @Documentation(value="")
    @Config.Key(value="GOR_SPARK_MASTER")
    @Config.DefaultValue(value="local[*]")
    public String sparkMaster();

    @Documentation(value="")
    @Config.Key(value="gor.spark.jars")
    @Config.DefaultValue(value="")
    public String sparkJars();

    @Documentation(value="")
    @Config.Key(value="gor.spark.ui.enabled")
    @Config.DefaultValue(value="false")
    public String sparkUiEnabled();

    @Documentation(value="")
    @Config.Key(value="gor.spark.eventLog.dir")
    @Config.DefaultValue(value="")
    public String eventLogDir();

    @Documentation(value="")
    @Config.Key(value="gor.spark.driver.memory")
    @Config.DefaultValue(value="2000000000")
    public String sparkDriverMemory();

    @Documentation(value="")
    @Config.Key(value="gor.spark.executor.memory")
    @Config.DefaultValue(value="8g")
    public String sparkExecutorMemory();

    @Documentation(value="")
    @Config.Key(value="gor.spark.executor.cores")
    @Config.DefaultValue(value="1")
    public String sparkExecutorCores();

    @Documentation(value="")
    @Config.Key(value="gor.spark.executor.instances")
    @Config.DefaultValue(value="2")
    public String sparkExecutorInstances();

    @Documentation(value="")
    @Config.Key(value="gor.spark.deploy.mode")
    @Config.DefaultValue(value="client")
    public String sparkDeployMode();

    @Documentation(value="")
    @Config.Key(value="GOR_SPARK_KUBERNETES_NAMESPACE")
    @Config.DefaultValue(value="gorkube")
    public String getSparkKuberneteseNamespace();

    @Documentation(value="The fully qualified redis url to the redis that is servicing spark jobs")
    @Config.Key(value="gor.spark.redis.url")
    @Config.DefaultValue(value="")
    public String sparkRedisUrl();

    @Documentation(value="")
    @Config.Key(value="GOR_SPARK_INITIAL_EXECUTORS")
    @Config.DefaultValue(value="0")
    public String getSparkInitialExecutors();

    @Documentation(value="")
    @Config.Key(value="GOR_SPARK_MIN_EXECUTORS")
    @Config.DefaultValue(value="0")
    public String getSparkMinExecutors();

    @Documentation(value="")
    @Config.Key(value="GOR_SPARK_MAX_EXECUTORS")
    @Config.DefaultValue(value="100")
    public String getSparkMaxExecutors();

    @Documentation(value="")
    @Config.Key(value="GOR_SPARK_EXECUTOR_TIMEOUT")
    @Config.DefaultValue(value="240s")
    public String getSparkExecutorTimeout();

    @Documentation(value="")
    @Config.Key(value="GOR_SPARK_KUBERNETES_PERSISTENT_VOLUME_CLAIM")
    @Config.DefaultValue(value="pvc-gor-nfs")
    public String getSparkPersistentVolumeClaim();

    @Documentation(value="")
    @Config.Key(value="GOR_SPARK_KUBERNETES_MOUNT_PATH")
    @Config.DefaultValue(value="/mnt/csa")
    public String getSparkMountPath();
}

