/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import io.projectglow.GlowBase;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.SparkConf;
import org.apache.spark.ml.linalg.SQLDataTypes;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.base.config.ConfigManager;
import org.gorpipe.spark.GorSparkConfig;
import org.gorpipe.spark.SparkGorRow;
import org.gorpipe.spark.udfs.CharToDoubleArray;
import org.gorpipe.spark.udfs.CommaToDoubleArray;
import org.gorpipe.spark.udfs.CommaToDoubleMatrix;
import org.gorpipe.spark.udfs.CommaToIntArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorSparkUtilities {
    private static final Logger log = LoggerFactory.getLogger(GorSparkUtilities.class);
    private static SparkSession spark;
    private static Map<String, SparkSession> sessionProfiles;

    private GorSparkUtilities() {
    }

    public static SparkSession getSparkSession(String gorroot, String hostMount) {
        return GorSparkUtilities.getSparkSession(gorroot, hostMount, null);
    }

    public static SparkSession newSparkSession(String gorroot, String hostMount, String profile) {
        Path p;
        GorSparkConfig config = (GorSparkConfig)ConfigManager.createPrefixConfig((String)"spark", GorSparkConfig.class, (Map[])new Map[0]);
        log.debug("SparkSession from config");
        log.info("SparkMaster from config " + config.sparkMaster());
        if (gorroot == null || hostMount != null || (hostMount = System.getenv("GORPROJECT_PATH")) != null || Files.exists(p = Paths.get("/gorproject/zeppelin-server.yaml", new String[0]), new LinkOption[0])) {
            // empty if block
        }
        SparkConf sparkConf = new SparkConf();
        String master = config.sparkMaster();
        SparkSession.Builder ssb = SparkSession.builder().appName("GorSpark " + UUID.randomUUID()).master(master).config("spark.driver.memory", config.sparkDriverMemory()).config("spark.executor.memory", config.sparkExecutorMemory()).config("spark.executor.cores", config.sparkExecutorCores()).config("spark.executor.instances", config.sparkExecutorInstances()).config("spark.submit.deployMode", config.sparkDeployMode()).config("spark.kubernetes.namespace", config.getSparkKuberneteseNamespace()).config("spark.dynamicAllocation.enabled", "true").config("spark.dynamicAllocation.shuffleTracking.enabled", "true").config("spark.dynamicAllocation.minExecutors", config.getSparkMinExecutors()).config("spark.dynamicAllocation.maxExecutors", config.getSparkMaxExecutors()).config("spark.dynamicAllocation.initialExecutors", config.getSparkInitialExecutors()).config("spark.dynamicAllocation.executorIdleTimeout", config.getSparkExecutorTimeout());
        if (master.startsWith("k8s://")) {
            String image = profile == null ? "nextcode/spark:3.0.0" : profile;
            ssb = ssb.config("spark.kubernetes.container.image", image).config("spark.kubernetes.executor.container.image", image).config("spark.kubernetes.executor.volumes.persistentVolumeClaim.mntcsa.options.claimName", config.getSparkPersistentVolumeClaim()).config("spark.kubernetes.executor.volumes.persistentVolumeClaim.mntcsa.mount.readOnly", profile != null).config("spark.kubernetes.container.image.pullSecrets", "dockerhub-nextcode-download-credentials").config("spark.kubernetes.container.image.pullPolicy", "Always").config("spark.kubernetes.executor.deleteOnTermination", "false").config("spark.kubernetes.authenticate.driver.serviceAccountName", "spark-autoscaler");
            ssb = profile != null ? ssb.config("spark.kubernetes.executor.volumes.persistentVolumeClaim.mntcsa.mount.path", gorroot).config("spark.kubernetes.executor.volumes.persistentVolumeClaim.mntcsa.mount.subPath", gorroot) : ssb.config("spark.kubernetes.executor.volumes.persistentVolumeClaim.mntcsa.mount.path", config.getSparkMountPath());
        } else if (master.startsWith("local")) {
            ssb = ssb.config("spark.driver.bindAddress", "127.0.0.1");
        }
        SparkSession spark = ssb.config(sparkConf).getOrCreate();
        spark.udf().register("chartodoublearray", (UDF1)new CharToDoubleArray(), (DataType)DataTypes.createArrayType((DataType)DataTypes.DoubleType));
        spark.udf().register("todoublearray", (UDF1)new CommaToDoubleArray(), (DataType)DataTypes.createArrayType((DataType)DataTypes.DoubleType));
        spark.udf().register("todoublematrix", (UDF1)new CommaToDoubleMatrix(), SQLDataTypes.MatrixType());
        spark.udf().register("tointarray", (UDF1)new CommaToIntArray(), (DataType)DataTypes.createArrayType((DataType)DataTypes.IntegerType));
        GlowBase gb = new GlowBase();
        gb.register(spark);
        return spark;
    }

    public static SparkSession getSparkSession(String gorroot, String hostMount, String profile) {
        if (profile != null) {
            if (sessionProfiles.containsKey(profile)) {
                return sessionProfiles.get(profile);
            }
            SparkSession spark = GorSparkUtilities.newSparkSession(gorroot, hostMount, profile);
            sessionProfiles.put(profile, spark);
            return spark;
        }
        if (spark == null) {
            if (!SparkSession.getDefaultSession().isEmpty()) {
                log.debug("SparkSession from default");
                spark = (SparkSession)SparkSession.getDefaultSession().get();
            } else {
                spark = GorSparkUtilities.newSparkSession(gorroot, hostMount, profile);
            }
        }
        return spark;
    }

    private static void activateEventLogIfSet(GorSparkConfig sparkGorConfig, SparkConf sparkConf) {
        if (!sparkGorConfig.eventLogDir().isEmpty()) {
            String pathname = sparkGorConfig.eventLogDir();
            File eventFolder = new File(pathname);
            if (eventFolder.mkdirs()) {
                log.info("Spark event log folder created {}", (Object)eventFolder.getAbsolutePath());
            }
            sparkConf.set("spark.eventLog.enabled", "true");
            sparkConf.set("spark.eventLog.dir", eventFolder.getAbsolutePath());
        }
    }

    public static List<Row> stream2SparkRowList(Stream<org.gorpipe.gor.model.Row> str, StructType schema) {
        return str.map(p -> new SparkGorRow((org.gorpipe.gor.model.Row)p, schema)).collect(Collectors.toList());
    }

    static {
        sessionProfiles = new HashMap<String, SparkSession>();
    }
}

