/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import java.io.Serializable;
import java.time.Duration;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.spark.platform.JedisURIHelper;
import org.gorpipe.spark.platform.JobField;
import org.gorpipe.spark.platform.SharedRedisPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class SparkGorMonitor
extends GorMonitor
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SparkGorMonitor.class);
    public static GorMonitor localProgressMonitor;
    private JedisPool jedisPool;
    private String uri;
    private String jobId;
    boolean working = true;

    public SparkGorMonitor(String uri, String jobId) {
        this.uri = uri;
        this.jobId = jobId;
        if (uri != null && uri.length() > 0) {
            try {
                this.jedisPool = SharedRedisPools.getJedisPool(JedisURIHelper.create(uri));
            }
            catch (Exception e) {
                this.working = false;
            }
        } else {
            this.working = false;
        }
    }

    public String getRedisUri() {
        return this.uri;
    }

    private String getJobKey(String jobId) {
        return this.getKey("JOB", jobId);
    }

    public Duration getJobExpiration() {
        return Duration.ofMinutes(20L);
    }

    public String getValue(JobField field) {
        block13: {
            if (this.working) {
                String string;
                block12: {
                    Jedis jedis = this.jedisPool.getResource();
                    try {
                        String jobKey = this.getJobKey(this.jobId);
                        string = jedis.hget(jobKey, field.key());
                        if (jedis == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (jedis != null) {
                                try {
                                    jedis.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (JedisConnectionException jce) {
                            if (!jce.getMessage().contains("SocketTimeout")) {
                                this.working = false;
                            }
                            this.logError("Updating progress resulted in an error", jce);
                            break block13;
                        }
                        catch (ClassCastException cce) {
                            log.debug("Unable to get a connection to redis at " + this.uri, (Throwable)cce);
                            break block13;
                        }
                        catch (Exception jde) {
                            this.working = false;
                            log.debug("Unable to get a connection to redis at " + this.uri);
                        }
                    }
                    jedis.close();
                }
                return string;
            }
        }
        return null;
    }

    public void setValue(JobField field, String value) {
        if (!this.working) {
            return;
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            String jobKey = this.getJobKey(this.jobId);
            jedis.hset(jobKey, field.key(), value);
            jedis.expire(jobKey, (int)this.getJobExpiration().getSeconds());
        }
        catch (Exception jde) {
            this.working = false;
            log.debug("Unable to get a connection to redis at localhost:6379");
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void logError(String message, Throwable th) {
        log.error(message, th);
    }

    String getKey(String ... parts) {
        return "resque:DC:" + String.join((CharSequence)":", parts);
    }

    String getPrivateLogKey(String jobId) {
        return this.getKey("JOB", jobId, "LOG");
    }

    public void log(String progress) {
        if (!this.working) {
            return;
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.publish(this.getPrivateLogKey(this.jobId), progress);
        }
        catch (JedisConnectionException jce) {
            if (!jce.getMessage().contains("SocketTimeout")) {
                this.working = false;
            }
            this.logError("Updating progress resulted in an error", jce);
        }
        catch (Exception e) {
            this.working = false;
            this.logError("Updating progress resulted in an error", e);
        }
    }
}

