/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import gorsat.spark.GORzip;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.gor.binsearch.GorIndexType;
import org.gorpipe.spark.GorSparkRow;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class GorOutputWriter
extends OutputWriter {
    GORzip of;
    ExpressionEncoder.Deserializer<Row> deserializer;
    Path path;
    String originalPath;

    public GorOutputWriter(String uristr, StructType schema, String originalPath) throws IOException {
        this.originalPath = originalPath;
        List lattr = JavaConverters.asJavaCollection((Iterable)schema.toAttributes()).stream().map(Attribute::toAttribute).collect(Collectors.toList());
        Seq sattr = JavaConverters.asScalaBuffer(lattr).toSeq();
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema).resolveAndBind(sattr, (Analyzer)SimpleAnalyzer$.MODULE$);
        this.deserializer = encoder.createDeserializer();
        String header = String.join((CharSequence)"\t", schema.fieldNames());
        URI uri = URI.create(uristr);
        this.path = new Path(uri);
        this.of = new GORzip(this.path, header, false, false, GorIndexType.NONE, 1, "");
        this.of.setup();
    }

    public void write(InternalRow row) {
        Row grow = (Row)this.deserializer.apply(row);
        GorSparkRow sparkrow = new GorSparkRow(grow);
        this.of.process(sparkrow);
    }

    public void close() {
        this.of.finish();
    }
}

