/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Iterator;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.gorpipe.gor.binsearch.GorZipLexOutputStream;

public class GorzIterator
implements MapPartitionsFunction<String, String> {
    String header;

    public GorzIterator() {
        this(null);
    }

    public GorzIterator(String header) {
        this.header = header;
    }

    public Iterator<String> call(Iterator<String> iterator) throws Exception {
        PipedInputStream pip = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pip);
        GorZipLexOutputStream gzlos = new GorZipLexOutputStream((OutputStream)pos, false, false, null, true);
        if (this.header != null) {
            gzlos.setHeader(this.header);
        }
        Thread t = new Thread(() -> {
            try {
                while (iterator.hasNext()) {
                    gzlos.write((String)iterator.next());
                }
                gzlos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        t.start();
        InputStreamReader isr = new InputStreamReader(pip);
        BufferedReader br = new BufferedReader(isr);
        return br.lines().iterator();
    }
}

