/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.gorpipe.gor.model.GorParallelQueryHandler;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.spark.platform.BatchSubmission;
import org.gorpipe.spark.platform.GorClusterConfig;
import org.gorpipe.spark.platform.GorJob;
import org.gorpipe.spark.platform.GorLocks;
import org.gorpipe.spark.platform.GorLogReceiver;
import org.gorpipe.spark.platform.GorLogSubscription;
import org.gorpipe.spark.platform.GorQuery;
import org.gorpipe.spark.platform.GorTaskBase;
import org.gorpipe.spark.platform.JobField;
import org.gorpipe.spark.platform.JobMonitor;
import org.gorpipe.spark.platform.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public abstract class GorClusterBase
implements Runnable,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(GorClusterBase.class);
    private String localHostName;
    private Runnable onWorkerException;

    public abstract Duration getJobRetention();

    public abstract Duration getJobExpiration();

    public abstract GorClusterConfig getConfig();

    public abstract void logInfo(String var1, Throwable var2);

    public abstract void logDebug(String var1);

    public abstract void logWarn(String var1, Throwable var2);

    public abstract void logError(String var1, Throwable var2);

    public abstract void logProgress(String var1, String var2);

    public abstract String getValue(String var1, JobField var2);

    public abstract void setValue(String var1, JobField var2, String var3);

    public abstract void yieldFor(Collection<GorJob> var1, String var2, JobMonitor var3) throws InterruptedException;

    public abstract GorLocks locks();

    public abstract JedisPool pool();

    public abstract GorLogSubscription addLogSubscription(GorLogReceiver var1, String ... var2);

    public abstract GorJob findJob(String var1);

    public abstract Map<JobStatus, Integer> getJobStatusesByRequestId(String var1);

    public abstract String getJobMessage(String var1);

    public abstract void subscribeGorMonitor(String var1, GorMonitor var2);

    public abstract boolean jobExists(String var1);

    public abstract GorJob findJobByFingerprint(String var1, Function<URI, GorClusterBase> var2);

    public abstract void registerJobByFingerprint(String var1, GorJob var2);

    protected abstract void forget(GorTaskBase var1);

    public abstract Statistics getCurrentStatistics();

    public abstract GorJob submit(String var1, String var2, Object ... var3);

    public abstract List<GorJob> submit(String var1, BatchSubmission var2);

    public abstract GorJob prioritySubmit(String var1, String var2, Object ... var3);

    public abstract void addScore(String var1, int var2);

    public abstract String storeSecurityContext(String var1);

    public abstract String getSecurityContext(String var1);

    public abstract GorParallelQueryHandler createQueryHandler(boolean var1, GorQuery var2, String var3);

    public abstract Object createWorker();

    public abstract Object createWorker(String var1);

    public void waitFor(Iterable<GorJob> jobs, JobMonitor monitor) throws InterruptedException {
        try {
            for (GorJob job : jobs) {
                job.waitFor(true, monitor, this.getJobRetention());
            }
        }
        catch (InterruptedException | RuntimeException ie) {
            GorClusterBase.cancel(jobs);
            throw ie;
        }
    }

    public static void cancel(Iterable<GorJob> jobs) {
        for (GorJob job : jobs) {
            try {
                job.cancel();
            }
            catch (Exception e) {
                log.info("Ignoring exception caught in cancel", (Throwable)e);
            }
        }
    }

    protected String getLocalHostName() {
        if (this.localHostName == null) {
            try {
                this.localHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot get local host name", e);
            }
        }
        return this.localHostName;
    }

    public void workerFatalException(Object source, Throwable t) {
        if (this.onWorkerException != null) {
            log.info("Calling worker exception hook");
            this.onWorkerException.run();
        }
    }

    public void onWorkerException(Runnable runnable) {
        this.onWorkerException = runnable;
    }

    public class Statistics {
        public long workerCount;
        public long pendingJobCount;
        public long runningJobCount;
    }
}

