/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.BatchedPipeStepIteratorAdaptor;
import gorsat.Commands.Analysis;
import gorsat.process.GenericSessionFactory;
import gorsat.process.GorPipe;
import gorsat.process.PipeInstance;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.spark.SparkGorMonitor;
import org.gorpipe.spark.SparkGorRow;

public class GorSpark
implements MapPartitionsFunction<Row, Row> {
    StructType schema;
    boolean nor;
    String header;
    String gorcmd;
    String gorroot;
    String uri;
    String jobId;

    public GorSpark(String inputHeader, boolean nor, StructType schema, String gorcmd, String gorroot) {
        this.schema = schema;
        this.nor = nor;
        this.header = inputHeader;
        this.gorcmd = gorcmd;
        this.gorroot = gorroot;
    }

    public GorSpark(String inputHeader, boolean nor, StructType schema, String gorcmd, String gorroot, String uri, String jobId) {
        this(inputHeader, nor, schema, gorcmd, gorroot);
        this.uri = uri;
        this.jobId = jobId;
    }

    public void setSchema(StructType st) {
        this.schema = st;
    }

    public PipeInstance query() {
        Path projectPath = Paths.get(this.gorroot, new String[0]);
        GenericSessionFactory gsf = Files.exists(projectPath, new LinkOption[0]) ? new GenericSessionFactory(this.gorroot, "result_cache") : new GenericSessionFactory();
        GorSession gps = gsf.create();
        gps.setNorContext(this.nor);
        if (this.uri != null) {
            SparkGorMonitor gorMonitor = new SparkGorMonitor(this.uri, this.jobId);
            gps.getSystemContext().setMonitor((GorMonitor)gorMonitor);
        }
        PipeInstance pi = new PipeInstance(gps.getGorContext());
        pi.init(this.gorcmd, true, this.header);
        return pi;
    }

    BatchedPipeStepIteratorAdaptor getIterator(Iterator<? extends Row> iterator) {
        PipeInstance pi = this.query();
        Analysis an = pi.getPipeStep();
        return new BatchedPipeStepIteratorAdaptor(iterator, an, this.header, GorPipe.brsConfig());
    }

    public Iterator<Row> call(Iterator<Row> iterator) {
        return StreamSupport.stream(this.getIterator(iterator), false).map(r -> new SparkGorRow((Row)r, this.schema)).iterator();
    }
}

