/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import gorsat.Commands.Output;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.gor.binsearch.GorIndexType;
import org.gorpipe.gor.binsearch.GorZipLexOutputStream;
import org.gorpipe.gor.model.GorMeta;
import org.gorpipe.gor.model.Row;

public class GORzip
extends Output {
    GorZipLexOutputStream out;
    Path path;
    FileSystem fs;
    String header;
    boolean skipHeader;
    String cardCol;

    public GORzip(Path path, String header, boolean skipHeader, boolean colcompress, GorIndexType idx, int compressionLevel, String cardCol) throws IOException {
        Configuration conf = new Configuration();
        this.fs = path.getFileSystem(conf);
        FSDataOutputStream os = this.fs.create(path);
        this.out = new GorZipLexOutputStream((OutputStream)os, colcompress, true, null, null, idx, compressionLevel);
        this.path = path;
        this.header = header;
        this.skipHeader = skipHeader;
        this.cardCol = cardCol;
    }

    public void setup() {
        GorMeta meta = this.getMeta();
        if (this.cardCol != null) {
            meta.initCardCol(this.cardCol, this.header);
        }
        if (this.header != null & !this.skipHeader) {
            try {
                this.out.setHeader(this.header);
            }
            catch (IOException e) {
                throw new GorResourceException("", "", (Throwable)e);
            }
        }
    }

    public void process(Row r) {
        this.getMeta().updateRange(r);
        try {
            this.out.write(r);
        }
        catch (IOException e) {
            throw new GorResourceException("Unable to write gorz", this.path.toString(), (Throwable)e);
        }
    }

    public void finish() {
        Path metapath = new Path(this.path.getParent(), this.path.getName() + ".meta");
        try {
            this.out.close();
            this.getMeta().setMd5(this.out.getMd5());
            if (this.getMeta().linesWritten()) {
                FSDataOutputStream metaout = this.fs.create(metapath);
                metaout.write(this.getMeta().toString().getBytes());
                metaout.close();
            }
        }
        catch (IOException e) {
            throw new GorResourceException("Unable to write gorz meta", this.path.toString(), (Throwable)e);
        }
    }
}

