/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.gor.binsearch.Unzipper;
import org.gorpipe.model.gor.RowObj;
import org.gorpipe.spark.SparkGorRow;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

class GorzFunction
implements Function1<PartitionedFile, Iterator<InternalRow>>,
Serializable {
    Function1<PartitionedFile, Iterator<InternalRow>> func;
    ExpressionEncoder<Row> encoder;
    ExpressionEncoder.Serializer<Row> serializer;
    Unzipper unzip;
    String chrom;
    int start;
    int stop;
    byte[] unzipped;

    GorzFunction(Function1 func, StructType schema, Collection<Filter> filters) {
        this.func = func;
        this.unzipped = new byte[131072];
        List lattr = JavaConverters.asJavaCollection((Iterable)schema.toAttributes()).stream().map(Attribute::toAttribute).collect(Collectors.toList());
        Seq sattr = JavaConverters.asScalaBuffer(lattr).toSeq();
        this.encoder = RowEncoder.apply((StructType)schema).resolveAndBind(sattr, (Analyzer)SimpleAnalyzer$.MODULE$);
        this.serializer = this.encoder.createSerializer();
        this.unzip = new Unzipper();
        this.chrom = filters.stream().filter(f -> f instanceof EqualTo).map(f -> (EqualTo)f).filter(f -> f.attribute().equalsIgnoreCase("chrom")).map(EqualTo::value).map(Object::toString).findFirst().orElse(null);
        this.start = filters.stream().filter(f -> f instanceof GreaterThan).map(f -> (GreaterThan)f).filter(f -> f.attribute().equalsIgnoreCase("pos")).map(GreaterThan::value).map(f -> (Integer)f).findFirst().orElse(-1);
        this.stop = filters.stream().filter(f -> f instanceof LessThan).map(f -> (LessThan)f).filter(f -> f.attribute().equalsIgnoreCase("pos")).map(LessThan::value).map(f -> (Integer)f).findFirst().orElse(-1);
    }

    public Iterator<InternalRow> apply(PartitionedFile v1) {
        Iterator it = (Iterator)this.func.apply((Object)v1);
        Stream<String> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(JavaConverters.asJavaIterator((Iterator)it), 16), false).map(ir -> ir.getString(0));
        Stream<InternalRow> istream = stream.map(RowObj::apply).map(r -> new SparkGorRow((org.gorpipe.gor.model.Row)r, this.encoder.schema())).map(r -> this.serializer.apply(r).copy());
        java.util.Iterator iterator = istream.iterator();
        return JavaConverters.asScalaIterator(iterator);
    }

    public <A> Function1<A, Iterator<InternalRow>> compose(Function1<A, PartitionedFile> g) {
        return this.func.compose(g);
    }

    public <A> Function1<PartitionedFile, A> andThen(Function1<Iterator<InternalRow>, A> g) {
        return this.func.andThen(g);
    }
}

