/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import gorsat.spark.GorRangeInputPartition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.unsafe.types.UTF8String;

public class NativePartitionReader
implements PartitionReader<InternalRow> {
    BufferedReader br;
    String currentLine;
    GenericInternalRow gir;
    StructField[] fields;
    GorRangeInputPartition p;

    public NativePartitionReader(StructField[] fields, GorRangeInputPartition gorRangeInputPartition) {
        this.fields = fields;
        this.gir = new GenericInternalRow(new Object[fields.length]);
        this.p = gorRangeInputPartition;
    }

    public boolean next() {
        try {
            if (this.br == null) {
                ProcessBuilder processBuilder = new ProcessBuilder("cgor", "-p", this.p.chr, this.p.path);
                Process process = processBuilder.start();
                InputStream is = process.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                this.br = new BufferedReader(isr);
                this.br.readLine();
            }
            this.currentLine = this.br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.currentLine != null;
    }

    public void updateRow(int start, int last, int i) {
        String str = this.currentLine.substring(start, last);
        StructField sf = this.fields[i];
        if (sf.dataType() == DataTypes.StringType) {
            this.gir.update(i, (Object)UTF8String.fromString((String)str));
        } else if (sf.dataType() == DataTypes.IntegerType) {
            this.gir.update(i, (Object)Integer.parseInt(str));
        } else if (sf.dataType() == DataTypes.DoubleType) {
            this.gir.update(i, (Object)Double.parseDouble(str));
        } else if (sf.dataType() == DataTypes.LongType) {
            this.gir.update(i, (Object)Long.parseLong(str));
        }
    }

    public InternalRow get() {
        int last;
        int i;
        int start = 0;
        for (i = 0; i < this.fields.length - 1; ++i) {
            last = this.currentLine.indexOf(9, start + 1);
            this.updateRow(start, last, i);
            start = last + 1;
        }
        last = this.currentLine.length();
        this.updateRow(start, last, i);
        return this.gir;
    }

    public void close() throws IOException {
        this.br.close();
    }
}

