/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.gor.function.GorRowMapFunction;
import org.gorpipe.gor.model.Row;

public class GorSparkRowMapFunction
extends GorRowMapFunction
implements MapFunction<Row, Row> {
    StructType schema;

    public GorSparkRowMapFunction(String name, String query, StructType schema) {
        super(query, schema.fieldNames(), (String[])Arrays.stream(schema.fields()).map(StructField::dataType).map(d -> {
            if (d.sameType(DataTypes.IntegerType)) {
                return "I";
            }
            if (d.sameType(DataTypes.DoubleType)) {
                return "D";
            }
            return "S";
        }).toArray(String[]::new));
        this.schema = this.deriveSchema(name, schema);
    }

    public GorSparkRowMapFunction(String name, String query, String[] header, String[] types) {
        super(query, header, types);
        this.schema = this.deriveSchema(name, header, types);
    }

    public StructType getSchema() {
        return this.schema;
    }

    private StructType deriveSchema(String name, String[] header, String[] types) {
        StructField[] fields = new StructField[header.length + 1];
        IntStream.range(0, types.length).forEach(i -> {
            fields[i] = types[i].equals("I") ? new StructField(name, DataTypes.IntegerType, true, Metadata.empty()) : (types[i].equals("D") ? new StructField(name, DataTypes.DoubleType, true, Metadata.empty()) : new StructField(name, DataTypes.StringType, true, Metadata.empty()));
        });
        fields[fields.length - 1] = this.calcType.equals("Int") ? new StructField(name, DataTypes.IntegerType, true, Metadata.empty()) : (this.calcType.equals("Double") ? new StructField(name, DataTypes.DoubleType, true, Metadata.empty()) : new StructField(name, DataTypes.StringType, true, Metadata.empty()));
        return new StructType(fields);
    }

    private StructType deriveSchema(String name, StructType schema) {
        StructField[] fields = new StructField[schema.size() + 1];
        StructField[] sfields = schema.fields();
        IntStream.range(0, schema.size()).forEach(i -> {
            fields[i] = sfields[i];
        });
        fields[fields.length - 1] = this.calcType.equals("Int") ? new StructField(name, DataTypes.IntegerType, true, Metadata.empty()) : (this.calcType.equals("Double") ? new StructField(name, DataTypes.DoubleType, true, Metadata.empty()) : new StructField(name, DataTypes.StringType, true, Metadata.empty()));
        return new StructType(fields);
    }

    public Row call(Row row) {
        return this.apply(row);
    }
}

