/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.sql.Row;

public class GorpWriter
implements MapPartitionsFunction<Row, Row> {
    String path;

    public GorpWriter(String path) {
        this.path = path;
    }

    public Iterator<Row> call(final Iterator<Row> input) {
        return new Iterator<Row>(){
            Row first;
            Row last;

            @Override
            public boolean hasNext() {
                boolean ret = input.hasNext();
                if (!ret && this.first != null) {
                    try {
                        Path gorp = Paths.get(GorpWriter.this.path, new String[0]);
                        Files.writeString(gorp, (CharSequence)(this.first.getString(0) + "\t" + this.first.getInt(1) + "\t" + this.last.getString(0) + "\t" + this.last.getInt(1) + "\n"), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return ret;
            }

            @Override
            public Row next() {
                this.last = (Row)input.next();
                if (this.first == null) {
                    this.first = this.last;
                }
                return this.last;
            }
        };
    }
}

