/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import gorsat.BatchedReadSource;
import gorsat.Commands.Analysis;
import gorsat.Commands.Output;
import gorsat.Outputs.NorStdOut;
import gorsat.Outputs.OutFile;
import gorsat.Outputs.StdOut;
import gorsat.process.GorExecutionEngine;
import gorsat.process.GorPipe;
import gorsat.process.PipeInstance;
import gorsat.process.SparkPipeInstance;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import org.gorpipe.gor.binsearch.GorIndexType;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.gor.session.GorRunner;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.spark.SparkSessionFactory;
import scala.Option;

public class SparkGorExecutionEngine
extends GorExecutionEngine {
    private String query;
    private String projectDirectory;
    private String cacheDirectory;
    private Path outfile;
    private String configFile;
    private String aliasFile;
    private GorMonitor sparkMonitor;
    private String securityContext;
    private int workers;

    public SparkGorExecutionEngine(String query, String projectDirectory, String cacheDirectory, String configFile, String aliasFile, Path outfile, String securityContext, GorMonitor sparkMonitor) {
        this(query, projectDirectory, cacheDirectory, configFile, aliasFile, outfile, securityContext, sparkMonitor, 0);
    }

    public SparkGorExecutionEngine(String query, String projectDirectory, String cacheDirectory, String configFile, String aliasFile, Path outfile, String securityContext, GorMonitor sparkMonitor, int workers) {
        this.query = query;
        this.projectDirectory = projectDirectory;
        this.cacheDirectory = cacheDirectory;
        this.configFile = configFile;
        this.aliasFile = aliasFile;
        this.outfile = outfile;
        this.sparkMonitor = sparkMonitor;
        this.workers = workers;
        this.securityContext = securityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        GenomicIterator brs = null;
        Analysis processor = null;
        Exception exception = null;
        try (GorSession session = this.createSession();){
            PipeInstance pinst = this.createIterator(session);
            GenomicIterator iterator = pinst.theInputSource();
            processor = pinst.thePipeStep();
            if (processor != null) {
                brs = iterator.isBuffered() ? iterator : new BatchedReadSource(iterator, GorPipe.brsConfig());
                processor.rs_$eq(iterator);
                processor.securedSetup(null);
                while (brs.hasNext() && !processor.wantsNoMore()) {
                    processor.process((Row)brs.next());
                }
            }
        }
        catch (Exception ex) {
            exception = ex;
            throw ex;
        }
        finally {
            try {
                if (processor != null) {
                    processor.securedFinish((Throwable)exception);
                }
            }
            finally {
                if (brs != null) {
                    brs.close();
                }
            }
        }
    }

    public GorSession createSession() {
        SparkSessionFactory sessionFactory = new SparkSessionFactory(null, this.projectDirectory, this.cacheDirectory, this.configFile, this.aliasFile, this.securityContext, this.sparkMonitor, this.workers);
        return sessionFactory.create();
    }

    public PipeInstance createIterator(GorSession session) {
        SparkPipeInstance pi = new SparkPipeInstance(session.getGorContext(), this.outfile != null ? this.outfile.toString() : null);
        pi.init(this.query, false, null, false, null);
        if (!pi.hasResourceHints()) {
            String theHeader = pi.getIterator().getHeader();
            if (this.outfile != null) {
                Path outwritefile = !Files.exists(this.outfile, new LinkOption[0]) && this.outfile.toString().toLowerCase().endsWith(".gord") || Files.isDirectory(this.outfile, new LinkOption[0]) ? this.outfile.resolve(pi.isNorContext() ? UUID.randomUUID() + ".tsv" : UUID.randomUUID() + ".gorz") : this.outfile;
                Output ofile = OutFile.apply((String)outwritefile.toString(), (FileReader)session.getProjectContext().getFileReader(), (String)theHeader, (boolean)false, (boolean)false, (boolean)pi.isNorContext(), (boolean)true, (boolean)true, (GorIndexType)GorIndexType.NONE, (Option)Option.empty(), (int)1);
                pi.thePipeStep_$eq(pi.thePipeStep().$bar(ofile));
            } else {
                String header = pi.getHeader();
                if (session.getNorContext() || pi.isNorContext()) {
                    pi.thePipeStep_$eq(pi.thePipeStep().$bar((Output)NorStdOut.apply((String)header)));
                } else {
                    pi.thePipeStep_$eq(pi.thePipeStep().$bar((Output)StdOut.apply((String)header)));
                }
            }
        }
        return pi;
    }

    public GorRunner createRunner(GorSession session) {
        return (GorRunner)session.getSystemContext().getRunnerFactory().create();
    }
}

