/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.spark.GorSparkRowBase;

public class SparkGorRow
extends GorSparkRowBase
implements Serializable {
    public org.gorpipe.gor.model.Row row;
    StructType schema;
    static final DataType ARRAY_STRING = DataTypes.createArrayType((DataType)DataTypes.StringType, (boolean)true);

    public SparkGorRow(StructType schema) {
        this.schema = schema;
    }

    public SparkGorRow(org.gorpipe.gor.model.Row row, StructType schema) {
        this(schema);
        this.chr = row.chr;
        this.pos = row.pos;
        this.row = row;
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    @Override
    public String toString() {
        return this.row.toString();
    }

    public int size() {
        return this.row.numCols();
    }

    @Override
    public String toColString() {
        return this.row.toColString();
    }

    @Override
    public int colAsInt(int colNum) {
        return this.row.colAsInt(colNum);
    }

    @Override
    public double colAsDouble(int colNum) {
        return this.row.colAsDouble(colNum);
    }

    @Override
    public long colAsLong(int colNum) {
        return this.row.colAsLong(colNum);
    }

    @Override
    public CharSequence colAsString(int colNum) {
        return this.row.colAsString(colNum);
    }

    @Override
    public String otherCols() {
        return this.row.otherCols();
    }

    @Override
    public CharSequence colsSlice(int startCol, int stopCol) {
        return this.row.colsSlice(startCol, stopCol);
    }

    @Override
    public CharSequence getAllCols() {
        return this.row.getAllCols();
    }

    @Override
    public int numCols() {
        return this.row.numCols();
    }

    @Override
    public int length() {
        return this.row.numCols();
    }

    @Override
    public String selectedColumns(int[] columnIndices) {
        return this.row.selectedColumns(columnIndices);
    }

    @Override
    public int otherColsLength() {
        return this.row.otherColsLength();
    }

    @Override
    public void addSingleColumnToRow(String rowString) {
        this.row.addSingleColumnToRow(rowString);
    }

    @Override
    public org.gorpipe.gor.model.Row slicedRow(int startCol, int stopCol) {
        return this.row.slicedRow(startCol, stopCol);
    }

    @Override
    public org.gorpipe.gor.model.Row rowWithSelectedColumns(int[] columnIndices) {
        return this.row.rowWithSelectedColumns(columnIndices);
    }

    @Override
    public int sa(int i) {
        return this.row.sa(i);
    }

    @Override
    public void resize(int newsize) {
        this.row.resize(newsize);
    }

    @Override
    public void setColumn(int i, String val) {
        this.row.setColumn(i, val);
    }

    @Override
    public void addColumns(int num) {
        this.row.addColumns(num);
    }

    @Override
    public void removeColumn(int n) {
        this.row.removeColumn(n);
    }

    @Override
    public char peekAtColumn(int n) {
        return this.row.peekAtColumn(n);
    }

    @Override
    public void writeRow(Writer outputStream) throws IOException {
        this.row.writeRow(outputStream);
    }

    @Override
    public void writeRowToStream(OutputStream outputStream) throws IOException {
        this.row.writeRowToStream(outputStream);
    }

    public void writeNorRowToStream(OutputStream outputStream) throws IOException {
        this.row.writeNorRowToStream(outputStream);
    }

    @Override
    public Object apply(int i) {
        return this.row.colAsString(i);
    }

    @Override
    public Object get(int i) {
        DataType dt = this.schema.fields()[i].dataType();
        if (dt == DataTypes.IntegerType) {
            try {
                return this.row.intValue(i);
            }
            catch (Exception e) {
                return -1;
            }
        }
        if (dt == DataTypes.FloatType) {
            try {
                return Float.valueOf((float)this.row.doubleValue(i));
            }
            catch (Exception e) {
                return Float.valueOf(Float.NaN);
            }
        }
        if (dt == DataTypes.DoubleType) {
            try {
                return this.row.doubleValue(i);
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
        if (dt == DataTypes.LongType) {
            return this.row.colAsLong(i);
        }
        if (dt == DataTypes.NullType) {
            return "d";
        }
        if (dt.equals(ARRAY_STRING)) {
            String str = this.row.stringValue(i);
            int id = (str = str.replace(", ", ",")).indexOf(40);
            return id == -1 ? str.split(",", -1) : str.substring(id + 1, str.length() - 1).split(",", -1);
        }
        return this.row.stringValue(i);
    }

    @Override
    public boolean isNullAt(int i) {
        return false;
    }

    @Override
    public String getString(int i) {
        return this.row.colAsString(i).toString();
    }

    @Override
    public Row copy() {
        return new SparkGorRow(this.row.copyRow(), this.schema);
    }

    @Override
    public boolean getBoolean(int i) {
        return Boolean.parseBoolean(this.row.colAsString(i).toString());
    }

    @Override
    public int getInt(int i) {
        return this.row.colAsInt(i);
    }

    @Override
    public long getLong(int i) {
        return this.row.colAsLong(i);
    }

    @Override
    public float getFloat(int i) {
        try {
            return (float)this.row.colAsDouble(i);
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    @Override
    public String stringValue(int col) {
        return this.row.colAsString(col).toString();
    }

    @Override
    public int intValue(int col) {
        return this.row.colAsInt(col);
    }

    @Override
    public long longValue(int col) {
        return this.row.colAsLong(col);
    }

    @Override
    public double doubleValue(int col) {
        try {
            return this.row.colAsDouble(col);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }
}

