/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.model.gor.RowObj;
import org.gorpipe.spark.GorSparkRowBase;

public class SparkRow
extends GorSparkRowBase
implements Serializable {
    public Row row;

    public SparkRow(Row sparkrow) {
        this.row = sparkrow;
        this.init();
    }

    public void init() {
        this.chr = "chrN";
        this.pos = 0;
    }

    @Override
    public Object apply(int i) {
        return this.row.apply(i);
    }

    @Override
    public Object get(int i) {
        return this.row.get(i);
    }

    @Override
    public boolean isNullAt(int i) {
        return this.row.isNullAt(i);
    }

    @Override
    public String getString(int i) {
        return this.row.getString(i);
    }

    @Override
    public Row copy() {
        return this.row.copy();
    }

    @Override
    public boolean getBoolean(int i) {
        return this.row.getBoolean(i);
    }

    @Override
    public int getInt(int i) {
        return this.row.getInt(i);
    }

    @Override
    public long getLong(int i) {
        return this.row.getLong(i);
    }

    @Override
    public float getFloat(int i) {
        return this.row.getFloat(i);
    }

    @Override
    public StructType schema() {
        return this.row.schema();
    }

    @Override
    public String stringValue(int col) {
        return this.row.getString(col);
    }

    @Override
    public int intValue(int col) {
        return this.row.getInt(col);
    }

    @Override
    public long longValue(int col) {
        if (this.schema().fields()[col].dataType() == DataTypes.IntegerType) {
            return this.row.getInt(col);
        }
        return this.row.getLong(col);
    }

    @Override
    public double doubleValue(int col) {
        return this.row.getDouble(col);
    }

    @Override
    public String toColString() {
        return this.row.mkString("(", ") (", ")");
    }

    @Override
    public int colAsInt(int colNum) {
        return this.row.getInt(colNum);
    }

    @Override
    public double colAsDouble(int colNum) {
        return this.row.getDouble(colNum);
    }

    @Override
    public long colAsLong(int colNum) {
        return this.row.getLong(colNum);
    }

    @Override
    public String colAsString(int colNum) {
        return this.row.get(colNum).toString();
    }

    @Override
    public String otherCols() {
        return this.row.mkString("\t");
    }

    @Override
    public CharSequence colsSlice(int startCol, int stopCol) {
        return IntStream.range(startCol, stopCol).mapToObj(i -> this.row.get(i).toString()).collect(Collectors.joining("\t"));
    }

    @Override
    public CharSequence getAllCols() {
        return this.row.mkString("\t");
    }

    @Override
    public String toString() {
        return this.getAllCols().toString();
    }

    @Override
    public int numCols() {
        return this.row.length();
    }

    @Override
    public String selectedColumns(int[] columnIndices) {
        return Arrays.stream(columnIndices).mapToObj(i -> this.row.getString(i)).collect(Collectors.joining("\t"));
    }

    @Override
    public int otherColsLength() {
        return this.otherCols().length();
    }

    @Override
    public void addSingleColumnToRow(String rowString) {
        this.row = RowFactory.create((Object[])Stream.concat(IntStream.range(0, this.row.length()).mapToObj(i -> this.row.get(i)), Stream.of(rowString)).toArray(Object[]::new));
    }

    @Override
    public org.gorpipe.gor.model.Row slicedRow(int startCol, int stopCol) {
        return RowObj.apply((CharSequence)this.colsSlice(startCol, stopCol));
    }

    @Override
    public org.gorpipe.gor.model.Row rowWithSelectedColumns(int[] columnIndices) {
        return RowObj.apply((CharSequence)Arrays.stream(columnIndices).mapToObj(i -> this.row.get(i).toString()).collect(Collectors.joining("\t")));
    }

    @Override
    public int sa(int i) {
        return IntStream.rangeClosed(0, i).map(k -> this.colAsString(k).length()).sum() + i;
    }

    @Override
    public void resize(int newsize) {
        this.row = RowFactory.create((Object[])IntStream.range(0, newsize).mapToObj(i -> this.row.get(i)).toArray(Object[]::new));
    }

    @Override
    public void setColumn(int k, String val) {
        Object[] objs = new Object[Math.max(this.row.length(), k + 3)];
        for (int i = 0; i < this.row.length(); ++i) {
            objs[i] = this.row.get(i);
        }
        objs[k + 2] = val;
        this.row = RowFactory.create((Object[])objs);
    }

    @Override
    public void addColumns(int num) {
    }

    @Override
    public void removeColumn(int n) {
        Stream<Object> rowstream = Stream.concat(IntStream.range(0, n).mapToObj(i -> this.row.get(i)), IntStream.range(n + 1, this.row.length()).mapToObj(i -> this.row.get(i)));
        this.row = RowFactory.create((Object[])rowstream.toArray(Object[]::new));
    }

    @Override
    public char peekAtColumn(int n) {
        return '\u0000';
    }

    @Override
    public void writeRow(Writer outputStream) {
    }

    @Override
    public void writeRowToStream(OutputStream outputStream) throws IOException {
        Object r;
        int i;
        for (i = 0; i < this.row.length() - 1; ++i) {
            r = this.row.get(i);
            if (r != null) {
                outputStream.write(r.toString().getBytes());
            }
            outputStream.write(9);
        }
        r = this.row.get(i);
        if (r != null) {
            outputStream.write(r.toString().getBytes());
        }
    }

    public void writeNorRowToStream(OutputStream outputStream) throws IOException {
        this.writeRowToStream(outputStream);
    }

    @Override
    public int length() {
        return this.row.length();
    }
}

