/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

public class JedisURIHelper {
    public static URI create(String uriStr) {
        if (uriStr == null || uriStr.length() == 0) {
            return null;
        }
        try {
            URI candURI = URI.create("redis://" + JedisURIHelper.stripSchema(uriStr));
            int db = JedisURIHelper.getDBIndex(candURI);
            return new URIBuilder().setScheme("redis").setHost(candURI.getHost()).setUserInfo(candURI.getUserInfo()).setPort(candURI.getPort() > 0 ? candURI.getPort() : 6379).setPath("/" + (db > -1 ? db : 0)).build();
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
    }

    public static URI create(String host, int port, int db) {
        if (host == null || host.length() == 0) {
            return null;
        }
        String uriStr = JedisURIHelper.stripSchema(host) + ":" + (port > 0 ? port : 6379) + "/" + (db > -1 ? db : 0);
        return JedisURIHelper.create(uriStr);
    }

    public static String getPassword(URI uri) {
        return redis.clients.jedis.util.JedisURIHelper.getPassword((URI)uri);
    }

    public static int getDBIndex(URI uri) {
        return redis.clients.jedis.util.JedisURIHelper.getDBIndex((URI)uri);
    }

    public static boolean isValid(URI uri) {
        return redis.clients.jedis.util.JedisURIHelper.isValid((URI)uri);
    }

    private static String stripSchema(String host) {
        return host.contains("://") ? host.substring(host.indexOf("://") + 3) : host;
    }
}

