/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import java.net.URI;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

class RetryConnectionJedisPool
extends JedisPool {
    private static final Logger log = LoggerFactory.getLogger(RetryConnectionJedisPool.class);

    RetryConnectionJedisPool(GenericObjectPoolConfig poolConfig, URI redisUri, int defaultTimeout, int socketTimeout) {
        super(poolConfig, redisUri, defaultTimeout, socketTimeout);
    }

    public Jedis getResource() {
        int numRetries = 0;
        while (numRetries <= 5) {
            try {
                Jedis jedis = super.getResource();
                return jedis;
            }
            catch (Exception e) {
                if (numRetries >= 5) {
                    throw e;
                }
                log.info("Got an exception {}, retrying connection in {} ms", (Object)e, (Object)(++numRetries * 500));
                try {
                    Thread.sleep(numRetries * 500);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        return null;
    }
}

