/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import java.net.URI;
import org.gorpipe.spark.platform.PoolProvider;
import org.gorpipe.spark.platform.RedisPool;
import org.gorpipe.spark.platform.StandardRedisPoolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public class SharedRedisPools {
    private static final Logger log = LoggerFactory.getLogger(SharedRedisPools.class);
    private static PoolProvider poolProvider;

    public static void setPoolProvider(PoolProvider provider) {
        poolProvider = provider;
    }

    public static PoolProvider getPoolProvider() {
        return poolProvider;
    }

    public static JedisPool getJedisPool(URI redisUri) {
        return poolProvider.getJedisPool(redisUri);
    }

    public static RedisPool getRedisPool(URI redisUri) {
        return poolProvider.getRedisPool(redisUri);
    }

    static {
        log.info("Setting standard redis pool provider");
        SharedRedisPools.setPoolProvider(new StandardRedisPoolProvider());
    }
}

