/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.gorpipe.spark.platform.JedisWrapperPool;
import org.gorpipe.spark.platform.PoolProvider;
import org.gorpipe.spark.platform.RedisPool;
import org.gorpipe.spark.platform.RetryConnectionJedisPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public class StandardRedisPoolProvider
implements PoolProvider {
    private static final int DEFAULT_TIMEOUT_MS = 30000;
    private static final int SOCKET_TIMEOUT_MS = 5000;
    private static final Logger log = LoggerFactory.getLogger(StandardRedisPoolProvider.class);
    private final ConcurrentHashMap<URI, JedisPool> pools = new ConcurrentHashMap();

    private JedisPool createPool(URI redisUri) {
        log.info("Creating Shared Jedis Pool for '{}'", (Object)redisUri);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(1024);
        poolConfig.setMaxIdle(256);
        poolConfig.setMinIdle(128);
        poolConfig.setBlockWhenExhausted(true);
        poolConfig.setMaxWaitMillis(120000L);
        poolConfig.setTimeBetweenEvictionRunsMillis(30000L);
        poolConfig.setMinEvictableIdleTimeMillis(120000L);
        poolConfig.setTestOnBorrow(true);
        return new RetryConnectionJedisPool(poolConfig, redisUri, 30000, 5000);
    }

    @Override
    public JedisPool getJedisPool(URI redisUri) {
        return this.pools.computeIfAbsent(redisUri, this::createPool);
    }

    @Override
    public RedisPool getRedisPool(URI redisUri) {
        return new JedisWrapperPool(this.getJedisPool(redisUri));
    }
}

