/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gorpipe.spark.platform.JedisPipelineWrapper;
import org.gorpipe.spark.platform.JedisTransactionWrapper;
import org.gorpipe.spark.platform.Redis;
import org.gorpipe.spark.platform.RedisPipeline;
import org.gorpipe.spark.platform.RedisTransaction;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;

public class JedisWrapper
implements Redis,
Closeable {
    private Jedis jedis;

    JedisWrapper(Jedis jedis) {
        this.jedis = jedis;
    }

    @Override
    public String get(String key) {
        return this.jedis.get(key);
    }

    @Override
    public String getSet(String key, String value) {
        return this.jedis.getSet(key, value);
    }

    @Override
    public String set(String key, String value) {
        return this.jedis.set(key, value);
    }

    @Override
    public Long setnx(String key, String value) {
        return this.jedis.setnx(key, value);
    }

    @Override
    public Long del(String ... keys) {
        return this.jedis.del(keys);
    }

    @Override
    public Long incr(String key) {
        return this.jedis.incr(key);
    }

    @Override
    public String hget(String key, String field) {
        return this.jedis.hget(key, field);
    }

    @Override
    public Long hset(String key, String field, String value) {
        return this.jedis.hset(key, field, value);
    }

    @Override
    public Long expire(String key, int seconds) {
        return this.jedis.expire(key, seconds);
    }

    @Override
    public Long publish(String channel, String message) {
        return this.jedis.publish(channel, message);
    }

    @Override
    public boolean exists(String key) {
        return this.jedis.exists(key);
    }

    @Override
    public void close() {
        this.jedis.close();
    }

    @Override
    public Long zadd(String key, double score, String val) {
        return this.jedis.zadd(key, score, val);
    }

    @Override
    public Long zrem(String key, String ... members) {
        return this.jedis.zrem(key, members);
    }

    @Override
    public Long hdel(String key, String ... fields) {
        return this.jedis.hdel(key, fields);
    }

    @Override
    public Long zcard(String key) {
        return this.jedis.zcard(key);
    }

    @Override
    public boolean hexists(String key, String field) {
        return this.jedis.hexists(key, field);
    }

    @Override
    public Set<String> zrange(String key, long start, long stop) {
        return this.jedis.zrange(key, start, stop);
    }

    @Override
    public Long incrBy(String key, long value) {
        return this.jedis.incrBy(key, value);
    }

    @Override
    public Long decrBy(String key, long value) {
        return this.jedis.decrBy(key, value);
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        return this.jedis.hincrBy(key, field, value);
    }

    @Override
    public Map<String, String> hgetall(String key) {
        return this.jedis.hgetAll(key);
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        return this.jedis.hmget(key, fields);
    }

    @Override
    public void hmset(String key, Map<String, String> data) {
        this.jedis.hmset(key, data);
    }

    @Override
    public Set<String> keys(String pat) {
        return this.jedis.keys(pat);
    }

    @Override
    public RedisTransaction multi() {
        Transaction trans = this.jedis.multi();
        return new JedisTransactionWrapper(trans);
    }

    @Override
    public RedisPipeline pipelined() {
        return new JedisPipelineWrapper(this.jedis, this.jedis.pipelined());
    }

    @Override
    public String ping() {
        return this.jedis.ping();
    }
}

