/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.Commands.Analysis;
import gorsat.Commands.CommandParseUtilities;
import gorsat.DynIterator;
import gorsat.RowBuffer;
import gorsat.commands.PysparkAnalysis;
import gorsat.process.FilterParams;
import gorsat.process.GorMapFunction;
import gorsat.process.GorSpark;
import gorsat.process.GorSparkExternalFunction;
import gorsat.process.GorSparkMaterialize;
import gorsat.process.NorMapFunction;
import gorsat.process.ProcessRowSource;
import gorsat.process.ProcessSource;
import gorsat.process.SparkRowUtilities;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import io.projectglow.Glow;
import io.projectglow.transformers.blockvariantsandsamples.VariantSampleBlockMaker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.DataFormatException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.api.java.function.ReduceFunction;
import org.apache.spark.ml.feature.Normalizer;
import org.apache.spark.ml.feature.PCA;
import org.apache.spark.ml.feature.PCAModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.gor.driver.DataSource;
import org.gorpipe.gor.driver.providers.stream.datatypes.bam.BamIterator;
import org.gorpipe.gor.model.ChrDataScheme;
import org.gorpipe.gor.model.ChromoCache;
import org.gorpipe.gor.model.ChromoLookup;
import org.gorpipe.gor.model.DriverBackedFileReader;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.VcfGzGenomicIterator;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.spark.GorFilterFunction;
import org.gorpipe.spark.GorSparkRow;
import org.gorpipe.spark.GorSparkRowInferFunction;
import org.gorpipe.spark.GorSparkSession;
import org.gorpipe.spark.GorpipeRDD;
import org.gorpipe.spark.LongGorSparkRow;
import org.gorpipe.spark.NorFilterFunction;
import org.gorpipe.spark.RowDataType;
import org.gorpipe.spark.SparkGOR;
import org.gorpipe.spark.SparkRow;
import org.gorpipe.spark.udfs.CharToDoubleArray;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkRowSource
extends ProcessSource {
    String sql;
    String errorStr;
    List<String> commands;
    String type;
    boolean isGorRow;
    Dataset<? extends Row> dataset;
    Iterator<org.gorpipe.gor.model.Row> it;
    boolean nor;
    ProcessBuilder pb;
    Process p;
    Path fileroot;
    Path cachepath;
    String parquetPath;
    String dictPath;
    int pcacomponents;
    String pushdownGorPipe;
    GorSparkSession gorSparkSession;
    Map<DataType, String> dmap;
    Map<String, DataType> dsmap;
    String chr;
    int start;
    int end;
    String jobId;
    Integer buckets;
    String parts;
    boolean tag;
    List<PysparkAnalysis> pysparkAnalyses;
    Function<String, String> inner;
    Function<String, String> gorfunc;
    Predicate<String> gorpred;
    Function<String, String> parqfunc;
    Function<String, Stream<String>> gorfileflat;
    static Map<String, DataType> tmap = new HashMap<String, DataType>();
    private RowBuffer rowBuffer;
    int linesRead;

    public void init() {
        this.dmap.put(DataTypes.StringType, "S");
        this.dmap.put(DataTypes.IntegerType, "I");
        this.dmap.put(DataTypes.DoubleType, "D");
        this.dsmap.put("String", DataTypes.StringType);
        this.dsmap.put("Integer", DataTypes.IntegerType);
        this.dsmap.put("Int", DataTypes.IntegerType);
        this.dsmap.put("Double", DataTypes.DoubleType);
    }

    public boolean isNor() {
        return this.nor;
    }

    private void initFileRoot(GorSession gpSession) {
        String root = gpSession.getProjectContext().getRoot();
        String cachedir = gpSession.getProjectContext().getCacheDir();
        if (root != null && root.length() > 0) {
            int i = root.indexOf(32);
            if (i == -1) {
                i = root.length();
            }
            this.fileroot = Paths.get(root.substring(0, i), new String[0]);
            this.cachepath = Paths.get(cachedir != null && cachedir.length() > 0 ? cachedir : "result_cache", new String[0]);
            if (!this.cachepath.isAbsolute()) {
                this.cachepath = this.fileroot.resolve(this.cachepath);
            }
        }
    }

    public SparkRowSource(String sql, String profile, String parquet, String type, boolean nor, GorSparkSession gpSession, String filter, String filterFile, String filterColumn, String splitFile, String chr, int pos, int end, boolean usestreaming, String jobId, boolean useCpp, String parts, int buckets, boolean tag, String ddl, String format, String option) throws IOException, DataFormatException {
        this.errorStr = "";
        this.isGorRow = false;
        this.fileroot = null;
        this.cachepath = null;
        this.parquetPath = null;
        this.dictPath = null;
        this.pcacomponents = 10;
        this.pushdownGorPipe = null;
        this.dmap = new HashMap<DataType, String>();
        this.dsmap = new HashMap<String, DataType>();
        this.jobId = "-1";
        this.pysparkAnalyses = new ArrayList<PysparkAnalysis>();
        this.rowBuffer = null;
        this.linesRead = 0;
        this.init();
        this.sql = sql;
        this.jobId = jobId;
        this.tag = tag;
        this.buckets = buckets != -1 ? Integer.valueOf(buckets) : null;
        this.parts = parts;
        this.gorSparkSession = gpSession;
        this.nor = nor;
        if (parquet != null && Files.exists(Paths.get(parquet, new String[0]), new LinkOption[0])) {
            this.dataset = gpSession.getSparkSession().read().parquet(parquet);
        } else if (format != null) {
            this.initFileRoot(gpSession);
            DataFrameReader dataFrameReader = gpSession.getSparkSession().read().format(format);
            HashSet<String> options = new HashSet<String>();
            if (option != null) {
                if (option.startsWith("'")) {
                    option = option.substring(1, option.length() - 1);
                }
                for (String split : option.split(";")) {
                    String splittrim = split.trim();
                    int ie = splittrim.indexOf(61);
                    String key = splittrim.substring(0, ie);
                    String val = splittrim.substring(ie + 1);
                    options.add(key);
                    dataFrameReader = dataFrameReader.option(key, val);
                }
            }
            if (ddl != null) {
                StructType schema = StructType.fromDDL((String)ddl);
                dataFrameReader = dataFrameReader.schema(schema);
            }
            if (format.equals("jdbc")) {
                this.dataset = sql.toLowerCase().startsWith("select ") ? dataFrameReader.option("query", sql).load() : dataFrameReader.option("dbtable", sql).load();
            } else if (format.contains("redis")) {
                String sqlow = sql.toLowerCase();
                if (sqlow.startsWith("select ")) {
                    int i = sqlow.indexOf(" from ") + 6;
                    String table = sql.substring(i, sql.indexOf(32, i)).trim();
                    String sqlhash = "g" + sql.hashCode();
                    sql = sql.replace(" from " + table, " from " + sqlhash);
                    dataFrameReader.option("table", table).load().createOrReplaceTempView(sqlhash);
                    this.dataset = this.gorSparkSession.getSparkSession().sql(sql);
                } else {
                    this.dataset = sql.equals("dummy") || options.contains("table") ? dataFrameReader.load() : dataFrameReader.option("table", sql).load();
                }
            } else {
                this.dataset = sql.toLowerCase().startsWith("select ") ? dataFrameReader.load() : dataFrameReader.load(sql);
            }
        } else {
            this.type = type;
            this.commands = new ArrayList<String>();
            this.chr = chr;
            this.start = pos;
            this.end = end;
            this.initFileRoot(gpSession);
            String[] cmdsplit = CommandParseUtilities.quoteCurlyBracketsSafeSplit((String)sql, (char)' ');
            this.commands.addAll(Arrays.asList(cmdsplit));
            boolean bamvcf = type != null && (type.equals("bam") || type.equals("sam") || type.equals("cram") || type.equals("vcf"));
            List<String> headercommands = bamvcf ? this.seekCmd(null, 0, -1) : this.seekCmd(chr, this.start, end);
            String standalone = System.getProperty("sm.standalone");
            this.inner = p -> {
                if (p.startsWith("(")) {
                    String[] cmdspl = CommandParseUtilities.quoteCurlyBracketsSafeSplit((String)p.substring(1, p.length() - 1), (char)' ');
                    return Arrays.stream(cmdspl).map(this.inner).map(this.gorfunc).map(this.parqfunc).collect(Collectors.joining(" ", "(", ")"));
                }
                return p;
            };
            this.gorpred = SparkRowUtilities.getFileEndingPredicate();
            this.gorfunc = p -> {
                if (this.gorpred.test((String)p)) {
                    List<Instant> inst;
                    String fileName;
                    boolean nestedQuery = p.startsWith("<(");
                    if (nestedQuery) {
                        fileName = p.substring(2, p.length() - 1);
                        String[] scmdsplit = CommandParseUtilities.quoteCurlyBracketsSafeSplit((String)fileName, (char)' ');
                        inst = Arrays.stream(scmdsplit).flatMap(this.gorfileflat).filter(this.gorpred).map(x$0 -> Paths.get(x$0, new String[0])).map(sp -> sp.isAbsolute() ? sp : this.fileroot.resolve((Path)sp)).map(sp -> {
                            try {
                                return Files.getLastModifiedTime(sp, new LinkOption[0]).toInstant();
                            }
                            catch (IOException e) {
                                return null;
                            }
                        }).filter(Objects::nonNull).collect(Collectors.toList());
                    } else {
                        RowDataType rdt = SparkRowUtilities.translatePath(p, this.fileroot, standalone);
                        fileName = rdt.path;
                        inst = rdt.getTimestamp();
                    }
                    return SparkRowUtilities.generateTempViewName(fileName, usestreaming, filter, chr, pos, end, inst);
                }
                return p;
            };
            this.gorfileflat = p -> p.startsWith("(") ? Arrays.stream(CommandParseUtilities.quoteCurlyBracketsSafeSplit((String)p.substring(1, p.length() - 1), (char)' ')).flatMap(this.gorfileflat).filter(this.gorpred) : Stream.of(p);
            this.parqfunc = p -> {
                if (p.toLowerCase().endsWith(".parquet") && !p.toLowerCase().startsWith("parquet.")) {
                    String fileName = SparkRowUtilities.translatePath((String)p, (Path)this.fileroot, (String)standalone).path;
                    return "parquet.`" + fileName + "`";
                }
                return p;
            };
            boolean isSql = headercommands.get(0).equalsIgnoreCase("select");
            String cacheFile = null;
            if (isSql) {
                String[] fileNames;
                sql = headercommands.stream().filter(p -> p.length() > 0).map(this.inner).map(this.gorfunc).map(this.parqfunc).collect(Collectors.joining(" "));
                for (String fn : fileNames = (String[])Arrays.stream(cmdsplit).flatMap(this.gorfileflat).filter(this.gorpred).toArray(String[]::new)) {
                    if (this.gorSparkSession.getSystemContext().getServer()) {
                        ProjectContext.validateServerFileName((String)fn, (String)this.fileroot.toString(), (boolean)true);
                    }
                    StructType schema = ddl != null ? StructType.fromDDL((String)ddl) : null;
                    SparkRowUtilities.registerFile(new String[]{fn}, profile, null, gpSession, standalone, this.fileroot, this.cachepath, usestreaming, filter, filterFile, filterColumn, splitFile, nor, chr, pos, end, jobId, cacheFile, useCpp, tag, schema);
                }
                this.dataset = this.gorSparkSession.getSparkSession().sql(sql);
            } else {
                String[] fileNames = headercommands.toArray(new String[0]);
                StructType schema = ddl != null ? StructType.fromDDL((String)ddl) : null;
                this.dataset = SparkRowUtilities.registerFile(fileNames, null, profile, gpSession, standalone, this.fileroot, this.cachepath, usestreaming, filter, filterFile, filterColumn, splitFile, nor, chr, pos, end, jobId, cacheFile, useCpp, tag, schema);
            }
            if (chr != null) {
                this.dataset = end != -1 ? this.dataset.filter((FilterFunction & Serializable)row -> chr.equals(row.getString(0)) && row.getInt(1) <= end && row.getInt(1) >= pos) : this.dataset.filter((FilterFunction & Serializable)row -> chr.equals(row.getString(0)) && row.getInt(1) >= pos);
            }
            this.gorSparkSession.getSparkSession().sparkContext().setJobGroup("a|b|gorsql|c", sql, true);
        }
        boolean checknor = SparkRowSource.checkNor(this.dataset.schema().fields());
        this.setHeader((nor || checknor ? "chrNOR\tposNOR\t" : "") + this.correctHeader(this.dataset.columns()));
    }

    public Dataset<? extends Row> getDataset() {
        return this.dataset;
    }

    private String correctHeader(String[] header) {
        return String.join((CharSequence)"\t", header);
    }

    public void gorpipe(Analysis pipeStep, boolean gor) {
        RDD rdd = this.dataset.rdd();
        ExpressionEncoder encoder = this.dataset.exprEnc();
        GorpipeRDD gorpipeRDD = new GorpipeRDD(rdd, pipeStep, encoder, this.getHeader(), gor, rdd.elementClassTag());
        this.dataset = this.gorSparkSession.getSparkSession().createDataset(gorpipeRDD, (Encoder)encoder);
        this.setHeader(this.correctHeader(this.dataset.columns()));
    }

    public static Dataset<org.gorpipe.gor.model.Row> gorpipe(Dataset<? extends Row> dataset, String gor) {
        String inputHeader = String.join((CharSequence)"\t", dataset.schema().fieldNames());
        boolean nor = SparkRowSource.checkNor(dataset.schema().fields());
        Dataset<? extends Row> dr = dataset;
        GorSpark gs = new GorSparkMaterialize(inputHeader, nor, SparkGOR.sparkrowEncoder().schema(), gor, null, null, "-1", 100);
        GorSparkRowInferFunction gi = new GorSparkRowInferFunction();
        org.gorpipe.gor.model.Row row = (org.gorpipe.gor.model.Row)dr.mapPartitions((MapPartitionsFunction)gs, SparkGOR.gorrowEncoder()).limit(100).reduce((ReduceFunction)gi);
        if (row.chr != null) {
            row = gi.infer(row, row);
        }
        StructType schema = SparkRowSource.schemaFromRow(gs.query().getHeader().split("\t"), row);
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
        gs = new GorSpark(inputHeader, nor, schema, gor, null, null, "-1");
        return dr.mapPartitions((MapPartitionsFunction)gs, (Encoder)encoder);
    }

    public void gor() {
        String inputHeader = super.getHeader();
        boolean nor = SparkRowSource.checkNor(this.dataset.schema().fields());
        Dataset<? extends org.gorpipe.gor.model.Row> dr = this.checkRowFormat(this.dataset);
        String uri = this.gorSparkSession.getRedisUri();
        GorSpark gs = new GorSparkMaterialize(inputHeader, nor, SparkGOR.sparkrowEncoder().schema(), this.pushdownGorPipe, this.gorSparkSession.getProjectContext().getRoot(), uri, this.jobId, 100);
        GorSparkRowInferFunction gi = new GorSparkRowInferFunction();
        org.gorpipe.gor.model.Row row = (org.gorpipe.gor.model.Row)dr.mapPartitions((MapPartitionsFunction)gs, SparkGOR.gorrowEncoder()).limit(100).reduce((ReduceFunction)gi);
        if (row.chr != null) {
            row = gi.infer(row, row);
        }
        StructType schema = SparkRowSource.schemaFromRow(gs.query().getHeader().split("\t"), row);
        this.setHeader(this.correctHeader(schema.fieldNames()));
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
        gs = new GorSpark(inputHeader, nor, schema, this.pushdownGorPipe, this.gorSparkSession.getProjectContext().getRoot(), uri, this.jobId);
        this.pushdownGorPipe = null;
        this.dataset = dr.mapPartitions((MapPartitionsFunction)gs, (Encoder)encoder);
        nor = SparkRowSource.checkNor(this.dataset.schema().fields());
        this.setHeader((nor ? "chrNOR\tposNOR\t" : "") + this.correctHeader(this.dataset.columns()));
    }

    public static StructType schemaFromRow(String[] header, org.gorpipe.gor.model.Row row) {
        return new StructType((StructField[])IntStream.range(0, row.numCols()).mapToObj(i -> new StructField(header[i], tmap.get(row.stringValue(i)), true, Metadata.empty())).toArray(StructField[]::new));
    }

    public String checkNested(String cmd, GorSession gpSession, String[] errorStr) {
        String ncmd;
        if (cmd.startsWith("<(")) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir == null || tmpdir.length() == 0) {
                tmpdir = "/tmp";
            }
            Path tmpath = Paths.get(tmpdir, new String[0]);
            String scmd = cmd.substring(2, cmd.length() - 1);
            Path fifopath = tmpath.resolve(Integer.toString(Math.abs(scmd.hashCode())));
            String pipename = fifopath.toAbsolutePath().toString();
            DynIterator.DynamicRowSource drs = new DynIterator.DynamicRowSource(scmd, gpSession.getGorContext(), false);
            try {
                if (!Files.exists(fifopath, new LinkOption[0])) {
                    ProcessBuilder mkfifo = new ProcessBuilder("mkfifo", pipename);
                    Process p = mkfifo.start();
                    p.waitFor();
                }
                Thread t = new Thread(() -> {
                    try (OutputStream os = Files.newOutputStream(fifopath, new OpenOption[0]);){
                        os.write(String.join((CharSequence)"\t", drs.getHeader()).getBytes());
                        os.write(10);
                        while (drs.hasNext()) {
                            String rowstr = drs.next().toString();
                            os.write(rowstr.getBytes());
                            os.write(10);
                        }
                    }
                    catch (IOException e) {
                        errorStr[0] = errorStr[0] + e.getMessage();
                    }
                    finally {
                        try {
                            Files.delete(fifopath);
                        }
                        catch (IOException iOException) {}
                    }
                });
                t.start();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed starting fifo thread", e);
            }
            ncmd = pipename;
        } else {
            boolean quotas = cmd.startsWith("'") || cmd.startsWith("\"");
            String string = ncmd = quotas ? cmd.substring(1, cmd.length() - 1) : cmd;
            if (quotas) {
                ncmd = ncmd.replace("\\t", "\t").replace("\\n", "\n");
            }
        }
        return ncmd;
    }

    public SparkRowSource(String[] cmds, String type, boolean nor, GorSession gpSession, String chr, int pos, int end, int bs) {
        block15: {
            String root;
            this.errorStr = "";
            this.isGorRow = false;
            this.fileroot = null;
            this.cachepath = null;
            this.parquetPath = null;
            this.dictPath = null;
            this.pcacomponents = 10;
            this.pushdownGorPipe = null;
            this.dmap = new HashMap<DataType, String>();
            this.dsmap = new HashMap<String, DataType>();
            this.jobId = "-1";
            this.pysparkAnalyses = new ArrayList<PysparkAnalysis>();
            this.rowBuffer = null;
            this.linesRead = 0;
            this.type = type;
            this.nor = nor;
            this.setBufferSize(bs);
            this.commands = new ArrayList<String>();
            this.chr = chr;
            this.start = pos;
            this.end = end;
            if (gpSession != null && (root = gpSession.getProjectContext().getRoot()) != null && root.length() > 0) {
                int i = root.indexOf(32);
                if (i == -1) {
                    i = root.length();
                }
                this.fileroot = Paths.get(root.substring(0, i), new String[0]);
            }
            String[] estr = new String[]{this.errorStr};
            for (String cmd : cmds) {
                String ncmd = this.checkNested(cmd, gpSession, estr);
                this.commands.add(ncmd);
            }
            boolean bamvcf = type != null && (type.equals("bam") || type.equals("sam") || type.equals("cram") || type.equals("vcf"));
            List<String> headercommands = bamvcf ? this.seekCmd(null, 0, -1) : this.seekCmd(chr, this.start, end);
            try {
                List<String> rcmd = headercommands.stream().filter(p -> p.length() > 0).collect(Collectors.toList());
                this.pb = new ProcessBuilder(rcmd);
                if (this.fileroot != null) {
                    this.pb.directory(this.fileroot.toFile());
                }
                this.p = this.pb.start();
                Thread errorThread = new Thread(() -> {
                    try {
                        StringBuilder total = new StringBuilder();
                        InputStream es = this.p.getErrorStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(es));
                        String line = br.readLine();
                        while (line != null) {
                            total.append(line).append("\n");
                            line = br.readLine();
                        }
                        this.errorStr = this.errorStr + total.toString();
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                errorThread.start();
                InputStream is = this.p.getInputStream();
                if (type == null || type.equalsIgnoreCase("gor")) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    this.setHeader(br.readLine());
                    if (this.getHeader() == null) {
                        throw new RuntimeException("Running external process: " + String.join((CharSequence)" ", headercommands) + " with error: " + this.errorStr);
                    }
                    if (nor) {
                        this.setHeader("ChromNOR\tPosNOR\t" + this.getHeader().replace(" ", "_").replace(":", ""));
                    }
                    break block15;
                }
                if (type.equalsIgnoreCase("vcf")) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    final ChromoLookup lookup = ProcessRowSource.createChromoLookup();
                    try {
                        this.it = new VcfGzGenomicIterator(lookup, "filename", br){

                            public boolean seek(String seekChr, int seekPos) {
                                return this.seek(seekChr, seekPos, lookup.chrToLen(seekChr));
                            }

                            public boolean seek(String seekChr, int seekPos, int endPos) {
                                try {
                                    this.reader.close();
                                    if (seekChr != null && this.chrNameSystem != VcfGzGenomicIterator.ChrNameSystem.WITH_CHR_PREFIX) {
                                        seekChr = seekChr.substring(3);
                                    }
                                    InputStream is1 = SparkRowSource.this.setRange(seekChr, seekPos, endPos);
                                    this.reader = new BufferedReader(new InputStreamReader(is1));
                                    this.next = this.reader.readLine();
                                    while (this.next != null && this.next.startsWith("#")) {
                                        this.next = this.reader.readLine();
                                    }
                                }
                                catch (IOException e) {
                                    throw new RuntimeException("Error reading next line from external process providing vcf stream", e);
                                }
                                return true;
                            }

                            public void close() {
                                super.close();
                            }
                        };
                        break block15;
                    }
                    catch (Exception e) {
                        int exitValue = 0;
                        try {
                            exitValue = this.p.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        throw new RuntimeException("Error initializing vcf reader. Exit value from process: " + exitValue + ". Error from process: " + this.errorStr, e);
                    }
                }
                if (type.equalsIgnoreCase("bam") || type.equalsIgnoreCase("sam") || type.equalsIgnoreCase("cram")) {
                    final ChromoLookup lookup = ProcessRowSource.createChromoLookup();
                    final SamReaderFactory srf = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT);
                    SamInputResource sir = SamInputResource.of((InputStream)is);
                    SamReader samreader = srf.open(sir);
                    BamIterator bamit = new BamIterator(){

                        public boolean seek(String chr, int pos) {
                            return this.seek(chr, pos);
                        }

                        public boolean seek(String chr, int pos, int end) {
                            int chrId = lookup.chrToId(chr);
                            if (this.chrnamesystem == 1) {
                                chr = ChromoCache.getHgName((int)chrId);
                            } else if (this.chrnamesystem == 2) {
                                chr = ChromoCache.getStdChrName((int)chrId);
                            }
                            try {
                                this.reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            InputStream nis = SparkRowSource.this.setRange(chr, pos, end);
                            SamInputResource sir = SamInputResource.of((InputStream)nis);
                            this.reader = srf.open(sir);
                            this.it = this.reader.iterator();
                            this.pos = pos;
                            return true;
                        }

                        public boolean hasNext() {
                            SAMRecord samRecord;
                            this.initIterator();
                            boolean hasNext = this.it.hasNext();
                            while (hasNext && (samRecord = (SAMRecord)this.it.next()) != null && (samRecord.getReadUnmappedFlag() || "*".equals(samRecord.getCigarString()) || samRecord.getStart() < this.pos)) {
                                hasNext = this.it.hasNext();
                            }
                            if (!hasNext && this.hgSeekIndex >= 0) {
                                while (++this.hgSeekIndex < ChrDataScheme.ChrLexico.getOrder2id().length) {
                                    String name = this.getChromName();
                                    if (this.samFileHeader.getSequenceIndex(name) <= -1) continue;
                                    this.createIterator(name, 0);
                                    return this.hasNext();
                                }
                            }
                            return hasNext;
                        }

                        public void createIterator(String chr, int pos) {
                            if (this.it == null) {
                                this.it = this.reader.iterator();
                            }
                        }
                    };
                    bamit.init(lookup, samreader, false);
                    bamit.it = bamit.reader.iterator();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("unable to get header from process " + this.commands.get(0), e);
            }
        }
    }

    public static boolean checkNor(StructField[] fields) {
        return fields.length == 1 || !fields[0].name().equalsIgnoreCase("chrom") || fields[1].dataType() != DataTypes.IntegerType;
    }

    void writeDictionary(org.apache.hadoop.fs.Path resolvedPath, org.apache.hadoop.fs.Path dictPath) throws IOException {
        Dataset ds = this.gorSparkSession.getSparkSession().read().format("csv").load(resolvedPath + "/*.meta").withColumn("inputFile", functions.input_file_name());
        Dataset dss = ds.selectExpr(new String[]{"inputFile", "_c0 as meta"}).where("meta like '## RANGE%'").map((MapFunction & Serializable)r -> {
            String first = r.getString(0);
            int l = first.lastIndexOf(47);
            String name = first.substring(l + 1);
            if (first.startsWith("file:")) {
                first = name;
                l = -1;
            }
            return first.substring(0, first.length() - 5) + "\t" + first.substring(l + 6, l + 11) + "\t" + r.getString(1).substring(10);
        }, Encoders.STRING()).coalesce(1);
        List lss = dss.collectAsList();
        Configuration conf = new Configuration();
        FileSystem fs = dictPath.getFileSystem(conf);
        if (fs.getFileStatus(dictPath).isDirectory()) {
            dictPath = new org.apache.hadoop.fs.Path(dictPath, "dict.gord");
        }
        FSDataOutputStream is = fs.create(dictPath);
        for (String l : lss) {
            is.writeBytes(l);
            is.write(10);
        }
        is.close();
    }

    private Dataset<Row> gttranspose(Dataset<Row> ds) {
        int varcount = (Integer)ds.mapPartitions((MapPartitionsFunction & Serializable)ir -> {
            Iterable newIterable = () -> ir;
            int count = (int)StreamSupport.stream(newIterable.spliterator(), false).count();
            return Collections.singletonList(count).iterator();
        }, Encoders.INT()).first();
        StructType schema = new StructType();
        if (ds.schema().length() > 1) {
            schema = schema.add("pn", DataTypes.StringType);
        }
        schema = schema.add("values", (DataType)new VectorUDT());
        int schemaLen = ds.schema().length();
        ExpressionEncoder vectorEncoder = RowEncoder.apply((StructType)schema);
        Dataset dv = ds.mapPartitions((MapPartitionsFunction & Serializable)ir -> {
            double[][] mat = null;
            Iterator it = Collections.emptyIterator();
            String[] pns = null;
            int start = 0;
            while (ir.hasNext()) {
                int i;
                String strvec;
                Row row = (Row)ir.next();
                if (schemaLen > 1) {
                    pns = row.getString(0).split(",");
                    strvec = row.getString(1).substring(1);
                } else {
                    strvec = row.getString(0).substring(1);
                }
                int len = strvec.length();
                if (mat == null) {
                    mat = new double[len][];
                    for (i = 0; i < len; ++i) {
                        mat[i] = new double[varcount];
                    }
                }
                for (i = 0; i < len; ++i) {
                    mat[i][start] = strvec.charAt(i) - 48;
                }
                ++start;
            }
            if (mat != null) {
                ArrayList<Row> lv = new ArrayList<Row>(mat.length);
                for (int i = 0; i < mat.length; ++i) {
                    Vector vector = Vectors.dense((double[])mat[i]);
                    Row row = pns != null ? RowFactory.create((Object[])new Object[]{pns[i], vector}) : RowFactory.create((Object[])new Object[]{vector});
                    lv.add(row);
                }
                return lv.stream().iterator();
            }
            return it;
        }, (Encoder)vectorEncoder);
        return dv;
    }

    public boolean hasNext() {
        if (this.it == null) {
            if (this.parquetPath != null) {
                block16: {
                    try {
                        boolean gorformat;
                        String resolvedPath;
                        boolean exists;
                        FileReader fileReader = this.gorSparkSession.getProjectContext().getFileReader();
                        if (fileReader instanceof DriverBackedFileReader) {
                            DriverBackedFileReader driverBackedFileReader = (DriverBackedFileReader)fileReader;
                            DataSource ds = driverBackedFileReader.resolveUrl(this.parquetPath);
                            exists = ds.exists();
                            URI uri = URI.create(ds.getSourceReference().getUrl());
                            resolvedPath = !uri.isAbsolute() && this.fileroot != null ? this.fileroot.resolve(this.parquetPath).toAbsolutePath().normalize().toString() : ds.getSourceReference().getUrl();
                        } else {
                            Path pPath = Paths.get(this.parquetPath, new String[0]);
                            if (this.fileroot != null && !pPath.isAbsolute()) {
                                pPath = this.fileroot.resolve(pPath);
                            }
                            exists = Files.exists(pPath, new LinkOption[0]);
                            resolvedPath = pPath.toAbsolutePath().normalize().toString();
                        }
                        if (exists) break block16;
                        if (this.parquetPath.endsWith(".pca")) {
                            PCA pca = new PCA();
                            pca.setK(this.pcacomponents);
                            pca.setOutputCol("pca");
                            pca.setInputCol("values");
                            PCAModel pcamodel = pca.fit(this.dataset);
                            try {
                                pcamodel.save(this.parquetPath);
                                break block16;
                            }
                            catch (IOException e) {
                                throw new GorResourceException("Unable to save pcamodel file", this.parquetPath, (Throwable)e);
                            }
                        }
                        Arrays.stream(this.dataset.columns()).filter(c -> c.contains("(")).forEach(c -> {
                            this.dataset = this.dataset.withColumnRenamed(c, c.replace('(', '_').replace(')', '_'));
                        });
                        DataFrameWriter dfw = this.dataset.write();
                        if (this.parts != null) {
                            dfw = this.buckets != null ? dfw.bucketBy(this.buckets.intValue(), this.parts, new String[0]) : dfw.partitionBy(this.parts.split(","));
                        }
                        dfw = (gorformat = this.parquetPath.toLowerCase().endsWith(".gorz")) ? dfw.format("gor") : dfw.format("parquet");
                        dfw.mode(SaveMode.Overwrite).save(resolvedPath);
                        if (gorformat) {
                            org.apache.hadoop.fs.Path hp = new org.apache.hadoop.fs.Path(resolvedPath);
                            if (this.parquetPath.equals(this.dictPath)) {
                                this.writeDictionary(hp, hp);
                            } else {
                                Path dPath = Paths.get(this.dictPath, new String[0]);
                                if (this.fileroot != null && !dPath.isAbsolute()) {
                                    dPath = this.fileroot.resolve(dPath);
                                }
                                String dictPathStr = dPath.toAbsolutePath().normalize().toString();
                                org.apache.hadoop.fs.Path dp = new org.apache.hadoop.fs.Path(dictPathStr);
                                this.writeDictionary(hp, dp);
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new GorResourceException("Unable to get datasource", this.parquetPath, (Throwable)e);
                    }
                }
                return false;
            }
            Iterable iterable = () -> this.dataset.toLocalIterator();
            boolean lng = false;
            if (this.dataset != null) {
                StructField[] fields = this.dataset.schema().fields();
                lng = fields.length > 1 && fields[1].dataType() == DataTypes.LongType;
                this.nor |= SparkRowSource.checkNor(fields);
            }
            this.it = (this.nor ? StreamSupport.stream(iterable.spliterator(), false).map(r -> new SparkRow((Row)r)) : (lng ? StreamSupport.stream(iterable.spliterator(), false).map(r -> new LongGorSparkRow((Row)r)) : StreamSupport.stream(iterable.spliterator(), false).map(r -> new GorSparkRow((Row)r)))).iterator();
        }
        return this.it.hasNext();
    }

    public org.gorpipe.gor.model.Row next() {
        ++this.linesRead;
        return this.it.next();
    }

    public boolean seek(String seekChr, int seekPos) {
        return true;
    }

    public void close() {
        this.pysparkAnalyses.forEach(PysparkAnalysis::close);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> seekCmd(String seekChr, int startPos, int endPos) {
        ArrayList<String> seekcmd = new ArrayList<String>();
        for (String string : this.commands) {
            void var6_6;
            int sEnd;
            int sPos;
            int hEnd;
            int hPos;
            if (seekChr == null) {
                void var6_9;
                hPos = string.indexOf("#(H:");
                if (hPos != -1) {
                    hEnd = string.indexOf(41, hPos + 1);
                    String string2 = string.substring(0, hPos) + string.substring(hPos + 4, hEnd) + string.substring(hEnd + 1);
                }
                if ((sPos = var6_9.indexOf("#(S:")) != -1) {
                    sEnd = var6_9.indexOf(41, sPos + 1);
                    String string3 = var6_9.substring(0, sPos) + var6_9.substring(sEnd + 1);
                }
            } else {
                void var6_13;
                hPos = string.indexOf("#(H:");
                if (hPos != -1) {
                    hEnd = string.indexOf(41, hPos + 1);
                    String string4 = string.substring(0, hPos) + string.substring(hEnd + 1);
                }
                if ((sPos = var6_13.indexOf("#(S:")) != -1) {
                    int pos;
                    sEnd = var6_13.indexOf(41, sPos + 1);
                    String seek = "";
                    seek = var6_13.substring(sPos + 4, sEnd).replace("chr", seekChr);
                    if (seekChr.startsWith("chr")) {
                        seek = seek.replace("chn", seekChr.substring(3));
                    }
                    if ((pos = seek.indexOf("pos-end")) != -1) {
                        if (endPos == -1) {
                            int len = Integer.MAX_VALUE;
                            seek = seek.replace("pos", "" + (startPos + 1)).replace("end", "" + len);
                        } else {
                            seek = seek.replace("pos", "" + (startPos + 1)).replace("end", "" + endPos);
                        }
                    } else if (seek.contains("pos")) {
                        seek = seek.replace("pos", "" + startPos);
                        seek = seek.replace("end", "" + endPos);
                    }
                    String string5 = var6_13.substring(0, sPos) + seek + var6_13.substring(sEnd + 1);
                }
            }
            seekcmd.add((String)var6_6);
        }
        return seekcmd;
    }

    public InputStream setRange(String seekChr, int startPos, int endPos) {
        try {
            List<String> seekcmd = this.seekCmd(seekChr, startPos, endPos);
            if (this.p != null && this.p.isAlive()) {
                this.linesRead = 0;
                this.p.destroy();
            }
            this.pb = new ProcessBuilder(seekcmd.stream().filter(p -> p.length() > 0).collect(Collectors.toList()));
            if (this.fileroot != null) {
                this.pb.directory(this.fileroot.toFile());
            }
            this.p = this.pb.start();
            Thread errorThread = new Thread(() -> {
                try {
                    InputStream es = this.p.getErrorStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(es));
                    String line = br.readLine();
                    while (line != null) {
                        this.errorStr = this.errorStr + line + "\n";
                        line = br.readLine();
                    }
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            errorThread.start();
            return this.p.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read line from external process in seek: " + this.commands, e);
        }
    }

    public String getHeader() {
        if (this.pushdownGorPipe != null && this.pushdownGorPipe.length() > 0) {
            this.gor();
        }
        return super.getHeader();
    }

    public boolean isBuffered() {
        return true;
    }

    public Dataset<? extends org.gorpipe.gor.model.Row> checkRowFormat(Dataset<? extends Row> dataset) {
        Dataset ret;
        if (!this.isGorRow) {
            this.isGorRow = true;
            StructField[] fields = dataset.schema().fields();
            boolean lng = fields.length > 1 && fields[1].dataType() == DataTypes.LongType;
            this.nor |= SparkRowSource.checkNor(fields);
            Dataset dr = dataset;
            ret = this.nor ? dr.map(SparkRow::new, SparkGOR.sparkrowEncoder()) : (lng ? dr.map(LongGorSparkRow::new, SparkGOR.sparkrowEncoder()) : dr.map(GorSparkRow::new, SparkGOR.sparkrowEncoder()));
        } else {
            ret = dataset;
        }
        return ret;
    }

    public boolean pushdownFilter(String gorwhere) {
        if (this.pushdownGorPipe != null) {
            this.pushdownGor("where " + gorwhere);
        } else {
            StructType st = this.dataset.schema();
            StructField[] fields = st.fields();
            this.nor |= SparkRowSource.checkNor(fields);
            String[] headersplit = (String[])Arrays.stream(fields).map(StructField::name).toArray(String[]::new);
            String[] ctypes = (String[])Arrays.stream(st.fields()).map(f -> this.dmap.get(f.dataType())).toArray(String[]::new);
            this.dataset = this.dataset.filter((FilterFunction)(this.nor ? new NorFilterFunction(gorwhere, headersplit, ctypes) : new GorFilterFunction(gorwhere, headersplit, ctypes)));
        }
        return true;
    }

    public boolean pushdownCalc(String formula, String colName) {
        if (formula.startsWith("udf")) {
            String newformula = formula.substring(4, formula.length() - 1).trim();
            int i2 = newformula.indexOf(40);
            String udfname = newformula.substring(0, i2);
            String[] args = newformula.substring(i2 + 1, newformula.length() - 1).split(",");
            List colist = Arrays.stream(args).map(functions::col).collect(Collectors.toList());
            Seq colseq = JavaConverters.asScalaIterator(colist.iterator()).toSeq();
            this.dataset = this.dataset.withColumn(colName, functions.callUDF((String)udfname, (Seq)colseq));
        } else if (formula.toLowerCase().startsWith("normalize")) {
            String oldcolname = formula.substring(10, formula.length() - 1).trim();
            Dataset<? extends Row> ds = this.dataset;
            Normalizer normalizer = new Normalizer();
            normalizer.setInputCol(oldcolname);
            normalizer.setOutputCol(colName);
            this.dataset = normalizer.transform(ds);
        } else if (formula.toLowerCase().startsWith("pcatransform")) {
            String modelpath = formula.substring(13, formula.length() - 1).trim();
            if (modelpath.startsWith("'")) {
                modelpath = modelpath.substring(1, modelpath.length() - 1);
            }
            Dataset<? extends Row> ds = this.dataset;
            this.dataset = this.pcatransform(ds, modelpath).withColumnRenamed("pca", colName);
        } else if (formula.toLowerCase().startsWith("chartodoublearray")) {
            if (this.pushdownGorPipe != null) {
                this.gor();
            }
            CharToDoubleArray cda = new CharToDoubleArray();
            UserDefinedFunction udf1 = functions.udf((UDF1)cda, (DataType)DataTypes.createArrayType((DataType)DataTypes.DoubleType));
            String colRef = formula.substring("chartodoublearray".length() + 1, formula.length() - 1);
            this.dataset = this.dataset.withColumn(colName, udf1.apply(new Column[]{this.dataset.col(colRef)}));
        } else if (this.pushdownGorPipe != null) {
            this.pushdownGor("calc " + colName + " " + formula);
        } else {
            StructType st = this.dataset.schema();
            StructField[] st_fields = st.fields();
            this.nor |= SparkRowSource.checkNor(st_fields);
            String[] headersplit = (String[])Arrays.stream(st_fields).map(StructField::name).toArray(String[]::new);
            String[] ctypes = (String[])Arrays.stream(st.fields()).map(f -> this.dmap.get(f.dataType())).toArray(String[]::new);
            DataType[] dataTypes = (DataType[])Arrays.stream(st.fields()).map(StructField::dataType).toArray(DataType[]::new);
            FilterParams fp = new FilterParams(formula, headersplit, ctypes);
            OptionalInt oi = IntStream.range(0, headersplit.length).filter(i -> headersplit[i].equalsIgnoreCase(colName)).findFirst();
            StructField[] fields = oi.isPresent() ? new StructField[headersplit.length] : new StructField[headersplit.length + 1];
            IntStream.range(0, headersplit.length).forEach(i -> {
                fields[i] = new StructField(headersplit[i], dataTypes[i], true, Metadata.empty());
            });
            GorMapFunction gmp = this.nor ? new NorMapFunction(fp, oi) : new GorMapFunction(fp, oi);
            String ctype = gmp.getCalcType();
            DataType type = this.dsmap.get(ctype);
            fields[oi.isPresent() ? oi.getAsInt() : fields.length - 1] = new StructField(colName, type, true, Metadata.empty());
            StructType schema = new StructType(fields);
            ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
            this.dataset = this.dataset.map((MapFunction)gmp, (Encoder)encoder);
            this.setHeader(this.correctHeader(this.dataset.columns()));
        }
        return true;
    }

    public boolean pushdownSelect(String[] cols) {
        return false;
    }

    public boolean pushdownWrite(String filename) {
        if (this.parquetPath == null) {
            int id = filename.indexOf("-pca ");
            if (id != -1) {
                int k = id + 5;
                char c = filename.charAt(k);
                while (c == ' ') {
                    c = filename.charAt(++k);
                }
                while (k < filename.length() && c != ' ') {
                    c = filename.charAt(k++);
                }
                String pcompstr = filename.substring(id + 5, k).trim();
                this.pcacomponents = Integer.parseInt(pcompstr);
                this.parquetPath = filename.substring(k).trim();
                if (this.parquetPath.length() == 0) {
                    this.parquetPath = this.gorSparkSession.getProjectContext().getFileCache().tempLocation(this.jobId, CommandParseUtilities.getExtensionForQuery((String)(this.sql.startsWith("<(") ? "spark " + this.sql : this.sql), (boolean)false));
                }
            } else {
                id = filename.indexOf("-d ");
                if (id >= 0) {
                    int li = filename.indexOf(32, id + 3);
                    if (li == -1) {
                        li = filename.length();
                    }
                    this.parquetPath = filename.substring(id + 3, li).trim();
                    this.dictPath = li == filename.length() ? this.parquetPath : filename.substring(li + 1).trim();
                } else {
                    this.parquetPath = filename;
                    this.dictPath = filename;
                }
            }
        }
        this.it = null;
        return true;
    }

    public boolean pushdownCmd(String cmd) {
        int i = cmd.indexOf(123);
        String query = cmd.substring(i + 1, cmd.length() - 1);
        Dataset<? extends org.gorpipe.gor.model.Row> dr = this.checkRowFormat(this.dataset);
        String inputHeader = String.join((CharSequence)"\t", this.dataset.schema().fieldNames());
        GorSparkExternalFunction gsef = new GorSparkExternalFunction(inputHeader, query, null);
        gsef.setFetchHeader(true);
        org.gorpipe.gor.model.Row r = (org.gorpipe.gor.model.Row)dr.mapPartitions((MapPartitionsFunction)gsef, SparkGOR.gorrowEncoder()).head();
        gsef.setFetchHeader(false);
        GorSparkRowInferFunction gi = new GorSparkRowInferFunction();
        org.gorpipe.gor.model.Row row = (org.gorpipe.gor.model.Row)dr.mapPartitions((MapPartitionsFunction)gsef, SparkGOR.gorrowEncoder()).limit(100).reduce((ReduceFunction)gi);
        if (row.chr != null) {
            row = gi.infer(row, row);
        }
        StructType schema = SparkRowSource.schemaFromRow(r.toString().split("\t"), row);
        gsef.setSchema(schema);
        this.setHeader(this.correctHeader(schema.fieldNames()));
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
        this.dataset = dr.mapPartitions((MapPartitionsFunction)gsef, (Encoder)encoder);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Dataset<Row> analyse(Dataset<Row> dataset, String gor) {
        String[] pipe_options;
        block12: {
            String[] pipe_options2;
            block11: {
                Dataset ret;
                block10: {
                    ret = null;
                    if (gor.startsWith("gatk")) break block10;
                    if (gor.startsWith("pipe")) break block11;
                    if (gor.startsWith("split_multiallelics")) {
                        HashMap options = new HashMap();
                        return Glow.transform((String)"split_multiallelics", dataset, options);
                    }
                    if (!gor.startsWith("block_variants_and_samples")) {
                        if (!gor.startsWith("make_sample_blocks")) return ret;
                        int sampleCount = Integer.parseInt(gor.substring("make_sample_blocks".length()).trim());
                        return VariantSampleBlockMaker.makeSampleBlocks(dataset, (int)sampleCount);
                    }
                    break block12;
                }
                String command = gor.substring(5);
                if (!command.startsWith("haplotypecaller")) return ret;
                return ret;
            }
            HashMap<String, String> options = new HashMap<String, String>();
            String cmd = gor.substring(4).trim();
            String[] stringArray = pipe_options2 = cmd.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return Glow.transform((String)"pipe", dataset, options);
                }
                String popt = stringArray[n2];
                String[] psplit = popt.split("=");
                if (psplit[1].startsWith("'")) {
                    options.put(psplit[0], psplit[1].substring(1, psplit[1].length() - 1));
                } else {
                    options.put(psplit[0], psplit[1]);
                }
                ++n2;
            }
        }
        HashMap<String, String> options = new HashMap<String, String>();
        String cmd = gor.substring("block_variants_and_samples".length()).trim();
        String[] stringArray = pipe_options = cmd.split(" ");
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String popt = stringArray[n3];
            String[] psplit = popt.split("=");
            if (psplit[1].startsWith("'")) {
                options.put(psplit[0], psplit[1].substring(1, psplit[1].length() - 1));
            } else {
                options.put(psplit[0], psplit[1]);
            }
            ++n3;
        }
        return Glow.transform((String)"block_variants_and_samples", dataset, options);
    }

    private Dataset<Row> pcatransform(Dataset<Row> dataset, String modelpath) {
        PCAModel pcamodel = PCAModel.load((String)modelpath);
        Dataset pcaresult = pcamodel.transform(dataset).select("pn", new String[]{"pca"});
        return pcaresult;
    }

    public boolean pushdownGor(String gor) {
        if (gor.startsWith("rename")) {
            if (this.pushdownGorPipe != null) {
                this.gor();
            }
            String[] split = gor.substring("rename".length()).trim().split(" ");
            this.dataset = this.dataset.withColumnRenamed(split[0], split[1]);
        } else if (gor.startsWith("repatition")) {
            if (this.pushdownGorPipe != null) {
                this.gor();
            }
            String[] split = gor.substring("repatition".length()).trim().split(" ");
            try {
                int val = Integer.parseInt(split[1]);
                this.dataset = this.dataset.repartition(val);
            }
            catch (Exception e) {
                this.dataset.repartition(new Column[0]);
            }
        } else if (gor.toLowerCase().startsWith("selectexpr ")) {
            String[] selects = gor.substring("selectexpr".length()).trim().split(",");
            this.dataset = this.dataset.selectExpr(selects);
        } else if (gor.toLowerCase().startsWith("gttranspose")) {
            this.dataset = this.gttranspose(this.dataset);
        } else if (gor.toLowerCase().startsWith("pcatransform ")) {
            String pcamodel = gor.substring("pcatransform".length()).trim();
            this.dataset = this.pcatransform(this.dataset, pcamodel);
        } else if (gor.toLowerCase().startsWith("normalize ")) {
            String colname = gor.substring("normalize".length()).trim();
            Dataset<? extends Row> ds = this.dataset;
            Normalizer normalizer = new Normalizer();
            normalizer.setInputCol(colname);
            normalizer.setOutputCol("normalized_" + colname);
            this.dataset = normalizer.transform(ds);
        } else if (gor.startsWith("pyspark")) {
            if (this.pushdownGorPipe != null) {
                this.gor();
            }
            String cmd = gor.substring("pyspark".length());
            PysparkAnalysis pyspark = new PysparkAnalysis();
            try {
                this.pysparkAnalyses.add(pyspark);
                this.dataset = pyspark.pyspark(UUID.randomUUID().toString(), this.dataset, cmd);
            }
            catch (IOException | InterruptedException e) {
                throw new GorResourceException("Unable to run spark python command", pyspark.cmdString(), (Throwable)e);
            }
        } else if (this.pushdownGorPipe == null) {
            Dataset<Row> ret = SparkRowSource.analyse(this.dataset, gor);
            if (ret != null) {
                this.dataset = ret;
            } else {
                this.pushdownGorPipe = gor;
            }
        } else {
            this.pushdownGorPipe = this.pushdownGorPipe + "|" + gor;
        }
        return true;
    }

    public boolean pushdownTop(int limit) {
        if (this.pushdownGorPipe != null) {
            this.pushdownGor("top " + limit);
        } else {
            this.dataset = this.dataset.limit(limit);
        }
        return true;
    }

    static {
        tmap.put("S", DataTypes.StringType);
        tmap.put("I", DataTypes.IntegerType);
        tmap.put("D", DataTypes.DoubleType);
    }
}

