/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gorpipe.spark.platform.RedisPipeline;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class JedisPipelineWrapper
implements RedisPipeline {
    private Pipeline pipeline;
    private List<Response<?>> responses = new ArrayList();
    private Jedis jedis;

    public JedisPipelineWrapper(Jedis jedis, Pipeline pipelined) {
        this.jedis = jedis;
        this.pipeline = pipelined;
    }

    @Override
    public void close() {
        this.sync();
        this.jedis.ping();
    }

    @Override
    public void sync() {
        this.pipeline.sync();
    }

    @Override
    public void hmset(String key, Map<String, String> map) {
        this.responses.add(this.pipeline.hmset(key, map));
    }

    @Override
    public void zadd(String key, double score, String member) {
        this.responses.add(this.pipeline.zadd(key, score, member));
    }

    @Override
    public void hset(String key, String field, String value) {
        this.responses.add(this.pipeline.hset(key, field, value));
    }

    @Override
    public void del(String key) {
        this.responses.add(this.pipeline.del(key));
    }

    @Override
    public void zrem(String key, String member) {
        this.responses.add(this.pipeline.zrem(key, new String[]{member}));
    }

    @Override
    public void hdel(String key, String field) {
        this.responses.add(this.pipeline.hdel(key, new String[]{field}));
    }

    @Override
    public void decrBy(String key, Long integer) {
        this.responses.add(this.pipeline.decrBy(key, integer.longValue()));
    }

    @Override
    public void incrBy(String key, Long integer) {
        this.responses.add(this.pipeline.incrBy(key, integer.longValue()));
    }

    @Override
    public List<Response<?>> getResponses() {
        return this.responses;
    }

    @Override
    public void hgetall(String string) {
        this.responses.add(this.pipeline.hgetAll(string));
    }
}

