/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import gorsat.spark.GorReaderFactory;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.types.StructType;

public abstract class GorScanBuilder
implements ScanBuilder,
Scan,
Batch,
SupportsPushDownFilters {
    StructType schema;
    String redisUri;
    String streamKey;
    String jobId;
    String cacheFile;
    String useCpp;
    String projectRoot;
    String cacheDir;
    String configFile;
    String aliasFile;
    String securityContext;

    public GorScanBuilder(StructType schema, String redisUri, String streamKey, String jobId, String cacheFile, String projectRoot, String cacheDir, String configFile, String aliasFile, String securityContext, String useCpp) {
        this.schema = schema;
        this.redisUri = redisUri;
        this.streamKey = streamKey;
        this.jobId = jobId;
        this.cacheFile = cacheFile;
        this.useCpp = useCpp;
        this.projectRoot = projectRoot;
        this.cacheDir = cacheDir;
        this.configFile = configFile;
        this.aliasFile = aliasFile;
        this.securityContext = securityContext;
    }

    public Scan build() {
        return this;
    }

    public Batch toBatch() {
        return this;
    }

    public StructType readSchema() {
        return this.schema;
    }

    public PartitionReaderFactory createReaderFactory() {
        return new GorReaderFactory(this.schema, this.redisUri, this.streamKey, this.jobId, this.cacheFile, this.projectRoot, this.cacheDir, this.configFile, this.aliasFile, this.securityContext, this.useCpp);
    }
}

