/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import java.util.Arrays;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.gor.function.GorRowFilterFunction;
import org.gorpipe.gor.model.Row;

public class GorSparkRowFilterFunction<T extends Row>
extends GorRowFilterFunction<Row>
implements FilterFunction<T> {
    public GorSparkRowFilterFunction(String gorwhere, String[] header, String[] types) {
        super(gorwhere, header, types);
    }

    public GorSparkRowFilterFunction(String gorwhere, StructType schema) {
        this(gorwhere, schema.fieldNames(), GorSparkRowFilterFunction.gorTypes(schema));
    }

    static String[] gorTypes(StructType schema) {
        return (String[])Arrays.stream(schema.fields()).map(StructField::dataType).map(d -> {
            if (d.sameType(DataTypes.IntegerType)) {
                return "I";
            }
            if (d.sameType(DataTypes.DoubleType)) {
                return "D";
            }
            return "S";
        }).toArray(String[]::new);
    }

    public boolean call(T value) {
        return this.test((Row)value);
    }
}

