/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.Base64;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Row;
import org.gorpipe.gor.binsearch.CompressionType;
import org.gorpipe.gor.binsearch.Unzipper;

public class GorzFlatMap
implements FlatMapFunction<Row, String> {
    byte[] buffer;

    public Iterator<String> call(Row row) throws Exception {
        String zip = row.getString(2);
        char tp = zip.charAt(0);
        CompressionType compressionLibrary = (tp & 2) == 0 ? CompressionType.ZLIB : CompressionType.ZSTD;
        byte[] bb = Base64.getDecoder().decode(zip);
        Unzipper unzip = new Unzipper();
        unzip.setType(compressionLibrary);
        unzip.setRawInput(bb, 0, bb.length);
        if (this.buffer == null) {
            this.buffer = new byte[131072];
        }
        int unzipLen = unzip.decompress(this.buffer, 0, this.buffer.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(this.buffer, 0, unzipLen);
        InputStreamReader isr = new InputStreamReader(bais);
        BufferedReader br = new BufferedReader(isr);
        return br.lines().iterator();
    }
}

