/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BinaryOperator;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.gorpipe.gor.model.Row;
import org.gorpipe.model.gor.RowObj;
import org.gorpipe.spark.GorSparkRowInferFunction;

public class HeaderInferFunction
implements MapPartitionsFunction<String, String>,
Serializable {
    String cmd;
    String header;

    public HeaderInferFunction(String cmd, String header) {
        this.cmd = cmd;
        this.header = header;
    }

    public Iterator<String> call(Iterator<String> iterator) throws Exception {
        String[] split = this.cmd.split(" ");
        ProcessBuilder pb = new ProcessBuilder(split);
        Process p = pb.start();
        OutputStream os = p.getOutputStream();
        InputStream err = p.getErrorStream();
        Thread t = new Thread(() -> {
            try {
                os.write(this.header.getBytes());
                os.write(10);
                while (iterator.hasNext()) {
                    os.write(((String)iterator.next()).getBytes());
                    os.write(10);
                }
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        t.start();
        Thread t2 = new Thread(() -> {
            try {
                int r = err.read();
                while (r != -1) {
                    System.err.print((char)r);
                    r = err.read();
                }
                System.err.println();
                err.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        t2.start();
        InputStreamReader isr = new InputStreamReader(p.getInputStream());
        BufferedReader br = new BufferedReader(isr);
        String header = br.readLine();
        GorSparkRowInferFunction gif = new GorSparkRowInferFunction();
        Optional<Row> or = br.lines().map(RowObj::apply).reduce((BinaryOperator<Row>)((Object)gif));
        if (or.isPresent()) {
            Row r = or.get();
            String[] hsplit = header.split("\t");
            StringBuilder sb = new StringBuilder();
            sb.append(hsplit[0]).append('[').append(r.colAsString(0)).append(']');
            for (int i = 1; i < hsplit.length; ++i) {
                sb.append('\t').append(hsplit[i]).append('[').append(r.colAsString(i)).append(']');
            }
            return Collections.singletonList(sb.toString()).iterator();
        }
        return Collections.singletonList(header).iterator();
    }
}

