/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark;

import gorsat.process.FreemarkerReportBuilder;
import gorsat.process.GenericRunnerFactory;
import gorsat.process.GorSessionCacheManager;
import gorsat.process.GorSessionFactory;
import gorsat.process.SessionBasedQueryEvaluator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import org.apache.spark.sql.SparkSession;
import org.gorpipe.client.FileCache;
import org.gorpipe.gor.clients.LocalFileCacheClient;
import org.gorpipe.gor.model.DriverBackedFileReader;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.GorParallelQueryHandler;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.gor.session.GorReportBuilder;
import org.gorpipe.gor.session.GorRunnerFactory;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.session.GorSessionCache;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.gor.session.SystemContext;
import org.gorpipe.gor.table.util.PathUtils;
import org.gorpipe.spark.GeneralSparkQueryHandler;
import org.gorpipe.spark.GorSparkSession;
import org.gorpipe.spark.GorSparkUtilities;

public class SparkSessionFactory
extends GorSessionFactory {
    private String root;
    private String cacheDir;
    private Optional<String> configFile;
    private Optional<String> aliasFile;
    private SparkSession sparkSession;
    private GorMonitor sparkGorMonitor;
    private GorParallelQueryHandler sparkQueryHandler;
    private String securityContext;
    private int workers;

    public SparkSessionFactory(String root, String cacheDir, String configFile, String aliasFile, String securityContext, GorMonitor sparkMonitor) {
        this(GorSparkUtilities.getSparkSession(), root, cacheDir, configFile, aliasFile, securityContext, sparkMonitor);
    }

    public SparkSessionFactory(SparkSession sparkSession, String root, String cacheDir, String configFile, String aliasFile, String securityContext, GorMonitor sparkMonitor, int workers) {
        this.root = root;
        this.cacheDir = cacheDir;
        Path rootPath = Paths.get(root, new String[0]);
        if (configFile != null && configFile.length() > 0) {
            Path configPath = Paths.get(configFile, new String[0]);
            if (!configPath.isAbsolute()) {
                configPath = rootPath.resolve(configPath);
            }
            this.configFile = Files.exists(configPath, new LinkOption[0]) ? Optional.of(configPath.toAbsolutePath().toString()) : Optional.empty();
        } else {
            this.configFile = Optional.empty();
        }
        if (aliasFile != null && aliasFile.length() > 0) {
            Path aliasPath = Paths.get(aliasFile, new String[0]);
            if (!aliasPath.isAbsolute()) {
                aliasPath = rootPath.resolve(aliasPath);
            }
            this.aliasFile = Files.exists(aliasPath, new LinkOption[0]) ? Optional.of(aliasPath.toAbsolutePath().toString()) : Optional.empty();
        } else {
            this.aliasFile = Optional.empty();
        }
        this.sparkSession = sparkSession;
        this.sparkGorMonitor = sparkMonitor;
        this.workers = workers;
        this.securityContext = securityContext;
    }

    public SparkSessionFactory(SparkSession sparkSession, String root, String cacheDir, String configFile, String aliasFile, String securityContext, GorMonitor sparkMonitor) {
        this(sparkSession, root, cacheDir, configFile, aliasFile, securityContext, sparkMonitor, new GeneralSparkQueryHandler());
    }

    public SparkSessionFactory(SparkSession sparkSession, String root, String cacheDir, String configFile, String aliasFile, String securityContext, GorMonitor sparkMonitor, GorParallelQueryHandler queryHandler) {
        this(sparkSession, root, cacheDir, configFile, aliasFile, securityContext, sparkMonitor, 0);
        this.sparkQueryHandler = queryHandler;
    }

    public GorSparkSession generateSession() {
        String requestId = UUID.randomUUID().toString();
        GorSparkSession session = new GorSparkSession(requestId, this.workers);
        session.setSparkSession(this.sparkSession);
        return session;
    }

    public GorSession create() {
        GorSparkSession session;
        if (this.sparkQueryHandler instanceof GeneralSparkQueryHandler) {
            GeneralSparkQueryHandler generalSparkQueryHandler = (GeneralSparkQueryHandler)this.sparkQueryHandler;
            if (generalSparkQueryHandler.gpSession != null) {
                session = generalSparkQueryHandler.gpSession;
            } else {
                session = this.generateSession();
                generalSparkQueryHandler.init(session);
            }
        } else {
            session = this.generateSession();
        }
        DriverBackedFileReader fileReader = new DriverBackedFileReader(this.securityContext, this.root, null);
        ProjectContext.Builder projectContextBuilder = new ProjectContext.Builder();
        if (this.configFile.isPresent()) {
            projectContextBuilder = projectContextBuilder.setConfigFile(this.configFile.get());
        }
        if (this.aliasFile.isPresent()) {
            projectContextBuilder = projectContextBuilder.setAliasFile(this.aliasFile.get());
        }
        projectContextBuilder = projectContextBuilder.setRoot((String)(this.securityContext != null ? this.root + this.securityContext : this.root)).setCacheDir(this.cacheDir).setFileReader((FileReader)fileReader).setFileCache((FileCache)new LocalFileCacheClient(fileReader, PathUtils.resolve((String)this.root, (String)this.cacheDir))).setQueryHandler(this.sparkQueryHandler).setQueryEvaluator((QueryEvaluator)new SessionBasedQueryEvaluator((GorSession)session));
        SystemContext.Builder systemContextBuilder = new SystemContext.Builder();
        systemContextBuilder.setReportBuilder((GorReportBuilder)new FreemarkerReportBuilder((GorSession)session)).setRunnerFactory((GorRunnerFactory)new GenericRunnerFactory()).setServer(false).setMonitor(this.sparkGorMonitor).setStartTime(System.currentTimeMillis());
        GorSessionCache cache = GorSessionCacheManager.getCache((String)session.getRequestId());
        session.init(projectContextBuilder.build(), systemContextBuilder.build(), cache);
        if (this.sparkQueryHandler instanceof GeneralSparkQueryHandler) {
            ((GeneralSparkQueryHandler)this.sparkQueryHandler).init(session);
        }
        return session;
    }
}

