/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.Commands.CommandParseUtilities;
import gorsat.process.GorJavaUtilities;
import gorsat.process.PipeInstance;
import io.kubernetes.client.openapi.ApiException;
import java.io.IOException;
import java.nio.file.Path;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.driver.meta.SourceReferenceBuilder;
import org.gorpipe.gor.driver.providers.stream.StreamSourceFile;
import org.gorpipe.gor.driver.providers.stream.datatypes.parquet.ParquetFileIterator;
import org.gorpipe.gor.driver.providers.stream.sources.StreamSource;
import org.gorpipe.gor.driver.providers.stream.sources.file.FileSource;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.model.gor.iterators.RowSource;
import org.gorpipe.spark.GorSparkSession;
import org.gorpipe.spark.SparkOperatorRunner;

public class SparkPipeInstance
extends PipeInstance {
    GorSparkSession session;
    GenomicIterator genit;
    String cachePath;
    boolean hasResourceHints;

    public SparkPipeInstance(GorContext context) {
        super(context);
        this.session = (GorSparkSession)context.getSession();
    }

    public SparkPipeInstance(GorContext context, String cachePath) {
        this(context);
        this.cachePath = cachePath;
    }

    public boolean hasResourceHints() {
        return this.hasResourceHints;
    }

    public GenomicIterator runSparkOperator(GorMonitor gm, String[] commands, String[] resourceSplit) {
        try {
            SparkOperatorRunner sparkOperatorRunner = new SparkOperatorRunner(this.session);
            Path cacheFilePath = sparkOperatorRunner.run(this.session.redisUri(), this.session.getRequestId(), this.session.getProjectContext().getRoot(), gm, commands, resourceSplit, this.cachePath);
            Path cacheFileFullPath = cacheFilePath.toAbsolutePath().normalize();
            SourceReferenceBuilder srb = new SourceReferenceBuilder(cacheFileFullPath.toString());
            srb.commonRoot(this.session.getProjectContext().getRealProjectRootPath().toString());
            FileSource fileSource = new FileSource(srb.build());
            StreamSourceFile ssf = new StreamSourceFile((StreamSource)fileSource);
            ParquetFileIterator pfi = new ParquetFileIterator(ssf);
            pfi.init((GorSession)this.session);
            return pfi;
        }
        catch (ApiException | IOException | InterruptedException e) {
            throw new GorSystemException(e);
        }
    }

    public RowSource getIterator() {
        if (this.hasResourceHints) {
            return this.wrapGenomicIterator(this.genit);
        }
        return super.getIterator();
    }

    public RowSource wrapGenomicIterator(final GenomicIterator gi) {
        return new RowSource(){

            public boolean hasNext() {
                return gi.hasNext();
            }

            public Row next() {
                return gi.next();
            }

            public void setPosition(String seekChr, int seekPos) {
                gi.seek(seekChr, seekPos);
            }

            public void close() {
                gi.close();
            }
        };
    }

    public GenomicIterator init(String inputQuery, boolean useStdin, String forcedInputHeader) {
        String[] commands = CommandParseUtilities.quoteSafeSplit((String)inputQuery, (char)';');
        String lastcommand = commands[commands.length - 1];
        String[] resourceSplit = GorJavaUtilities.splitResourceHints((String)lastcommand, (String)"spec.");
        String resourceHints = resourceSplit[1];
        boolean bl = this.hasResourceHints = resourceHints != null && resourceHints.length() > 0;
        if (!this.hasResourceHints) {
            GenomicIterator inputSource = super.init(inputQuery, useStdin, forcedInputHeader);
            this.genit = super.getIterator();
            return inputSource;
        }
        this.genit = this.runSparkOperator(this.session.getSystemContext().getMonitor(), commands, resourceSplit);
        this.theInputSource_$eq(this.genit);
        return this.genit;
    }

    public void init(String params, GorMonitor gm) {
        String[] commands = CommandParseUtilities.quoteSafeSplit((String)params, (char)';');
        String lastcommand = commands[commands.length - 1];
        String[] resourceSplit = GorJavaUtilities.splitResourceHints((String)lastcommand, (String)"spec.");
        String resourceHints = resourceSplit[1];
        boolean bl = this.hasResourceHints = resourceHints != null && resourceHints.length() > 0;
        if (!this.hasResourceHints) {
            super.init(params, gm);
            this.genit = super.getIterator();
        } else {
            this.genit = this.runSparkOperator(gm, commands, resourceSplit);
        }
    }

    public String getHeader() {
        if (this.hasResourceHints) {
            return this.genit.getHeader();
        }
        return super.getHeader();
    }

    public void seek(String chr, int pos) {
        if (this.hasResourceHints) {
            this.genit.seek(chr, pos);
        } else {
            super.seek(chr, pos);
        }
    }

    public boolean hasNext() {
        return this.genit.hasNext();
    }

    public String next() {
        return this.genit.next().toString();
    }

    public void close() {
        if (this.hasResourceHints) {
            this.genit.close();
        } else {
            super.close();
        }
    }
}

