/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import gorsat.Script.ScriptEngineFactory;
import gorsat.Script.ScriptExecutionEngine;
import gorsat.process.GorDataType;
import gorsat.process.SparkRowUtilities;
import gorsat.spark.GorRangeInputPartition;
import gorsat.spark.GorScanBuilder;
import gorsat.spark.GorWriteBuilder;
import gorsat.spark.ReceiveQueryHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.DataFormatException;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.gorpipe.gor.reference.ReferenceBuildDefaults;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.spark.GorSparkSession;
import org.gorpipe.spark.SparkSessionFactory;

public abstract class GorBatchTable
implements Table,
SupportsRead,
SupportsWrite,
SupportsPushDownFilters {
    String[] commands;
    String query;
    String path;
    String inputfilter;
    String filterFile;
    String filterColumn;
    String splitFile;
    String fchrom;
    int fstart = 0;
    int fstop = -1;
    String redisUri;
    String jobId;
    String cacheFile;
    String useCpp;
    StructType schema;
    boolean tag;
    String projectRoot;
    String cacheDir;
    String configFile;
    String aliasFile;
    private static final Set<TableCapability> CAPABILITIES = new HashSet<TableCapability>(Arrays.asList(TableCapability.BATCH_READ, TableCapability.BATCH_WRITE, TableCapability.TRUNCATE));

    public GorBatchTable(String query, boolean tag, String path, String filter, String filterFile, String filterColumn, String splitFile, String seek, String redisUri, String jobId, String cacheFile, String useCpp) {
        this.init(query, tag, path, filter, filterFile, filterColumn, splitFile, seek, redisUri, jobId, cacheFile, useCpp);
    }

    public GorBatchTable(String query, boolean tag, String path, String filter, String filterFile, String filterColumn, String splitFile, String seek, StructType schema, String redisUri, String jobId, String cacheFile, String useCpp) {
        this.init(query, tag, path, filter, filterFile, filterColumn, splitFile, seek, redisUri, jobId, cacheFile, useCpp);
        this.schema = schema;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setAliasFile(String aliasFile) {
        this.aliasFile = aliasFile;
    }

    void checkSeek(String seek) {
        if (seek != null && seek.length() > 0) {
            String[] spl = seek.split(":");
            this.fchrom = spl[0];
            if (spl.length > 1) {
                String[] sspl = spl[1].split("-");
                this.fstart = Integer.parseInt(sspl[0]);
                if (sspl.length > 1) {
                    this.fstop = Integer.parseInt(sspl[1]);
                }
            }
        }
    }

    void init(String query, boolean tag, String path, String filter, String filterFile, String filterColumn, String splitFile, String seek, String redisUri, String jobId, String cacheFile, String useCpp) {
        this.query = query;
        this.projectRoot = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        this.cacheDir = "result_cache";
        this.tag = tag;
        this.path = path;
        this.inputfilter = filter;
        this.filterFile = filterFile;
        this.filterColumn = filterColumn;
        this.splitFile = splitFile;
        this.redisUri = redisUri;
        this.jobId = jobId;
        this.cacheFile = cacheFile;
        this.useCpp = useCpp;
        this.checkSeek(seek);
    }

    private String[] initCommands(String query) {
        String[] commands = null;
        if (query != null) {
            if (query.toLowerCase().startsWith("pgor") || query.toLowerCase().startsWith("partgor") || query.toLowerCase().startsWith("parallel")) {
                ReceiveQueryHandler receiveQueryHandler = new ReceiveQueryHandler();
                SparkSessionFactory sessionFactory = new SparkSessionFactory(null, this.projectRoot, this.cacheDir, this.configFile, this.aliasFile, null, receiveQueryHandler);
                GorSparkSession gorPipeSession = (GorSparkSession)sessionFactory.create();
                ScriptExecutionEngine see = ScriptEngineFactory.create((GorContext)gorPipeSession.getGorContext());
                see.execute(new String[]{query}, false);
                commands = receiveQueryHandler.getCommandsToExecute();
            } else {
                commands = new String[]{query};
            }
        }
        return commands;
    }

    void inferSchema() {
        this.commands = this.initCommands(this.query);
        this.schema = Encoders.STRING().schema();
        if (this.path != null) {
            Path ppath = Paths.get(this.path, new String[0]);
            try {
                this.schema = SparkRowUtilities.inferSchema(ppath, ppath.getFileName().toString(), false, this.path.toLowerCase().endsWith(".gorz"));
            }
            catch (IOException | DataFormatException e) {
                throw new RuntimeException("Unable to infer schema from " + ppath.toString(), e);
            }
        } else if (this.commands != null) {
            int start;
            SparkSessionFactory sessionFactory = new SparkSessionFactory(null, this.projectRoot, this.cacheDir, this.configFile, this.aliasFile, null);
            GorSparkSession gorPipeSession = (GorSparkSession)sessionFactory.create();
            GorDataType gdt = SparkRowUtilities.gorCmdSchema(this.commands, gorPipeSession);
            String[] headerArray = gdt.header;
            DataType[] dataTypes = new DataType[headerArray.length];
            for (int i2 = start = 0; i2 < dataTypes.length; ++i2) {
                dataTypes[i2] = gdt.dataTypeMap.getOrDefault(i2, DataTypes.StringType);
            }
            Stream<StructField> fieldStream = IntStream.range(0, headerArray.length).mapToObj(i -> new StructField(headerArray[i], dataTypes[i], true, Metadata.empty()));
            StructField[] fields = (StructField[])(this.tag ? Stream.concat(fieldStream, Stream.of(new StructField("Tag", DataTypes.StringType, true, Metadata.empty()))) : fieldStream).toArray(StructField[]::new);
            this.schema = new StructType(fields);
        }
    }

    public Scan build() {
        return null;
    }

    public Filter[] pushFilters(Filter[] filters) {
        return new Filter[0];
    }

    public Filter[] pushedFilters() {
        return new Filter[0];
    }

    public StructType schema() {
        if (this.schema == null) {
            this.inferSchema();
        }
        return this.schema;
    }

    public String name() {
        return this.getClass().toString();
    }

    public Set<TableCapability> capabilities() {
        return CAPABILITIES;
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        return new GorWriteBuilder(){};
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap caseInsensitiveStringMap) {
        if (this.schema == null) {
            this.inferSchema();
        }
        return new GorScanBuilder(this.schema, this.redisUri, this.jobId, this.cacheFile, this.projectRoot, this.cacheDir, this.configFile, this.aliasFile, this.useCpp){
            Filter[] pushedFilters;
            String filterChrom;
            int start;
            int stop;
            String filter;
            {
                this.pushedFilters = new Filter[0];
                this.filterChrom = GorBatchTable.this.fchrom;
                this.start = GorBatchTable.this.fstart;
                this.stop = GorBatchTable.this.fstop;
                this.filter = GorBatchTable.this.inputfilter;
            }

            public Filter[] pushFilters(Filter[] filters) {
                Filter[] ret;
                if (this.schema.size() > 2) {
                    String posName = this.schema.fieldNames()[1];
                    String lastName = this.schema.fieldNames()[this.schema.size() - 1];
                    Optional<Filter> chrOpt = Arrays.stream(filters).filter(f -> f instanceof EqualTo).filter(f -> ((EqualTo)f).attribute().equalsIgnoreCase("CHROM")).findFirst();
                    chrOpt.map(f -> ((EqualTo)f).value().toString()).ifPresent(s -> {
                        this.filterChrom = s;
                    });
                    Optional<Filter> inOpt = Arrays.stream(filters).filter(f -> f instanceof In).filter(f -> ((In)f).attribute().equalsIgnoreCase(lastName)).findFirst();
                    if (!inOpt.isPresent()) {
                        inOpt = Arrays.stream(filters).filter(f -> f instanceof EqualTo).filter(f -> ((EqualTo)f).attribute().equalsIgnoreCase(lastName)).findFirst();
                        inOpt.map(f -> ((EqualTo)f).value()).map(Object::toString).ifPresent(s -> {
                            this.filter = s;
                        });
                    } else {
                        inOpt.map(f -> Arrays.stream(((In)f).values()).map(Object::toString).collect(Collectors.joining(","))).ifPresent(s -> {
                            this.filter = s;
                        });
                    }
                    Optional<Filter> posGreatOpt = Arrays.stream(filters).filter(f -> f instanceof GreaterThan).filter(f -> ((GreaterThan)f).attribute().equalsIgnoreCase(posName)).findFirst();
                    if (!posGreatOpt.isPresent()) {
                        posGreatOpt = Arrays.stream(filters).filter(f -> f instanceof GreaterThanOrEqual).filter(f -> ((GreaterThanOrEqual)f).attribute().equalsIgnoreCase(posName)).findFirst();
                    }
                    posGreatOpt.ifPresent(f -> {
                        this.start = f instanceof GreaterThan ? ((Number)((GreaterThan)f).value()).intValue() - 1 : ((Number)((LessThanOrEqual)f).value()).intValue();
                    });
                    Optional<Filter> posGreatOptFinal = posGreatOpt;
                    Optional<Filter> posLessOpt = Arrays.stream(filters).filter(f -> f instanceof LessThan).filter(f -> ((LessThan)f).attribute().equalsIgnoreCase(posName)).findFirst();
                    if (!posLessOpt.isPresent()) {
                        posLessOpt = Arrays.stream(filters).filter(f -> f instanceof LessThanOrEqual).filter(f -> ((LessThanOrEqual)f).attribute().equalsIgnoreCase(posName)).findFirst();
                    }
                    posLessOpt.ifPresent(f -> {
                        this.stop = f instanceof LessThan ? ((Number)((LessThan)f).value()).intValue() : ((Number)((LessThanOrEqual)f).value()).intValue() + 1;
                    });
                    Optional<Filter> posLessOptFinal = posLessOpt;
                    ret = (Filter[])Arrays.stream(filters).filter(f -> !chrOpt.isPresent() || !f.equals(chrOpt.get()) && (!posGreatOptFinal.isPresent() || !f.equals(posGreatOptFinal.get())) && (!posLessOptFinal.isPresent() || !f.equals(posLessOptFinal.get()))).toArray(Filter[]::new);
                } else {
                    ret = new Filter[]{};
                }
                HashSet<Filter> fset = new HashSet<Filter>(Arrays.asList(ret));
                this.pushedFilters = (Filter[])Arrays.stream(filters).filter(f -> !fset.contains(f)).toArray(Filter[]::new);
                return ret;
            }

            public Filter[] pushedFilters() {
                return this.pushedFilters;
            }

            public InputPartition[] planInputPartitions() {
                InputPartition[] partitions = null;
                if (GorBatchTable.this.commands != null) {
                    partitions = (InputPartition[])Arrays.stream(GorBatchTable.this.commands).map(cmd -> {
                        int i;
                        String tagstr = null;
                        if (GorBatchTable.this.tag && (i = cmd.indexOf("-p ") + 3) != -1) {
                            int k;
                            while (i < cmd.length() && cmd.charAt(i) == ' ') {
                                ++i;
                            }
                            for (k = i + 1; k < cmd.length() && cmd.charAt(k) != ' '; ++k) {
                            }
                            tagstr = cmd.substring(i, k);
                        }
                        return new GorRangeInputPartition((String)cmd, tagstr);
                    }).toArray(GorRangeInputPartition[]::new);
                } else if (this.filterChrom != null) {
                    partitions = new InputPartition[]{new GorRangeInputPartition(GorBatchTable.this.path, this.filter, GorBatchTable.this.filterFile, GorBatchTable.this.filterColumn, this.filterChrom, this.start, this.stop, this.filterChrom)};
                } else {
                    if (GorBatchTable.this.splitFile != null) {
                        try {
                            partitions = (InputPartition[])Files.lines(Paths.get(GorBatchTable.this.splitFile, new String[0])).skip(1L).map(line -> line.split("\t")).map(s -> new GorRangeInputPartition(GorBatchTable.this.path, this.filter, GorBatchTable.this.filterFile, GorBatchTable.this.filterColumn, s[0], Integer.parseInt(s[1]), Integer.parseInt(s[2]), (String)(((String[])s).length > 3 ? s[3] : s[0] + ":" + s[1] + "-" + s[2]))).toArray(InputPartition[]::new);
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (partitions == null) {
                        Map buildSizeGeneric = ReferenceBuildDefaults.buildSizeGeneric();
                        partitions = (InputPartition[])buildSizeGeneric.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> new GorRangeInputPartition(GorBatchTable.this.path, this.filter, GorBatchTable.this.filterFile, GorBatchTable.this.filterColumn, (String)e.getKey(), 0, (Integer)e.getValue(), (String)e.getKey())).toArray(InputPartition[]::new);
                    }
                }
                return partitions;
            }
        };
    }

    public Transform[] partitioning() {
        return new Transform[]{Expressions.identity((String)"i")};
    }
}

