/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.gor.binsearch.GorIndexType;
import org.gorpipe.gor.binsearch.GorZipLexOutputStream;
import org.gorpipe.spark.GorSparkRow;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class GorOutputWriter
extends OutputWriter {
    GorZipLexOutputStream of;
    ExpressionEncoder.Deserializer<Row> deserializer;
    Path path;
    String startChrom = null;
    int startPos;
    String stopChrom = null;
    int stopPos;
    String originalPath;

    public GorOutputWriter(String uristr, StructType schema, String originalPath) throws IOException {
        this.originalPath = originalPath;
        List lattr = JavaConverters.asJavaCollection((Iterable)schema.toAttributes()).stream().map(Attribute::toAttribute).collect(Collectors.toList());
        Seq sattr = JavaConverters.asScalaBuffer(lattr).toSeq();
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema).resolveAndBind(sattr, (Analyzer)SimpleAnalyzer$.MODULE$);
        this.deserializer = encoder.createDeserializer();
        String header = String.join((CharSequence)"\t", schema.fieldNames());
        URI uri = URI.create(uristr);
        this.path = Paths.get(uri);
        this.path.getParent().toFile().mkdirs();
        OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);
        this.of = new GorZipLexOutputStream(os, false, null, null, GorIndexType.NONE, 1);
        this.of.setHeader(header);
    }

    public void write(InternalRow row) {
        try {
            Row grow = (Row)this.deserializer.apply(row);
            GorSparkRow sparkrow = new GorSparkRow(grow);
            if (this.startChrom == null) {
                this.startChrom = sparkrow.chr;
                this.startPos = sparkrow.pos;
            }
            this.stopChrom = sparkrow.chr;
            this.stopPos = sparkrow.pos;
            this.of.write((org.gorpipe.gor.model.Row)sparkrow);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        Writer w = null;
        try {
            this.of.close();
            Path origPath = Paths.get(this.originalPath, new String[0]);
            w = Files.newBufferedWriter(origPath.getParent().resolve(origPath.getFileName().toString() + ".gord"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            w.write(origPath.resolve(this.path.getFileName()) + "\t1\t" + this.startChrom + "\t" + this.startPos + "\t" + this.stopChrom + "\t" + this.stopPos + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

