/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import gorsat.QueryHandlers.GeneralQueryHandler;
import gorsat.process.FreemarkerReportBuilder;
import gorsat.process.GenericRunnerFactory;
import gorsat.process.GorSessionCacheManager;
import gorsat.process.SessionBasedQueryEvaluator;
import java.nio.file.Paths;
import java.util.UUID;
import org.gorpipe.client.FileCache;
import org.gorpipe.gor.RequestStats;
import org.gorpipe.gor.clients.LocalFileCacheClient;
import org.gorpipe.gor.clients.NoCacheFileCacheClient;
import org.gorpipe.gor.model.DefaultEventLogger;
import org.gorpipe.gor.model.DriverBackedFileReader;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.GorParallelQueryHandler;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.gor.session.EventLogger;
import org.gorpipe.gor.session.GorReportBuilder;
import org.gorpipe.gor.session.GorRunnerFactory;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.session.GorSessionCache;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.gor.session.SystemContext;
import org.gorpipe.gorshell.GorShellSessionFactory;
import org.gorpipe.spark.GorSparkSession;

public class GorSparkShellSessionFactory
extends GorShellSessionFactory {
    private String root = "";
    private final String cacheDir;
    private String configFile = "";
    private boolean fileCacheEnabled = true;
    private boolean requestStatsEnabled = false;

    public GorSparkShellSessionFactory() {
        this.cacheDir = System.getProperty("java.io.tmpdir");
    }

    public GorSparkShellSessionFactory(String root) {
        this.root = root;
        this.cacheDir = System.getProperty("java.io.tmpdir");
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setFileCacheEnabled(boolean fileCacheEnabled) {
        this.fileCacheEnabled = fileCacheEnabled;
    }

    public void setRequestStatsEnabled(boolean requestStatsEnabled) {
        this.requestStatsEnabled = requestStatsEnabled;
    }

    public GorSession create() {
        String requestId = UUID.randomUUID().toString();
        GorSparkSession session = new GorSparkSession(requestId);
        ProjectContext.Builder projectContextBuilder = new ProjectContext.Builder();
        Object fileCache = this.fileCacheEnabled ? new LocalFileCacheClient(Paths.get(this.cacheDir, new String[0])) : new NoCacheFileCacheClient(Paths.get(this.cacheDir, new String[0]));
        projectContextBuilder.setRoot(this.root).setCacheDir(this.cacheDir).setConfigFile(this.configFile).setFileReader((FileReader)new DriverBackedFileReader("", this.root, null)).setFileCache((FileCache)fileCache).setQueryHandler((GorParallelQueryHandler)new GeneralQueryHandler(session.getGorContext(), false)).setQueryEvaluator((QueryEvaluator)new SessionBasedQueryEvaluator((GorSession)session));
        SystemContext.Builder systemContextBuilder = new SystemContext.Builder();
        systemContextBuilder.setReportBuilder((GorReportBuilder)new FreemarkerReportBuilder((GorSession)session)).setRunnerFactory((GorRunnerFactory)new GenericRunnerFactory()).setServer(false).setStartTime(System.currentTimeMillis());
        GorSessionCache cache = GorSessionCacheManager.getCache((String)requestId);
        Object eventLogger = this.requestStatsEnabled ? new RequestStats((GorSession)session) : new DefaultEventLogger();
        session.init(projectContextBuilder.build(), systemContextBuilder.build(), cache, (EventLogger)eventLogger);
        return session;
    }
}

