/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.spark.platform;

import gorsat.Commands.CommandParseUtilities;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorQuery {
    private static final Logger log = LoggerFactory.getLogger(GorQuery.class);
    public static final String FLAG_PRESERVE = "P";
    public static final String FLAG_HIGH_PRIORITY = "H";
    public static final String FLAG_FORCE = "F";
    private static final long DEFAULT_QUERY_TIMEOUT_MILLI_SECONDS = 3600000L;
    private static final String QUERY_EXECUTION_START = "queryExecutionStart";
    private static final String QUERY_EXECUTION_END = "queryExecutionEnd";
    private static final String QUERY_BYTE_COUNT = "queryByteCount";
    private static final String QUERY_LINE_COUNT = "queryLineCount";
    private static final String QUERY_COLUMN_COUNT = "queryColumnCount";
    private static final String QUERY_RESULT_CACHE_EXPIRATION_MS = "queryResultCacheExpiration";
    private static final String QUERY_FIELD = "query";
    private static final String ORIGINAL_QUERY_FIELD = "originalQuery";
    private static final String QUERY_SOURCE_FIELD = "querySource";
    public static final String REQUEST_ID_FIELD = "request-id";
    private final Map<String, String> parms;
    public static final Set<String> fieldsToEncode = new HashSet<String>(Arrays.asList("query", "originalQuery"));

    public GorQuery() {
        this(new HashMap<String, String>());
    }

    public GorQuery(Map<String, String> parms) {
        this.parms = new HashMap<String, String>(parms);
    }

    public String getQuery() {
        return this.parms.get(QUERY_FIELD);
    }

    public void setQuery(String query) {
        this.parms.put(QUERY_FIELD, query);
    }

    public String getOriginalQuery() {
        return this.parms.get(ORIGINAL_QUERY_FIELD);
    }

    public void setOriginalQuery(String query) {
        this.parms.put(ORIGINAL_QUERY_FIELD, query);
    }

    public String getQuerySource() {
        String querySource = this.parms.get(QUERY_SOURCE_FIELD);
        return querySource == null ? "" : querySource;
    }

    public void setQuerySource(String requestID) {
        this.parms.put(QUERY_SOURCE_FIELD, GorQuery.blankNull(requestID));
    }

    public String getRequestId() {
        String requestID = this.parms.get(REQUEST_ID_FIELD);
        return requestID == null ? "" : requestID;
    }

    public void setRequestId(String requestID) {
        this.parms.put(REQUEST_ID_FIELD, GorQuery.blankNull(requestID));
    }

    public void setPartition(String partition) {
        this.parms.put("partition", GorQuery.blankNull(partition));
    }

    public String getPartition() {
        return GorQuery.blankNull(this.parms.get("partition"));
    }

    public String getOutfile() {
        return this.parms.get("outfile");
    }

    public void setOutfile(String outfile) {
        this.parms.put("outfile", outfile);
    }

    public int getProjectId() {
        String projectId = this.parms.get("project-id");
        return projectId != null ? Integer.parseInt(projectId) : -1;
    }

    public void setProjectId(int prjId) {
        this.parms.put("project-id", String.valueOf(prjId));
    }

    public String getFlags() {
        String flags = this.parms.get("flags");
        if (flags == null) {
            flags = "";
        }
        return flags;
    }

    public void setFlags(String flags) {
        this.parms.put("flags", flags);
    }

    public Map<String, String> toMap() {
        return new HashMap<String, String>(this.parms);
    }

    public boolean isFlagSet(String flag) {
        return this.getFlags().contains(flag);
    }

    public void setFlag(String flag) {
        if (this.isFlagSet(flag)) {
            return;
        }
        this.setFlags(this.getFlags() + flag);
    }

    public String getProjectRoot() {
        String root = this.parms.get("projectRoot");
        if (root == null) {
            root = this.parms.get("root");
        }
        return root;
    }

    public void setProjectRoot(String projectRoot) {
        this.parms.put("projectRoot", projectRoot);
    }

    public String getFingerprint() {
        return this.parms.get("fingerprint");
    }

    public void setExtension(String ext) {
        this.parms.put("extension", ext);
    }

    public static String blankNull(String s) {
        if (s != null && s.trim().isEmpty()) {
            return null;
        }
        return s;
    }

    public String getExtension() {
        String ext = GorQuery.blankNull(this.parms.get("extension"));
        if (ext != null) {
            return ext;
        }
        String out = this.getOutfile();
        if (out != null && (ext = FilenameUtils.getExtension((String)out)) != null && !ext.isEmpty()) {
            return "." + FilenameUtils.getExtension((String)out);
        }
        return CommandParseUtilities.getExtensionForQuery((String)this.getQuery(), (boolean)false);
    }

    public void setFingerprint(String fingerprint) {
        this.parms.put("fingerprint", GorQuery.blankNull(fingerprint));
    }

    public String getLockName() {
        String fp = this.getFingerprint();
        if (fp == null) {
            fp = this.getOutfile();
        }
        return this.getProject() + ":" + fp;
    }

    public String getProject() {
        String projectName = this.parms.get("projectname");
        if ((projectName == null || projectName.isEmpty()) && this.getProjectRoot() != null) {
            projectName = Paths.get(this.getProjectRoot(), new String[0]).getFileName().toString();
        }
        return projectName == null ? "" : projectName;
    }

    public void setProject(String projectName) {
        this.parms.put("projectname", GorQuery.blankNull(projectName));
    }

    public boolean useCache() {
        return this.getFingerprint() != null;
    }

    public String getOutfilePath() {
        String out = this.getOutfile();
        if (out == null) {
            return null;
        }
        return this.getProjectRoot() + "/" + out;
    }

    public void setSecurityContextKey(String securityContextKey) {
        this.parms.put("securityContextKey", securityContextKey);
    }

    public String getSecurityContextKey() {
        return this.parms.get("securityContextKey");
    }

    public String getUser() {
        String userName = this.parms.get("userName");
        return userName == null ? "" : userName;
    }

    public void setUser(String userName) {
        this.parms.put("userName", userName);
    }

    public long getQueryTimeout() {
        long timeoutMilliSeconds;
        try {
            timeoutMilliSeconds = Long.parseLong(this.parms.getOrDefault("queryTimeout", "3600000"));
        }
        catch (NumberFormatException nfe) {
            log.warn("Failed to parse queryTimeout, reverting to default timeout.");
            timeoutMilliSeconds = 3600000L;
        }
        return timeoutMilliSeconds;
    }

    public void setQueryTimeout(long milliseconds) {
        this.parms.put("queryTimeout", Long.valueOf(milliseconds).toString());
    }

    public Long getTime() {
        String t = this.parms.get("time");
        if (t != null) {
            return Long.parseLong(this.parms.get("time"));
        }
        return null;
    }

    public void setTime(Long time) {
        if (time == null) {
            this.parms.put("time", null);
        } else {
            this.parms.put("time", time.toString());
        }
    }

    public boolean hasQueryStatistics() {
        return this.parms.get(QUERY_EXECUTION_START) != null;
    }

    public void setResultCacheExpirationMs(long milliseconds) {
        this.parms.put(QUERY_RESULT_CACHE_EXPIRATION_MS, String.valueOf(milliseconds));
    }

    public long getResultCacheExpirationMs() {
        return Long.parseLong(this.parms.get(QUERY_RESULT_CACHE_EXPIRATION_MS));
    }

    public void setExecutionStartTime(long milliseconds) {
        this.parms.put(QUERY_EXECUTION_START, String.valueOf(milliseconds));
    }

    public long getExecutionStartTime() {
        return Long.parseLong(this.parms.get(QUERY_EXECUTION_START));
    }

    public void setExecutionEndTime(long milliseconds) {
        this.parms.put(QUERY_EXECUTION_END, String.valueOf(milliseconds));
    }

    public long getExecutionEndTime() {
        return Long.parseLong(this.parms.get(QUERY_EXECUTION_END));
    }

    public void setByteCount(long bytes) {
        this.parms.put(QUERY_BYTE_COUNT, String.valueOf(bytes));
    }

    public long getByteCount() {
        return Long.parseLong(this.parms.get(QUERY_BYTE_COUNT));
    }

    public void setLineCount(long lines) {
        this.parms.put(QUERY_LINE_COUNT, String.valueOf(lines));
    }

    public long getLineCount() {
        return Long.parseLong(this.parms.get(QUERY_LINE_COUNT));
    }

    public void setColumnCount(int columns) {
        this.parms.put(QUERY_COLUMN_COUNT, String.valueOf(columns));
    }

    public static boolean isStringInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isStringLong(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public int getColumnCount() {
        return Integer.parseInt(this.parms.get(QUERY_COLUMN_COUNT));
    }

    public boolean hasColumnCount() {
        return GorQuery.isStringInt(this.parms.get(QUERY_COLUMN_COUNT));
    }

    public boolean hasLineCount() {
        return GorQuery.isStringLong(this.parms.get(QUERY_LINE_COUNT));
    }

    public boolean hasByteCount() {
        return GorQuery.isStringLong(this.parms.get(QUERY_BYTE_COUNT));
    }

    public boolean hasExecutionEndTime() {
        return GorQuery.isStringLong(this.parms.get(QUERY_EXECUTION_END));
    }

    public boolean hasExecutionStartTime() {
        return GorQuery.isStringLong(this.parms.get(QUERY_EXECUTION_START));
    }

    public boolean hasResultCacheExpirationMs() {
        return GorQuery.isStringLong(this.parms.get(QUERY_RESULT_CACHE_EXPIRATION_MS));
    }

    public boolean overwriteExisting() {
        if (this.isFlagSet(FLAG_FORCE)) {
            return true;
        }
        if (this.getOutfile() != null && !this.getOutfile().isEmpty()) {
            return !this.isFlagSet(FLAG_PRESERVE);
        }
        return false;
    }
}

