/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import gorsat.Script.ScriptEngineFactory;
import gorsat.Script.ScriptExecutionEngine;
import gorsat.process.GorDataType;
import gorsat.process.SparkRowUtilities;
import gorsat.spark.GorRangeInputPartition;
import gorsat.spark.GorScanBuilder;
import gorsat.spark.GorWriteBuilder;
import gorsat.spark.ReceiveQueryHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.DataFormatException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.gorpipe.gor.driver.GorDriverFactory;
import org.gorpipe.gor.driver.meta.SourceReference;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.reference.ReferenceBuildDefaults;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.spark.GorSparkSession;
import org.gorpipe.spark.SparkSessionFactory;

public abstract class GorBatchTable
implements Table,
SupportsRead,
SupportsWrite,
SupportsPushDownFilters {
    String[] commands;
    String query;
    String path;
    String inputfilter;
    String filterFile;
    String filterColumn;
    String splitFile;
    String fchrom;
    int fstart = 0;
    int fstop = -1;
    String redisUri;
    String streamKey;
    String jobId;
    String cacheFile;
    String securityContext;
    String useCpp;
    StructType schema;
    boolean tag;
    String projectRoot;
    String cacheDir;
    String configFile;
    String aliasFile;
    Path ppath;
    FileSystem fs;
    boolean hadoopInfer;
    private static final Set<TableCapability> CAPABILITIES = new HashSet<TableCapability>(Arrays.asList(TableCapability.BATCH_READ, TableCapability.BATCH_WRITE, TableCapability.TRUNCATE));

    public GorBatchTable(String query, boolean tag, String path, String filter, String filterFile, String filterColumn, String splitFile, String seek, String redisUri, String streamKey, String jobId, String cacheFile, String securityContext, String useCpp, boolean hadoopInfer) throws IOException {
        this.init(query, tag, path, filter, filterFile, filterColumn, splitFile, seek, redisUri, streamKey, jobId, cacheFile, securityContext, useCpp, hadoopInfer);
    }

    public GorBatchTable(String query, boolean tag, String path, String filter, String filterFile, String filterColumn, String splitFile, String seek, StructType schema, String redisUri, String streamKey, String jobId, String cacheFile, String securityContext, String useCpp, boolean hadoopInfer) throws IOException {
        this.init(query, tag, path, filter, filterFile, filterColumn, splitFile, seek, redisUri, streamKey, jobId, cacheFile, securityContext, useCpp, hadoopInfer);
        this.schema = schema;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setAliasFile(String aliasFile) {
        this.aliasFile = aliasFile;
    }

    void checkSeek(String seek) {
        if (seek != null && seek.length() > 0) {
            String[] spl = seek.split(":");
            this.fchrom = spl[0];
            if (spl.length > 1) {
                String[] sspl = spl[1].split("-");
                this.fstart = Integer.parseInt(sspl[0]);
                if (sspl.length > 1) {
                    this.fstop = Integer.parseInt(sspl[1]);
                }
            }
        }
    }

    void init(String query, boolean tag, String path, String filter, String filterFile, String filterColumn, String splitFile, String seek, String redisUri, String streamKey, String jobId, String cacheFile, String securityContext, String useCpp, boolean hadoopInfer) throws IOException {
        this.query = query;
        this.projectRoot = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        this.cacheDir = "result_cache";
        this.tag = tag;
        this.path = path;
        this.inputfilter = filter;
        this.filterFile = filterFile;
        this.filterColumn = filterColumn;
        this.splitFile = splitFile;
        this.redisUri = redisUri;
        this.streamKey = streamKey;
        this.jobId = jobId;
        this.cacheFile = cacheFile;
        this.securityContext = securityContext;
        this.useCpp = useCpp;
        this.hadoopInfer = hadoopInfer;
        if (path != null) {
            path = path.replace("s3://", "s3a://");
            this.ppath = new Path(path);
            Configuration conf = new Configuration();
            conf.set("fs.s3a.connection.ssl.enabled", "false");
            conf.set("fs.s3a.path.style.access", "true");
            conf.set("fs.s3a.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem");
            conf.set("fs.s3a.change.detection.mode", "warn");
            conf.set("com.amazonaws.services.s3.enableV4", "true");
            conf.set("fs.s3a.committer.name", "partitioned");
            conf.set("fs.s3a.committer.staging.conflict-mode", "replace");
            conf.set("spark.delta.logStore.class", "org.apache.spark.sql.delta.storage.S3SingleDriverLogStore");
            conf.set("fs.s3a.aws.credentials.provider", "org.apache.hadoop.fs.s3a.AnonymousAWSCredentialsProvider");
            this.fs = this.ppath.getFileSystem(conf);
        }
        this.checkSeek(seek);
    }

    private String[] initCommands(String query) {
        String[] commands = null;
        if (query != null) {
            if (query.toLowerCase().startsWith("pgor") || query.toLowerCase().startsWith("partgor") || query.toLowerCase().startsWith("parallel")) {
                ReceiveQueryHandler receiveQueryHandler = new ReceiveQueryHandler();
                SparkSessionFactory sessionFactory = new SparkSessionFactory(null, this.projectRoot, this.cacheDir, this.configFile, this.aliasFile, this.securityContext, null, receiveQueryHandler);
                GorSparkSession gorPipeSession = (GorSparkSession)sessionFactory.create();
                ScriptExecutionEngine see = ScriptEngineFactory.create((GorContext)gorPipeSession.getGorContext());
                see.execute(new String[]{query}, false, false, "");
                commands = receiveQueryHandler.getCommandsToExecute();
            } else {
                commands = new String[]{query};
            }
        }
        return commands;
    }

    void inferSchema() {
        this.schema = Encoders.STRING().schema();
        SparkSessionFactory sessionFactory = new SparkSessionFactory(null, this.projectRoot, this.cacheDir, this.configFile, this.aliasFile, this.securityContext, null);
        GorSparkSession gorPipeSession = (GorSparkSession)sessionFactory.create();
        if (this.path != null) {
            String endingLowercase = this.path.substring(this.path.lastIndexOf(".")).toLowerCase();
            boolean isGorz = endingLowercase.equals(".gorz");
            try {
                InputStream is;
                if (this.hadoopInfer) {
                    RemoteIterator ri = this.fs.listFiles(this.ppath, true);
                    while (ri.hasNext()) {
                        LocatedFileStatus lfs = (LocatedFileStatus)ri.next();
                        if (lfs.isDirectory() || !lfs.getPath().getName().toLowerCase().endsWith(endingLowercase)) continue;
                        this.ppath = lfs.getPath();
                        break;
                    }
                    is = this.fs.open(this.ppath);
                } else if (gorPipeSession.getProjectContext().getFileReader().isDirectory(this.path)) {
                    Optional<java.nio.file.Path> ogorz;
                    java.nio.file.Path ppath = Paths.get(this.path, new String[0]);
                    if (!ppath.isAbsolute()) {
                        java.nio.file.Path root = Paths.get(this.projectRoot, new String[0]);
                        ppath = root.resolve(ppath);
                    }
                    is = (ogorz = Files.walk(ppath, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.toString().toLowerCase().endsWith(".gorz")).findFirst()).isPresent() ? gorPipeSession.getProjectContext().getFileReader().getInputStream(ogorz.get().toString()) : InputStream.nullInputStream();
                } else {
                    is = gorPipeSession.getProjectContext().getFileReader().getInputStream(this.path);
                }
                this.schema = SparkRowUtilities.inferSchema(is, this.path, false, isGorz);
            }
            catch (IOException | DataFormatException e) {
                throw new RuntimeException("Unable to infer schema from " + this.ppath, e);
            }
        } else if (this.commands != null) {
            int start;
            int i2;
            String cmd = this.commands[0];
            String[] cmds = new String[]{cmd};
            if (this.commands.length > 1 && (i2 = cmd.indexOf("-p")) > 0) {
                int k = cmd.indexOf(" ", i2 + 3);
                cmds = new String[]{cmd.substring(0, i2).trim() + " " + cmd.substring(k).trim()};
            }
            GorDataType gdt = SparkRowUtilities.gorCmdSchema(cmds, gorPipeSession);
            String[] headerArray = gdt.header;
            DataType[] dataTypes = new DataType[headerArray.length];
            for (int i3 = start = 0; i3 < dataTypes.length; ++i3) {
                dataTypes[i3] = gdt.dataTypeMap.getOrDefault(i3, DataTypes.StringType);
            }
            Stream<StructField> fieldStream = IntStream.range(0, headerArray.length).mapToObj(i -> new StructField(headerArray[i], dataTypes[i], true, Metadata.empty()));
            StructField[] fields = (StructField[])(this.tag ? Stream.concat(fieldStream, Stream.of(new StructField("Tag", DataTypes.StringType, true, Metadata.empty()))) : fieldStream).toArray(StructField[]::new);
            this.schema = new StructType(fields);
        }
    }

    public Scan build() {
        return null;
    }

    public Filter[] pushFilters(Filter[] filters) {
        return new Filter[0];
    }

    public Filter[] pushedFilters() {
        return new Filter[0];
    }

    public StructType schema() {
        if (this.commands == null) {
            this.commands = this.initCommands(this.query);
        }
        if (this.schema == null) {
            this.inferSchema();
        }
        return this.schema;
    }

    public String name() {
        return this.getClass().toString();
    }

    public Set<TableCapability> capabilities() {
        return CAPABILITIES;
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        return new GorWriteBuilder(){};
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap caseInsensitiveStringMap) {
        if (this.schema == null) {
            this.schema();
        }
        return new GorScanBuilder(this.schema, this.redisUri, this.streamKey, this.jobId, this.cacheFile, this.projectRoot, this.cacheDir, this.configFile, this.aliasFile, this.securityContext, this.useCpp){
            Filter[] pushedFilters;
            String filterChrom;
            int start;
            int stop;
            String filter;
            {
                this.pushedFilters = new Filter[0];
                this.filterChrom = GorBatchTable.this.fchrom;
                this.start = GorBatchTable.this.fstart;
                this.stop = GorBatchTable.this.fstop;
                this.filter = GorBatchTable.this.inputfilter;
            }

            public Filter[] pushFilters(Filter[] filters) {
                Filter[] ret;
                if (this.schema.size() > 2) {
                    String posName = this.schema.fieldNames()[1];
                    String lastName = this.schema.fieldNames()[this.schema.size() - 1];
                    Optional<Filter> chrOpt = Arrays.stream(filters).filter(f -> f instanceof EqualTo).filter(f -> ((EqualTo)f).attribute().equalsIgnoreCase("CHROM")).findFirst();
                    chrOpt.map(f -> ((EqualTo)f).value().toString()).ifPresent(s -> {
                        this.filterChrom = s;
                    });
                    Optional<Filter> inOpt = Arrays.stream(filters).filter(f -> f instanceof In).filter(f -> ((In)f).attribute().equalsIgnoreCase(lastName)).findFirst();
                    if (inOpt.isEmpty()) {
                        inOpt = Arrays.stream(filters).filter(f -> f instanceof EqualTo).filter(f -> ((EqualTo)f).attribute().equalsIgnoreCase(lastName)).findFirst();
                        inOpt.map(f -> ((EqualTo)f).value()).map(Object::toString).ifPresent(s -> {
                            this.filter = s;
                        });
                    } else {
                        inOpt.map(f -> Arrays.stream(((In)f).values()).map(Object::toString).collect(Collectors.joining(","))).ifPresent(s -> {
                            this.filter = s;
                        });
                    }
                    Optional<Filter> posGreatOpt = Arrays.stream(filters).filter(f -> f instanceof GreaterThan).filter(f -> ((GreaterThan)f).attribute().equalsIgnoreCase(posName)).findFirst();
                    if (posGreatOpt.isEmpty()) {
                        posGreatOpt = Arrays.stream(filters).filter(f -> f instanceof GreaterThanOrEqual).filter(f -> ((GreaterThanOrEqual)f).attribute().equalsIgnoreCase(posName)).findFirst();
                    }
                    posGreatOpt.ifPresent(f -> {
                        this.start = f instanceof GreaterThan ? ((Number)((GreaterThan)f).value()).intValue() - 1 : ((Number)((GreaterThanOrEqual)f).value()).intValue();
                    });
                    Optional<Filter> posGreatOptFinal = posGreatOpt;
                    Optional<Filter> posLessOpt = Arrays.stream(filters).filter(f -> f instanceof LessThan).filter(f -> ((LessThan)f).attribute().equalsIgnoreCase(posName)).findFirst();
                    if (posLessOpt.isEmpty()) {
                        posLessOpt = Arrays.stream(filters).filter(f -> f instanceof LessThanOrEqual).filter(f -> ((LessThanOrEqual)f).attribute().equalsIgnoreCase(posName)).findFirst();
                    }
                    posLessOpt.ifPresent(f -> {
                        this.stop = f instanceof LessThan ? ((Number)((LessThan)f).value()).intValue() : ((Number)((LessThanOrEqual)f).value()).intValue() + 1;
                    });
                    Optional<Filter> posLessOptFinal = posLessOpt;
                    ret = (Filter[])Arrays.stream(filters).filter(f -> chrOpt.isEmpty() || !f.equals(chrOpt.get()) && (posGreatOptFinal.isEmpty() || !f.equals(posGreatOptFinal.get())) && (posLessOptFinal.isEmpty() || !f.equals(posLessOptFinal.get()))).toArray(Filter[]::new);
                } else {
                    ret = new Filter[]{};
                }
                HashSet<Filter> fset = new HashSet<Filter>(Arrays.asList(ret));
                this.pushedFilters = (Filter[])Arrays.stream(filters).filter(f -> !fset.contains(f)).toArray(Filter[]::new);
                return ret;
            }

            public Filter[] pushedFilters() {
                return this.pushedFilters;
            }

            public InputPartition[] planInputPartitions() {
                InputPartition[] partitions = null;
                if (GorBatchTable.this.commands != null && GorBatchTable.this.commands.length > 0) {
                    partitions = (InputPartition[])Arrays.stream(GorBatchTable.this.commands).map(cmd -> {
                        int i;
                        String tagstr = null;
                        if (GorBatchTable.this.tag && (i = cmd.indexOf("-p ") + 3) > 2) {
                            int k;
                            while (i < cmd.length() && cmd.charAt(i) == ' ') {
                                ++i;
                            }
                            for (k = i + 1; k < cmd.length() && cmd.charAt(k) != ' '; ++k) {
                            }
                            tagstr = cmd.substring(i, k);
                        }
                        return new GorRangeInputPartition((String)cmd, tagstr);
                    }).toArray(GorRangeInputPartition[]::new);
                } else if (this.filterChrom != null) {
                    partitions = new InputPartition[]{new GorRangeInputPartition(GorBatchTable.this.path, this.filter, GorBatchTable.this.filterFile, GorBatchTable.this.filterColumn, this.filterChrom, this.start, this.stop, this.filterChrom)};
                } else {
                    block33: {
                        if (GorBatchTable.this.splitFile != null) {
                            partitions = new InputPartition[]{};
                            if (GorBatchTable.this.splitFile.toLowerCase().endsWith(".gorz")) {
                                SourceReference sourceReference = new SourceReference(GorBatchTable.this.splitFile);
                                try (GenomicIterator genomicIterator = GorDriverFactory.fromConfig().createIterator(sourceReference);){
                                    ArrayList<GorRangeInputPartition> listInputParitions = new ArrayList<GorRangeInputPartition>();
                                    while (genomicIterator.hasNext()) {
                                        Row row = (Row)genomicIterator.next();
                                        int end = row.colAsInt(2);
                                        GorRangeInputPartition gorRangeInputPartition = GorBatchTable.this.path != null ? new GorRangeInputPartition(GorBatchTable.this.path, this.filter, GorBatchTable.this.filterFile, GorBatchTable.this.filterColumn, row.chr, row.pos, end, (String)(row.numCols() > 3 ? row.colAsString(3).toString() : row.chr + ":" + row.pos + "-" + end)) : new GorRangeInputPartition(GorBatchTable.this.commands[0], row.chr, row.pos, end, (String)(row.numCols() > 3 ? row.colAsString(3).toString() : row.chr + ":" + row.pos + "-" + end));
                                        listInputParitions.add(gorRangeInputPartition);
                                    }
                                    partitions = (InputPartition[])listInputParitions.toArray(InputPartition[]::new);
                                    break block33;
                                }
                                catch (IOException e2) {
                                    throw new RuntimeException(e2);
                                }
                            }
                            try (Stream<String> fstream = Files.lines(Paths.get(GorBatchTable.this.splitFile, new String[0]));){
                                partitions = (InputPartition[])fstream.skip(1L).map(line -> line.split("\t")).map(s -> new GorRangeInputPartition(GorBatchTable.this.path, this.filter, GorBatchTable.this.filterFile, GorBatchTable.this.filterColumn, s[0], Integer.parseInt(s[1]), Integer.parseInt(s[2]), (String)(((String[])s).length > 3 ? s[3] : s[0] + ":" + s[1] + "-" + s[2]))).toArray(InputPartition[]::new);
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                    if (partitions == null && GorBatchTable.this.path != null) {
                        try {
                            Path dict = new Path(GorBatchTable.this.ppath, "dict.gord");
                            if (GorBatchTable.this.fs.exists(dict)) {
                                FSDataInputStream fis = GorBatchTable.this.fs.open(dict);
                                String dictStr = new String(fis.readAllBytes());
                                fis.close();
                                String[] dictSplit = dictStr.split("\n");
                                if (dictSplit[0].split("\t").length > 5) {
                                    partitions = (InputPartition[])Arrays.stream(dictSplit).map(f -> f.split("\t")).map(p -> new GorRangeInputPartition(p[0], this.filter, GorBatchTable.this.filterFile, GorBatchTable.this.filterColumn, p[2], Integer.parseInt(p[3]), Integer.parseInt(p[5]), p[1])).toArray(GorRangeInputPartition[]::new);
                                }
                            } else if (GorBatchTable.this.fs.getFileStatus(GorBatchTable.this.ppath).isDirectory()) {
                                String fname = GorBatchTable.this.ppath.getName();
                                RemoteIterator ri = GorBatchTable.this.fs.listFiles(GorBatchTable.this.ppath, false);
                                ArrayList<GorRangeInputPartition> lgorRange = new ArrayList<GorRangeInputPartition>();
                                while (ri.hasNext()) {
                                    LocatedFileStatus lfs = (LocatedFileStatus)ri.next();
                                    Path npath = lfs.getPath();
                                    if (!npath.getName().endsWith(fname.substring(fname.lastIndexOf(46)))) continue;
                                    String pathstr = npath.toString();
                                    if (pathstr.startsWith("file:")) {
                                        pathstr = pathstr.substring(5);
                                    }
                                    lgorRange.add(new GorRangeInputPartition(pathstr, this.filter, GorBatchTable.this.filterFile, GorBatchTable.this.filterColumn, null, 0, 250000000, npath.getName()));
                                }
                                partitions = (InputPartition[])lgorRange.toArray(GorRangeInputPartition[]::new);
                            }
                            if (partitions == null) {
                                Map buildSizeGeneric = ReferenceBuildDefaults.buildSizeGeneric();
                                partitions = (InputPartition[])buildSizeGeneric.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> new GorRangeInputPartition(GorBatchTable.this.path, this.filter, GorBatchTable.this.filterFile, GorBatchTable.this.filterColumn, (String)e.getKey(), 0, (Integer)e.getValue(), (String)e.getKey())).toArray(InputPartition[]::new);
                            }
                        }
                        catch (IOException e4) {
                            e4.printStackTrace();
                        }
                    }
                }
                return partitions;
            }
        };
    }

    public Transform[] partitioning() {
        return new Transform[]{Expressions.identity((String)"i")};
    }
}

