/*
 * Decompiled with CFR 0.152.
 */
package gorsat.spark;

import gorsat.BatchedPipeStepIteratorAdaptor;
import gorsat.BatchedReadSource;
import gorsat.process.GorPipe;
import gorsat.process.PipeInstance;
import gorsat.process.PipeOptions;
import gorsat.process.SparkPipeInstance;
import gorsat.spark.GorRangeInputPartition;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.types.StructType;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.RowBase;
import org.gorpipe.gor.monitor.GorMonitor;
import org.gorpipe.model.gor.RowObj;
import org.gorpipe.spark.GorSparkSession;
import org.gorpipe.spark.GorSparkUtilities;
import org.gorpipe.spark.SparkGorRow;
import org.gorpipe.spark.SparkSessionFactory;

public class GorPartitionReader
implements PartitionReader<InternalRow> {
    GenomicIterator iterator;
    SparkGorRow sparkRow;
    GorMonitor sparkGorMonitor;
    GorRangeInputPartition p;
    ExpressionEncoder.Serializer<Row> serializer;
    String redisUri;
    String streamKey;
    String jobId;
    String useCpp;
    String projectRoot;
    String cacheDir;
    String configFile;
    String aliasFile;
    String securityContext;
    boolean nor = false;

    public GorPartitionReader(StructType schema, GorRangeInputPartition gorRangeInputPartition, String redisUri, String streamKey, String jobId, String projectRoot, String cacheDir, String configFile, String aliasFile, String securityContext, String useCpp) {
        ExpressionEncoder encoder = RowEncoder.apply((StructType)schema);
        this.serializer = encoder.createSerializer();
        this.sparkRow = new SparkGorRow(schema);
        this.p = gorRangeInputPartition;
        this.redisUri = redisUri;
        this.streamKey = streamKey;
        this.jobId = jobId;
        this.useCpp = useCpp;
        this.projectRoot = projectRoot;
        this.cacheDir = cacheDir;
        this.configFile = configFile;
        this.aliasFile = aliasFile;
        this.securityContext = securityContext;
    }

    private String parseMultiplePaths(Path epath) {
        String epathstr = this.p.path;
        if (Files.isDirectory(epath, new LinkOption[0])) {
            try {
                epathstr = Files.walk(epath, new FileVisitOption[0]).skip(1L).map(Path::toString).filter(p -> p.endsWith(".gorz")).collect(Collectors.joining(" "));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return epathstr;
    }

    private GenomicIterator iteratorFromFile(SparkPipeInstance pi) {
        String s;
        boolean useNative = this.useCpp != null && this.useCpp.equalsIgnoreCase("true");
        String seek = useNative ? "cmd " : "gor ";
        Path epath = Paths.get(this.p.path, new String[0]);
        String epathstr = this.parseMultiplePaths(epath);
        String spath = useNative ? "cgor #(S:-p chr:pos) " + this.p.path + "}" : epathstr;
        String string = s = this.p.filterColumn != null && this.p.filterColumn.length() > 0 ? "-s " + this.p.filterColumn + " " : "";
        String path = seek + (this.p.filterFile == null ? (this.p.filter == null ? s + spath : s + "-f " + this.p.filter + " " + spath) : s + "-ff " + this.p.filterFile + " " + spath);
        String[] args = new String[]{path};
        PipeOptions options = new PipeOptions();
        options.parseOptions(args);
        pi.subProcessArguments(options);
        GenomicIterator rowSource = pi.theInputSource();
        if (this.p.chr != null && this.p.chr.length() > 0) {
            rowSource.seek(this.p.chr, this.p.start);
        }
        if (this.redisUri != null && this.redisUri.length() > 0) {
            return new BatchedReadSource((Iterator)rowSource, GorPipe.brsConfig(), rowSource.getHeader(), this.sparkGorMonitor);
        }
        return rowSource;
    }

    private GenomicIterator iteratorWithPipeSteps(PipeInstance pi) {
        pi.init(this.p.query, false, null);
        GenomicIterator rowSource = pi.theInputSource();
        if (this.p.chr != null && this.p.chr.length() > 0) {
            rowSource.seek(this.p.chr, this.p.start);
        }
        return new BatchedPipeStepIteratorAdaptor((Iterator)rowSource, pi.getPipeStep(), rowSource.getHeader(), GorPipe.brsConfig());
    }

    void initIterator() {
        this.sparkGorMonitor = GorSparkUtilities.getSparkGorMonitor(this.jobId, this.redisUri, this.streamKey);
        this.sparkGorMonitor.setCancelled(false);
        SparkSessionFactory sessionFactory = new SparkSessionFactory(null, this.projectRoot, this.cacheDir, this.configFile, this.aliasFile, this.securityContext, this.sparkGorMonitor);
        GorSparkSession gorPipeSession = (GorSparkSession)sessionFactory.create();
        SparkPipeInstance pi = new SparkPipeInstance(gorPipeSession.getGorContext());
        if (this.p.query != null) {
            this.iterator = this.iteratorWithPipeSteps(pi);
            this.nor = this.p.query.toLowerCase().startsWith("nor ") || this.p.query.toLowerCase().startsWith("norrows ") || this.p.query.toLowerCase().startsWith("norcmd ") || this.p.query.toLowerCase().startsWith("cmd -n ");
        } else {
            this.iterator = this.iteratorFromFile(pi);
        }
    }

    public boolean next() {
        boolean hasNext;
        if (this.iterator == null) {
            this.initIterator();
        }
        if (hasNext = this.iterator.hasNext()) {
            org.gorpipe.gor.model.Row gorrow = (org.gorpipe.gor.model.Row)this.iterator.next();
            if (this.nor) {
                String rowstr = gorrow.otherCols();
                int[] sa = RowObj.splitArray((CharSequence)rowstr);
                gorrow = new RowBase("chrN", 0, (CharSequence)rowstr, sa, null);
            }
            if (this.p.tag != null) {
                gorrow = gorrow.rowWithAddedColumn((CharSequence)this.p.tag);
            }
            hasNext = this.p.chr == null || gorrow.chr.equals(this.p.chr) && (this.p.end == -1 || gorrow.pos <= this.p.end);
            this.sparkRow.row = gorrow;
        }
        return hasNext;
    }

    public InternalRow get() {
        return this.serializer.apply((Object)this.sparkRow);
    }

    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }
}

