/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.gorpipe.driver.S3ASourceType;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.gor.driver.meta.DataType;
import org.gorpipe.gor.driver.meta.SourceReference;
import org.gorpipe.gor.driver.meta.SourceType;
import org.gorpipe.gor.driver.providers.stream.sources.StreamSource;
import org.gorpipe.gor.driver.providers.stream.sources.StreamSourceMetadata;

public class S3ASource
implements StreamSource {
    private final SourceReference sourceReference;
    private final Path path;
    private final FileSystem fs;
    private StreamSourceMetadata meta;

    public S3ASource(SourceReference sourceReference) {
        this(sourceReference, new Path(sourceReference.getUrl()));
    }

    S3ASource(SourceReference sourceReference, Path path) {
        this.sourceReference = sourceReference;
        this.path = path;
        Configuration conf = new Configuration();
        conf.set("fs.s3a.connection.ssl.enabled", "false");
        conf.set("fs.s3a.path.style.access", "true");
        conf.set("fs.s3a.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem");
        conf.set("fs.s3a.change.detection.mode", "warn");
        conf.set("com.amazonaws.services.s3.enableV4", "true");
        conf.set("fs.s3a.committer.name", "partitioned");
        conf.set("fs.s3a.committer.staging.conflict-mode", "replace");
        conf.set("spark.delta.logStore.class", "org.apache.spark.sql.delta.storage.S3SingleDriverLogStore");
        try {
            this.fs = path.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new GorResourceException("", "", (Throwable)e);
        }
    }

    public InputStream open() throws IOException {
        return this.fs.open(this.path);
    }

    public InputStream open(long start) throws IOException {
        FSDataInputStream is = this.fs.open(this.path);
        is.seek(start);
        return is;
    }

    public InputStream open(long start, long minLength) throws IOException {
        FSDataInputStream is = this.fs.open(this.path);
        is.seek(start);
        return is;
    }

    public String getName() {
        return this.sourceReference.getUrl();
    }

    public StreamSourceMetadata getSourceMetadata() throws IOException {
        if (this.meta == null) {
            FileStatus fileStatus = this.fs.getFileStatus(this.path);
            this.meta = new StreamSourceMetadata((StreamSource)this, this.getName(), Long.valueOf(fileStatus.getModificationTime()), Long.valueOf(fileStatus.getLen()), null, false);
        }
        return this.meta;
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        return this.fs.create(this.path);
    }

    public boolean supportsWriting() {
        return true;
    }

    public SourceReference getSourceReference() {
        return this.sourceReference;
    }

    public DataType getDataType() {
        return DataType.fromFileName((String)this.path.getName());
    }

    public boolean exists() {
        try {
            return this.fs.exists(this.path);
        }
        catch (IOException e) {
            throw new GorResourceException("Hadoop s3 exists failed", this.path.toString(), (Throwable)e);
        }
    }

    public boolean isDirectory() {
        try {
            FileStatus fileStatus = this.fs.getFileStatus(this.path);
            return fileStatus.isDirectory();
        }
        catch (IOException e) {
            throw new GorResourceException("Hadoop s3 isDirectory failed", this.path.toString(), (Throwable)e);
        }
    }

    public SourceType getSourceType() {
        return S3ASourceType.S3A;
    }

    public void close() throws IOException {
    }
}

