/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.gorpipe.driver.SQLSourceType;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.gor.driver.meta.DataType;
import org.gorpipe.gor.driver.meta.SourceReference;
import org.gorpipe.gor.driver.meta.SourceType;
import org.gorpipe.gor.driver.providers.stream.sources.StreamSource;
import org.gorpipe.gor.driver.providers.stream.sources.StreamSourceMetadata;
import org.gorpipe.spark.GorSparkUtilities;

public class SQLSource
implements StreamSource {
    private final SourceReference sourceReference;
    private final String table;
    private StreamSourceMetadata meta;
    private SparkSession spark;

    public SQLSource(SourceReference sourceReference) {
        this(sourceReference, sourceReference.getUrl());
    }

    SQLSource(SourceReference sourceReference, String table) {
        this.sourceReference = sourceReference;
        this.table = table.substring(6).toLowerCase();
        this.spark = GorSparkUtilities.getSparkSession();
    }

    public InputStream open() {
        return this.open(0L);
    }

    public InputStream open(long start) {
        return this.open(start, 0L);
    }

    public InputStream open(long start, long minLength) {
        throw new GorResourceException("Not implemented", this.table);
    }

    public String getName() {
        return this.sourceReference.getUrl();
    }

    public StreamSourceMetadata getSourceMetadata() {
        if (this.meta == null) {
            Dataset ds = this.spark.table(this.table);
            this.meta = new StreamSourceMetadata((StreamSource)this, this.getName(), Long.valueOf(Instant.now().toEpochMilli()), Long.valueOf(0L), "g" + ds.hashCode(), false);
        }
        return this.meta;
    }

    public OutputStream getOutputStream(boolean append) {
        throw new GorResourceException("Not implemented", this.table);
    }

    public boolean supportsWriting() {
        return true;
    }

    public boolean supportsLinks() {
        return false;
    }

    public SourceReference getSourceReference() {
        return this.sourceReference;
    }

    public DataType getDataType() {
        return DataType.GOR;
    }

    public boolean exists() {
        String[] tableNames = this.spark.sqlContext().tableNames();
        HashSet<String> tableSet = new HashSet<String>(Arrays.asList(tableNames));
        return tableSet.contains(this.table);
    }

    public SourceType getSourceType() {
        return SQLSourceType.SQL;
    }

    public void close() throws IOException {
    }
}

