/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SystemPropertyHelper {
    Map<String, String> oldValues = new HashMap<String, String>();

    public void setSystemProperty(String key, String value) {
        String oldValue = System.setProperty(key, value);
        this.oldValues.putIfAbsent(key, oldValue);
    }

    public void setSystemProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.setSystemProperty(entry.getKey(), entry.getValue());
        }
    }

    public void reset() {
        ArrayList<String> keys = new ArrayList<String>(this.oldValues.keySet());
        for (String key : keys) {
            String oldValue = this.oldValues.remove(key);
            if (oldValue == null) {
                System.getProperties().remove(key);
                continue;
            }
            System.setProperty(key, oldValue);
        }
    }
}

