/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.test.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;

public class FileTestUtils {
    private FileTestUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static File createTempDirectory(String prefix) throws IOException {
        File tempDirectory = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        tempDirectory.deleteOnExit();
        return tempDirectory;
    }

    public static File createTempFile(File directory, String fileName, String data) throws IOException {
        File tempFile = new File(directory, fileName);
        FileTestUtils.handleTempFile(tempFile, data);
        return tempFile;
    }

    private static void handleTempFile(File tempFile, String data) throws IOException {
        tempFile.deleteOnExit();
        FileUtils.writeStringToFile((File)tempFile, (String)data, (Charset)Charset.defaultCharset());
    }

    public static File createLinesFile(File directory, int lines) throws IOException {
        return FileTestUtils.createTempFile(directory, "lines_" + lines + ".txt", FileTestUtils.getLinesString(lines));
    }

    public static File createDummyGorFile(File directory) throws IOException {
        return FileTestUtils.createTempFile(directory, "dummy.gor", "chrom\tpos\ta\nchr1\t0\tb");
    }

    public static File createEmptyFile(File directory) throws IOException {
        return FileTestUtils.createTempFile(directory, "empty_file.txt", "");
    }

    public static File createGenericSmallGorFile(File directory) throws IOException {
        return FileTestUtils.createTempFile(directory, "generic.gor", "#Chrom\tgene_start\tgene_end\tGene_Symbol\nchr1\t11868\t14412\tDDX11L1\nchr1\t14362\t29806\tWASH7P\nchr1\t29553\t31109\tMIR1302-11\nchr1\t34553\t36081\tFAM138A\nchr1\t52472\t54936\tOR4G4P\nchr1\t62947\t63887\tOR4G11P\nchr1\t69090\t70008\tOR4F5\nchr1\t89294\t133566\tRP11-34P13.7\nchr1\t89550\t91105\tRP11-34P13.8\n");
    }

    public static File createGenericSmallGorFileBucket(File directory, String source) throws IOException {
        return FileTestUtils.createTempFile(directory, "generic_bucket.gor", "#Chrom\tgene_start\tgene_end\tGene_Symbol\tSource\nchr1\t11868\t14412\tDDX11L1\t" + source + "\nchr1\t14362\t29806\tWASH7P\t" + source + "\nchr1\t29553\t31109\tMIR1302-11\t" + source + "\nchr1\t34553\t36081\tFAM138A\t" + source + "\nchr1\t52472\t54936\tOR4G4P\t" + source + "\nchr1\t62947\t63887\tOR4G11P\t" + source + "\nchr1\t69090\t70008\tOR4F5\t" + source + "\nchr1\t89294\t133566\tRP11-34P13.7\t" + source + "\nchr1\t89550\t91105\tRP11-34P13.8\t" + source + "\n");
    }

    public static File createGenericDictionaryFile(File directory, String gorFilePath, String fileName) throws IOException {
        return FileTestUtils.createTempFile(directory, fileName, gorFilePath + "\ta\n" + gorFilePath + "\tb\n");
    }

    public static File createPNTxtFile(File directory) throws IOException {
        return FileTestUtils.createTempFile(directory, "pns.txt", "a\nb\n");
    }

    public static File createPNTsvFile(File directory) throws IOException {
        return FileTestUtils.createTempFile(directory, "pns.tsv", "#PN\na\nb\n");
    }

    public static void deleteFolder(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        });
    }

    public static boolean deleteFolder(File src) {
        if (src != null) {
            FileTestUtils.deleteFolderContents(src);
            src.delete();
            return true;
        }
        return false;
    }

    private static void deleteFolderContents(File src) {
        File[] files;
        if (src != null && (files = src.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileTestUtils.deleteFolder(file);
                    continue;
                }
                file.delete();
            }
        }
    }

    private static String getLinesString(int lines) {
        int digits = (int)Math.floor(Math.log10(lines));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines; ++i) {
            String format = "%0" + digits + "d";
            sb.append(String.format(format, i)).append("\n");
        }
        return sb.toString();
    }
}

