/*
 * Decompiled with CFR 0.152.
 */
package gosu.tools.ant;

import gosu.tools.ant.GosuMatchingTask;
import gw.lang.gosuc.simple.GosuCompiler;
import gw.lang.gosuc.simple.ICompilerDriver;
import gw.lang.gosuc.simple.SoutCompilerDriver;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Gosuc
extends GosuMatchingTask {
    private Path _src;
    private File _destDir;
    private Path _compileClasspath;
    private boolean _failOnError = true;
    private boolean _checkedArithmetic = false;
    private boolean _force = true;
    private Set<String> _scriptExtensions = new HashSet<String>(Arrays.asList("gs", "gsx", "gst", "gsp"));
    protected List<File> compileList = new ArrayList<File>();

    public void setSrcdir(Path srcDir) {
        if (this._src == null) {
            this._src = srcDir;
        } else {
            this._src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this._src;
    }

    public void setDestdir(File destDir) {
        this._destDir = destDir;
    }

    public File getDestdir() {
        return this._destDir;
    }

    public Path createClasspath() {
        if (this._compileClasspath == null) {
            this._compileClasspath = new Path(this.getProject());
        }
        return this._compileClasspath.createPath();
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    private Set<String> getScriptExtensions() {
        return this._scriptExtensions;
    }

    public void setFailOnError(boolean fail) {
        this._failOnError = fail;
    }

    public boolean getFailOnError() {
        return this._failOnError;
    }

    public boolean isCheckedArithmetic() {
        return this._checkedArithmetic;
    }

    public void setCheckedArithmetic(boolean checkedArithmetic) {
        this._checkedArithmetic = checkedArithmetic;
    }

    public boolean isForce() {
        return this._force;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        if (!this.isForce()) {
            this.log("Relying on ant's SourceFileScanner, which only looks at timestamps.  If broken references result, try setting option 'force' to true.", 1);
        }
        for (String extension : this.getScriptExtensions()) {
            m.setFrom("*." + extension);
            m.setTo("*.class");
            this.log("Scanning for *." + extension + " files...", 4);
            List<File> newFiles = this.isForce() ? this.asFiles(srcDir, files, (FileNameMapper)m) : Arrays.asList(sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m));
            this.log("Found these files:", 4);
            for (File newFile : newFiles) {
                this.log('\t' + newFile.getAbsolutePath(), 4);
            }
            this.compileList.addAll(newFiles);
        }
    }

    private List<File> asFiles(File srcDir, String[] files, FileNameMapper m) {
        ArrayList<File> newFiles = new ArrayList<File>();
        for (String file : files) {
            boolean hasMatchingExtension;
            boolean bl = hasMatchingExtension = m.mapFileName(file) != null;
            if (!hasMatchingExtension) continue;
            newFiles.add(new File(srcDir, file));
        }
        return newFiles;
    }

    public List<File> getFileList() {
        return this.compileList;
    }

    public void execute() throws BuildException {
        this.log("srcdir=" + this.getSrcdir(), 4);
        this.log("destdir=" + this.getDestdir(), 4);
        this.log("failOnError=" + this.getFailOnError(), 4);
        this.log("checkedArithmetic=" + this.isCheckedArithmetic(), 4);
        this.log("_compileClasspath=" + this._compileClasspath, 4);
        if (this.isCheckedArithmetic()) {
            System.setProperty("checkedArithmetic", "true");
        }
        SoutCompilerDriver driver = new SoutCompilerDriver();
        GosuCompiler gosuc = new GosuCompiler();
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.addAll(Arrays.asList(this._compileClasspath.list()));
        classpath.addAll(this.getJreJars());
        this.log("Initializing Gosu compiler...", 2);
        this.log("\tsourceFolders:" + Arrays.asList(this.getSrcdir().list()), 4);
        this.log("\tclasspath:" + classpath, 4);
        this.log("\toutputPath:" + this.getDestdir().getAbsolutePath(), 4);
        String[] list = this.getSrcdir().list();
        for (String filename : list) {
            File file = this.getProject().resolveFile(filename);
            if (!file.exists()) {
                throw new BuildException("srcdir \"" + file.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(file);
            String[] files = ds.getIncludedFiles();
            this.scanDir(file, this._destDir != null ? this._destDir : file, files);
        }
        gosuc.initializeGosu(Arrays.asList(this.getSrcdir().list()), classpath, this.getDestdir().getAbsolutePath());
        this.log("About to compile these files:", 4);
        for (File file : this.compileList) {
            this.log("\t" + file.getAbsolutePath(), 4);
        }
        for (File file : this.compileList) {
            try {
                gosuc.compile(file, (ICompilerDriver)driver);
            }
            catch (Exception e) {
                this.log(e.getMessage(), 0);
                throw new BuildException((Throwable)e);
            }
        }
        gosuc.unitializeGosu();
        List warnings = driver.getWarnings();
        boolean errorsInCompilation = driver.hasErrors();
        List errors = driver.getErrors();
        ArrayList warningMessages = new ArrayList();
        ArrayList errorMessages = new ArrayList();
        warnings.forEach(warning -> warningMessages.add("[WARNING] " + warning));
        int numWarnings = warningMessages.size();
        int numErrors = 0;
        if (errorsInCompilation) {
            errors.forEach(error -> errorMessages.add("[ERROR] " + error));
            numErrors = errorMessages.size();
        }
        boolean hasWarningsOrErrors = numWarnings > 0 || errorsInCompilation;
        StringBuilder sb = new StringBuilder();
        sb.append("Gosu compilation completed");
        if (hasWarningsOrErrors) {
            sb.append(" with ");
            if (numWarnings > 0) {
                sb.append(numWarnings).append(" warning").append(numWarnings == 1 ? "" : Character.valueOf('s'));
            }
            if (errorsInCompilation) {
                sb.append(numWarnings > 0 ? " and " : "");
                sb.append(numErrors).append(" error").append(numErrors == 1 ? "" : Character.valueOf('s'));
            }
        } else {
            sb.append(" successfully.");
        }
        sb.append(hasWarningsOrErrors ? Character.valueOf(':') : "");
        this.log(sb.toString(), hasWarningsOrErrors ? 1 : 2);
        warningMessages.forEach(arg_0 -> ((Gosuc)this).log(arg_0));
        errorMessages.forEach(arg_0 -> ((Gosuc)this).log(arg_0));
        if (errorsInCompilation) {
            if (this.getFailOnError()) {
                this.buildError("Gosu compilation failed with errors; see compiler output for details.");
            } else {
                this.log("Gosu Compiler: Ignoring compilation failure(s) as 'failOnError' was set to false", 1);
            }
        }
    }

    private List<String> getJreJars() {
        String javaHome = System.getProperty("java.home");
        java.nio.file.Path libsDir = FileSystems.getDefault().getPath(javaHome, "/lib");
        try {
            return Files.walk(libsDir, new FileVisitOption[0]).filter(path -> path.toFile().isFile()).filter(path -> path.toString().endsWith(".jar")).map(java.nio.file.Path::toString).collect(Collectors.toList());
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

